/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver
implements XMLNamespaceResolver {
    private static final String BASE_PREFIX = "ns";
    private String defaultNamespaceURI;
    private Properties namespaces = new Properties();
    int prefixCounter;
    private Node dom;

    public void setDOM(Node node) {
        this.dom = node;
    }

    public String resolveNamespacePrefix(String string) {
        if (null == string) {
            return this.defaultNamespaceURI;
        }
        String string2 = this.namespaces.getProperty(string);
        if (string2 == null && string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        }
        return string2;
    }

    public String resolveNamespaceURI(String string) {
        if (null == string) {
            return null;
        }
        Enumeration<Object> enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.namespaces.getProperty(string2).equals(string)) continue;
            return string2;
        }
        if (string.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (string.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.resolveNamespaceURI(this.dom, string);
    }

    private String resolveNamespaceURI(Node node, String string) {
        if (null == node) {
            return null;
        }
        if (string.equals(node.getNamespaceURI())) {
            return node.getPrefix();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != namedNodeMap) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(node2.getNamespaceURI()) || !string.equals(node2.getNodeValue())) continue;
                return node2.getLocalName();
            }
        }
        return this.resolveNamespaceURI(node.getParentNode(), string);
    }

    public void put(String string, String string2) {
        this.namespaces.setProperty(string, string2);
    }

    public Enumeration getPrefixes() {
        return this.namespaces.keys();
    }

    public Vector getNamespaces() {
        Vector<Namespace> vector = new Vector<Namespace>(this.namespaces.size());
        Enumeration<Object> enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.namespaces.get(string);
            Namespace namespace = new Namespace(string, string2);
            vector.addElement(namespace);
        }
        return vector;
    }

    public void setNamespaces(Vector vector) {
        this.namespaces = new Properties();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Namespace namespace = (Namespace)enumeration.nextElement();
            if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) continue;
            this.namespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    public String generatePrefix() {
        String string = this.getNextPrefix();
        return this.generatePrefix(string);
    }

    private String getNextPrefix() {
        return BASE_PREFIX + this.prefixCounter++;
    }

    public String generatePrefix(String string) {
        String string2 = this.resolveNamespacePrefix(string);
        while (string2 != null) {
            string = this.getNextPrefix();
            string2 = this.resolveNamespacePrefix(string);
        }
        return string;
    }

    public void removeNamespace(String string) {
        this.namespaces.remove(string);
    }

    public void setDefaultNamespaceURI(String string) {
        this.defaultNamespaceURI = string;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }
}

