/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.jdbc;

import java.sql.Array;
import java.sql.Struct;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JDBCTypes implements JDBCType
{
    ARRAY_TYPE(2003, "ARRAY"),
    BIGINT_TYPE(-5, "BIGINT"),
    BINARY_TYPE(-2, "BINARY"),
    BIT_TYPE(-7, "BIT"),
    BLOB_TYPE(2004, "BLOB"),
    BOOLEAN_TYPE(16, "BOOLEAN"),
    CHAR_TYPE(1, "CHAR"),
    CLOB_TYPE(2005, "CLOB"),
    DATALINK_TYPE(70, "DATALINK"),
    DATE_TYPE(91, "DATE"),
    DECIMAL_TYPE(3, "DECIMAL"),
    DISTINCT_TYPE(2001, "DISTINCT"),
    DOUBLE_TYPE(8, "DOUBLE"),
    FLOAT_TYPE(6, "FLOAT"),
    INTEGER_TYPE(4, "INTEGER"),
    JAVA_OBJECT_TYPE(2000, "JAVA_OBJECT"),
    LONGVARBINARY_TYPE(-4, "LONGVARBINARY"),
    LONGVARCHAR_TYPE(-1, "LONGVARCHAR"),
    NULL_TYPE(0, "NULL"),
    NUMERIC_TYPE(2, "NUMERIC"){

        protected void buildInitialDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
            if (pLSQLargument.precision != Integer.MIN_VALUE) {
                stringBuilder.append("(");
                stringBuilder.append(pLSQLargument.precision);
                if (pLSQLargument.scale != Integer.MIN_VALUE) {
                    stringBuilder.append(",");
                    stringBuilder.append(pLSQLargument.scale);
                }
                stringBuilder.append(")");
            }
        }

        public void buildInDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            this.buildInitialDeclare(stringBuilder, pLSQLargument);
            stringBuilder.append(" := :");
            stringBuilder.append(pLSQLargument.inIndex);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
        }

        public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            this.buildInitialDeclare(stringBuilder, pLSQLargument);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
        }
    }
    ,
    OTHER_TYPE(1111, "OTHER"),
    REAL_TYPE(7, "REAL"),
    REF_TYPE(2006, "REF"),
    SMALLINT_TYPE(5, "SMALLINT"),
    STRUCT_TYPE(2002, "STRUCT"),
    TIME_TYPE(92, "TIME"),
    TIMESTAMP_TYPE(93, "TIMESTAMP"),
    TINYINT_TYPE(-6, "TINYINT"),
    VARBINARY_TYPE(-3, "VARBINARY"),
    VARCHAR_TYPE(12, "VARCHAR"){

        protected void buildInitialDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
            if (pLSQLargument.length != Integer.MIN_VALUE) {
                stringBuilder.append("(");
                stringBuilder.append(pLSQLargument.length);
                stringBuilder.append(")");
            }
        }

        public void buildInDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            this.buildInitialDeclare(stringBuilder, pLSQLargument);
            stringBuilder.append(" := :");
            stringBuilder.append(pLSQLargument.inIndex);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
        }

        public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            this.buildInitialDeclare(stringBuilder, pLSQLargument);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
        }
    };

    private final int typeCode;
    private final String typeName;

    private JDBCTypes(int n2, String string2) {
        this.typeCode = n2;
        this.typeName = string2;
    }

    @Override
    public boolean isComplexDatabaseType() {
        return false;
    }

    @Override
    public boolean isJDBCType() {
        return true;
    }

    @Override
    public int getSqlCode() {
        return this.typeCode;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int computeInIndex(PLSQLargument pLSQLargument, int n, ListIterator<PLSQLargument> listIterator) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(pLSQLargument, n);
    }

    @Override
    public int computeOutIndex(PLSQLargument pLSQLargument, int n, ListIterator<PLSQLargument> listIterator) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(pLSQLargument, n);
    }

    @Override
    public void buildInDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
        stringBuilder.append(" := :");
        stringBuilder.append(pLSQLargument.inIndex);
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildBeginBlock(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
    }

    @Override
    public void buildOutAssignment(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutAssignment(stringBuilder, pLSQLargument, pLSQLStoredProcedureCall);
    }

    @Override
    public void translate(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, Vector vector, Vector vector2, Vector vector3, StoredProcedureCall storedProcedureCall) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(pLSQLargument, abstractRecord, abstractRecord2, vector, vector2, vector3, storedProcedureCall);
    }

    @Override
    public void buildOutputRow(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabaseRecord databaseRecord, Vector vector, Vector vector2) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(pLSQLargument, abstractRecord, databaseRecord, vector, vector2);
    }

    @Override
    public void logParameter(StringBuilder stringBuilder, Integer n, PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabasePlatform databasePlatform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(stringBuilder, n, pLSQLargument, abstractRecord, databasePlatform);
    }

    public static DatabaseType getDatabaseTypeForCode(int n) {
        JDBCTypes jDBCTypes = null;
        switch (n) {
            case 2003: {
                jDBCTypes = ARRAY_TYPE;
                break;
            }
            case -5: {
                jDBCTypes = BIGINT_TYPE;
                break;
            }
            case -2: {
                jDBCTypes = BINARY_TYPE;
                break;
            }
            case -7: {
                jDBCTypes = BIT_TYPE;
                break;
            }
            case 2004: {
                jDBCTypes = BLOB_TYPE;
                break;
            }
            case 16: {
                jDBCTypes = BOOLEAN_TYPE;
                break;
            }
            case 1: {
                jDBCTypes = CHAR_TYPE;
                break;
            }
            case 2005: {
                jDBCTypes = CLOB_TYPE;
                break;
            }
            case 70: {
                jDBCTypes = DATALINK_TYPE;
                break;
            }
            case 91: {
                jDBCTypes = DATE_TYPE;
                break;
            }
            case 3: {
                jDBCTypes = DECIMAL_TYPE;
                break;
            }
            case 2001: {
                jDBCTypes = DISTINCT_TYPE;
                break;
            }
            case 8: {
                jDBCTypes = DOUBLE_TYPE;
                break;
            }
            case 6: {
                jDBCTypes = FLOAT_TYPE;
                break;
            }
            case 4: {
                jDBCTypes = INTEGER_TYPE;
                break;
            }
            case 2000: {
                jDBCTypes = JAVA_OBJECT_TYPE;
                break;
            }
            case -4: {
                jDBCTypes = LONGVARBINARY_TYPE;
                break;
            }
            case -1: {
                jDBCTypes = LONGVARCHAR_TYPE;
                break;
            }
            case 0: {
                jDBCTypes = NULL_TYPE;
                break;
            }
            case 2: {
                jDBCTypes = NUMERIC_TYPE;
                break;
            }
            case 1111: {
                jDBCTypes = OTHER_TYPE;
                break;
            }
            case 7: {
                jDBCTypes = REAL_TYPE;
                break;
            }
            case 2006: {
                jDBCTypes = REF_TYPE;
                break;
            }
            case 5: {
                jDBCTypes = SMALLINT_TYPE;
                break;
            }
            case 2002: {
                jDBCTypes = STRUCT_TYPE;
                break;
            }
            case 92: {
                jDBCTypes = TIME_TYPE;
                break;
            }
            case 93: {
                jDBCTypes = TIMESTAMP_TYPE;
                break;
            }
            case -6: {
                jDBCTypes = TINYINT_TYPE;
                break;
            }
            case -3: {
                jDBCTypes = VARBINARY_TYPE;
                break;
            }
            case 12: {
                jDBCTypes = VARCHAR_TYPE;
            }
        }
        return jDBCTypes;
    }

    public static Class<?> getClassForCode(int n) {
        Class clazz = ClassConstants.STRING;
        switch (n) {
            case 2003: {
                clazz = Array.class;
                break;
            }
            case -5: 
            case 2: 
            case 3: {
                clazz = ClassConstants.BIGDECIMAL;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                clazz = ClassConstants.BLOB;
                break;
            }
            case 2005: {
                clazz = ClassConstants.CLOB;
                break;
            }
            case 16: {
                clazz = ClassConstants.BOOLEAN;
                break;
            }
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2006: {
                clazz = ClassConstants.Object_Class;
                break;
            }
            case 0: {
                clazz = ClassConstants.Void_Class;
                break;
            }
            case 91: {
                clazz = ClassConstants.JavaSqlDate_Class;
                break;
            }
            case 93: {
                clazz = ClassConstants.JavaSqlTimestamp_Class;
                break;
            }
            case 8: {
                clazz = ClassConstants.DOUBLE;
                break;
            }
            case 6: 
            case 7: {
                clazz = ClassConstants.FLOAT;
                break;
            }
            case 4: {
                clazz = ClassConstants.INTEGER;
                break;
            }
            case -7: 
            case -6: 
            case 5: {
                clazz = ClassConstants.SHORT;
                break;
            }
            case 2002: {
                clazz = Struct.class;
                break;
            }
            case 92: {
                clazz = ClassConstants.JavaSqlTime_Class;
            }
        }
        return clazz;
    }
}

