/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public class DeleteObjectQuery
extends ObjectLevelModifyQuery {
    protected boolean isFullRowRequired = false;

    public DeleteObjectQuery() {
    }

    public DeleteObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public DeleteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public boolean isFullRowRequired() {
        return this.isFullRowRequired;
    }

    public void setIsFullRowRequired(boolean bl) {
        this.isFullRowRequired = bl;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkDescriptor(abstractSession);
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && descriptorQueryManager.hasDeleteQuery()) {
            return descriptorQueryManager.getDeleteQuery();
        }
        return null;
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        Object object = unitOfWorkImpl.processDeleteObjectQuery(this);
        if (object != null) {
            return object;
        }
        return super.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWorkImpl, abstractRecord);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultDeleteObjectQueryRedirector();
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        AbstractSession abstractSession = this.getSession();
        CommitManager commitManager = abstractSession.getCommitManager();
        Object object = this.getObject();
        boolean bl = abstractSession.isUnitOfWork();
        try {
            int n;
            ClassDescriptor classDescriptor;
            DescriptorEventManager descriptorEventManager;
            if (commitManager.isProcessedCommit(object)) {
                return object;
            }
            commitManager.markPreModifyCommitInProgress(this.getObject());
            if (!bl) {
                abstractSession.beginTransaction();
            }
            if ((descriptorEventManager = (classDescriptor = this.getDescriptor()).getEventManager()).hasAnyEventListeners()) {
                descriptorEventManager.executeEvent(new DescriptorEvent(2, this));
            }
            if (this.shouldCascadeParts()) {
                classDescriptor.getQueryManager().preDelete(this);
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                DescriptorEvent descriptorEvent = new DescriptorEvent(14, this);
                descriptorEvent.setRecord(this.getModifyRow());
                descriptorEventManager.executeEvent(descriptorEvent);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementDelete(this);
            }
            if ((n = this.getQueryMechanism().deleteObject().intValue()) < 1) {
                abstractSession.getEventManager().noRowsModified(this, object);
            }
            if (classDescriptor.usesOptimisticLocking()) {
                classDescriptor.getOptimisticLockingPolicy().validateDelete(n, object, this);
            }
            commitManager.markPostModifyCommitInProgress(this.getObject());
            if (this.shouldCascadeParts()) {
                classDescriptor.getQueryManager().postDelete(this);
            }
            if (classDescriptor.getHistoryPolicy() != null && classDescriptor.getHistoryPolicy().shouldHandleWrites()) {
                classDescriptor.getHistoryPolicy().postDelete(this);
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                descriptorEventManager.executeEvent(new DescriptorEvent(3, this));
            }
            if (!bl) {
                abstractSession.commitTransaction();
            }
            commitManager.markCommitCompleted(object);
            if (this.shouldMaintainCache()) {
                if (bl) {
                    ((UnitOfWorkImpl)abstractSession).addObjectDeletedDuringCommit(object, classDescriptor);
                } else {
                    abstractSession.getIdentityMapAccessorInstance().removeFromIdentityMap(this.getPrimaryKey(), classDescriptor.getJavaClass(), classDescriptor, object);
                }
            }
            return object;
        }
        catch (RuntimeException runtimeException) {
            if (!bl) {
                abstractSession.rollbackTransaction();
            }
            commitManager.markCommitCompleted(object);
            throw runtimeException;
        }
    }

    public boolean isDeleteObjectQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareDeleteObject();
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        DeleteObjectQuery deleteObjectQuery = (DeleteObjectQuery)databaseQuery;
        deleteObjectQuery.setObject(this.getObject());
        deleteObjectQuery.setObjectChangeSet(this.getObjectChangeSet());
        deleteObjectQuery.setCascadePolicy(this.getCascadePolicy());
        deleteObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.translationRow == null || this.translationRow.isEmpty()) {
            this.translationRow = this.isFullRowRequired ? this.descriptor.getObjectBuilder().buildRow(this.object, this.session) : this.descriptor.getObjectBuilder().buildRowForTranslation(this.object, this.session);
        }
        if (this.descriptor.usesOptimisticLocking()) {
            this.descriptor.getOptimisticLockingPolicy().addLockValuesToTranslationRow(this);
        }
    }
}

