/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class InsertObjectQuery
extends WriteObjectQuery {
    public InsertObjectQuery() {
    }

    public InsertObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public InsertObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void executeCommit() throws DatabaseException {
        QueryRedirector queryRedirector = this.getRedirector();
        if (queryRedirector != null) {
            this.redirectQuery(queryRedirector, this, this.session, this.translationRow);
            return;
        }
        if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException {
        this.executeCommit();
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultInsertObjectQueryRedirector();
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareInsertObject();
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkDescriptor(abstractSession);
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && descriptorQueryManager.hasInsertQuery()) {
            return descriptorQueryManager.getInsertQuery();
        }
        return null;
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        InsertObjectQuery insertObjectQuery = (InsertObjectQuery)databaseQuery;
        insertObjectQuery.setObject(this.getObject());
        insertObjectQuery.setObjectChangeSet(this.getObjectChangeSet());
        insertObjectQuery.setCascadePolicy(this.getCascadePolicy());
        insertObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        insertObjectQuery.setModifyRow(null);
    }

    public boolean isInsertObjectQuery() {
        return true;
    }
}

