/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ResultSetMappingQuery
extends ObjectBuildingQuery {
    protected String resultSetMappingName;
    protected SQLResultSetMapping resultSetMapping;

    public ResultSetMappingQuery() {
    }

    public ResultSetMappingQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ResultSetMappingQuery(Call call, String string) {
        this();
        this.setCall(call);
        this.resultSetMappingName = string;
    }

    public void cacheResult(Object object) {
        Object object2 = object;
        if (this.shouldUseWrapperPolicy()) {
            object2 = this.getSession().wrapObject(object);
        }
        this.setTemporaryCachedQueryResults(object2);
    }

    public Object clone() {
        ResultSetMappingQuery resultSetMappingQuery = (ResultSetMappingQuery)super.clone();
        resultSetMappingQuery.resultSetMapping = this.resultSetMapping;
        resultSetMappingQuery.resultSetMappingName = this.resultSetMappingName;
        return resultSetMappingQuery;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        this.resultSetMapping.convertClassNamesToClasses(classLoader);
    }

    public void setSQLResultSetMapping(SQLResultSetMapping sQLResultSetMapping) {
        this.resultSetMapping = sQLResultSetMapping;
        this.resultSetMappingName = sQLResultSetMapping.getName();
    }

    public void setSQLResultSetMappingName(String string) {
        if (string != null || this.resultSetMapping == null) {
            // empty if block
        }
        this.resultSetMappingName = string;
    }

    protected List buildObjectsFromRecords(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        SQLResultSetMapping sQLResultSetMapping = this.getSQLResultSetMapping();
        if (sQLResultSetMapping == null) {
            for (DatabaseRecord databaseRecord : list) {
                arrayList.add(databaseRecord.values().toArray());
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                if (sQLResultSetMapping.getResults().size() > 1) {
                    object = new Object[sQLResultSetMapping.getResults().size()];
                    DatabaseRecord databaseRecord = (DatabaseRecord)iterator.next();
                    for (int i = 0; i < sQLResultSetMapping.getResults().size(); ++i) {
                        object[i] = ((SQLResult)sQLResultSetMapping.getResults().get(i)).getValueFromRecord(databaseRecord, this);
                    }
                    arrayList.add(object);
                    continue;
                }
                if (sQLResultSetMapping.getResults().size() == 1) {
                    object = (DatabaseRecord)iterator.next();
                    arrayList.add(((SQLResult)sQLResultSetMapping.getResults().get(0)).getValueFromRecord((DatabaseRecord)object, this));
                    continue;
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        Cloneable cloneable;
        if (this.getSession().isUnitOfWork()) {
            cloneable = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !((UnitOfWorkImpl)cloneable).getCommitManager().isActive() && !((UnitOfWorkImpl)cloneable).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)cloneable).beginTransaction();
                ((UnitOfWorkImpl)cloneable).setWasTransactionBegunPrematurely(true);
            }
            if (((UnitOfWorkImpl)cloneable).isNestedUnitOfWork()) {
                UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
                this.setSession(unitOfWorkImpl.getParent());
                Object object = this.executeDatabaseQuery();
                this.setSession(unitOfWorkImpl);
                Object object2 = this.registerIndividualResult(object, (UnitOfWorkImpl)cloneable, null);
                if (this.shouldUseWrapperPolicy()) {
                    object2 = this.getDescriptor().getObjectBuilder().wrapObject(object2, (AbstractSession)cloneable);
                }
                return object2;
            }
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        cloneable = this.getQueryMechanism().executeSelect();
        this.setExecutionTime(System.currentTimeMillis());
        return this.buildObjectsFromRecords((List)((Object)cloneable));
    }

    protected void prepare() {
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        this.getQueryMechanism().prepare();
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public SQLResultSetMapping getSQLResultSetMapping() {
        if (this.resultSetMapping == null && this.resultSetMappingName != null) {
            this.resultSetMapping = this.getSession().getProject().getSQLResultSetMapping(this.resultSetMappingName);
        }
        return this.resultSetMapping;
    }

    public String getSQLResultSetMappingName() {
        return this.resultSetMappingName;
    }
}

