/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class UpdateObjectQuery
extends WriteObjectQuery {
    public UpdateObjectQuery() {
    }

    public UpdateObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public UpdateObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        QueryRedirector queryRedirector = this.getRedirector();
        if (queryRedirector != null) {
            this.redirectQuery(queryRedirector, this, this.session, this.translationRow);
            return;
        }
        this.getQueryMechanism().updateObjectForWrite();
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        QueryRedirector queryRedirector = this.getRedirector();
        if (queryRedirector != null) {
            this.redirectQuery(queryRedirector, this, this.session, this.translationRow);
            return;
        }
        this.getQueryMechanism().updateObjectForWriteWithChangeSet();
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareUpdateObject();
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkDescriptor(abstractSession);
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && descriptorQueryManager.hasUpdateQuery()) {
            return descriptorQueryManager.getUpdateQuery();
        }
        return null;
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        UpdateObjectQuery updateObjectQuery = (UpdateObjectQuery)databaseQuery;
        updateObjectQuery.setObject(this.getObject());
        updateObjectQuery.setObjectChangeSet(this.getObjectChangeSet());
        updateObjectQuery.setCascadePolicy(this.getCascadePolicy());
        updateObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        updateObjectQuery.setModifyRow(null);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultUpdateObjectQueryRedirector();
    }

    public boolean isUpdateObjectQuery() {
        return true;
    }
}

