/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;

public abstract class DatasourceLogin
implements Login,
Serializable,
Cloneable {
    private static final String versionStringTemplate = "{0} - {1}";
    public static String versionString = null;
    protected Properties properties;
    protected Platform platform;
    private boolean isEncryptedPasswordSet;
    private transient SecurableObjectHolder securableObjectHolder;
    protected Connector connector;
    protected boolean usesExternalConnectionPooling;
    protected boolean usesExternalTransactionController;
    protected int cacheTransactionIsolation = 5;
    public static final int CONCURRENT_READ_WRITE = 1;
    public static final int SYNCHRONIZED_WRITE = 2;
    public static final int SYNCHRONIZED_READ_ON_WRITE = 3;
    public static final int SYNCRONIZED_OBJECT_LEVEL_READ_WRITE = 4;
    public static final int SYNCRONIZED_OBJECT_LEVEL_READ_WRITE_DATABASE = 5;

    public DatasourceLogin() {
        this(new DatasourcePlatform());
    }

    public DatasourceLogin(Platform platform) {
        this.platform = platform;
        this.dontUseExternalConnectionPooling();
        this.dontUseExternalTransactionController();
        this.properties = new Properties();
        this.properties.put("user", "");
        this.isEncryptedPasswordSet = false;
        this.securableObjectHolder = new SecurableObjectHolder();
    }

    protected SecurableObjectHolder getSecurableObjectHolder() {
        if (this.securableObjectHolder == null) {
            this.securableObjectHolder = new SecurableObjectHolder();
            this.securableObjectHolder.getSecurableObject();
        }
        return this.securableObjectHolder;
    }

    public Object clone() {
        DatasourceLogin datasourceLogin = null;
        try {
            datasourceLogin = (DatasourceLogin)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getConnector() != null) {
            datasourceLogin.setConnector((Connector)this.getConnector().clone());
        }
        datasourceLogin.setDatasourcePlatform((Platform)this.getDatasourcePlatform().clone());
        datasourceLogin.setProperties((Properties)this.properties.clone());
        return datasourceLogin;
    }

    public Object connectToDatasource(Accessor accessor, Session session) throws DatabaseException {
        return this.getConnector().connect(this.prepareProperties(this.properties), session);
    }

    public int getCacheTransactionIsolation() {
        return this.cacheTransactionIsolation;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public DatabasePlatform getPlatform() {
        try {
            return (DatabasePlatform)this.getDatasourcePlatform();
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            this.platform = new DatasourcePlatform();
        }
        return this.platform;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object getProperty(String string) {
        return this.getProperties().get(string);
    }

    public String getTableQualifier() {
        return this.getDatasourcePlatform().getTableQualifier();
    }

    public String getUserName() {
        return this.properties.getProperty("user");
    }

    public boolean isConnectionHealthValidatedOnError() {
        return false;
    }

    public static String getVersion() {
        if (versionString == null) {
            Object[] objectArray = new Object[]{Version.getProduct(), Version.getVersionString()};
            versionString = MessageFormat.format(versionStringTemplate, objectArray);
        }
        return versionString;
    }

    private Properties prepareProperties(Properties properties) {
        Properties properties2 = properties;
        Object object = properties2.get("password");
        if (object != null) {
            if (this.getSecurableObjectHolder().hasSecurableObject() || this.isEncryptedPasswordSet) {
                properties2 = (Properties)properties.clone();
                String string = null;
                if (object instanceof char[]) {
                    string = new String((char[])object);
                } else if (object instanceof String) {
                    string = (String)object;
                }
                properties2.put("password", this.getSecurableObjectHolder().getSecurableObject().decryptPassword(string));
            } else if (object instanceof char[] && ((char[])object).length == 0) {
                properties2.put("password", "");
            }
        }
        return properties2;
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void setCacheTransactionIsolation(int n) {
        this.cacheTransactionIsolation = n;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setDefaultNullValue(Class clazz, Object object) {
        this.getDatasourcePlatform().getConversionManager().setDefaultNullValue(clazz, object);
    }

    public void setPassword(String string) {
        if (string != null) {
            if (string == "") {
                this.setProperty("password", "");
            } else {
                String string2 = this.getSecurableObjectHolder().getSecurableObject().encryptPassword(string);
                this.setProperty("password", string2.toCharArray());
            }
        } else {
            this.removeProperty("password");
        }
    }

    public String getPassword() {
        Object object = this.properties.get("password");
        if (object instanceof String) {
            return (String)object;
        }
        char[] cArray = (char[])object;
        if (cArray != null) {
            return new String(cArray);
        }
        return null;
    }

    public void setEncryptedPassword(String string) {
        this.isEncryptedPasswordSet = true;
        if (string != null) {
            this.setProperty("password", string.toCharArray());
        } else {
            this.removeProperty("password");
        }
    }

    public void setEncryptionClassName(String string) {
        this.getSecurableObjectHolder().setEncryptionClassName(string);
    }

    public void setPlatform(Platform platform) {
        this.setDatasourcePlatform(platform);
    }

    public void setDatasourcePlatform(Platform platform) {
        this.platform = platform;
    }

    public String getPlatformClassName() {
        return this.getDatasourcePlatform().getClass().getName();
    }

    public void setPlatformClassName(String string) throws ValidationException {
        if (string.equals("org.eclipse.persistence.platform.database.oracle.OraclePlatform")) {
            string = "org.eclipse.persistence.platform.database.OraclePlatform";
        }
        Class clazz = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(string);
            DatasourcePlatform datasourcePlatform = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    datasourcePlatform = (DatasourcePlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            } else {
                datasourcePlatform = (DatasourcePlatform)PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
            this.usePlatform(datasourcePlatform);
            datasourcePlatform.getPlatformOperators();
        }
        catch (Throwable throwable) {
            try {
                clazz = ConversionManager.loadClass(string);
                Platform platform = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        platform = (Platform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.platformClassNotFound(privilegedActionException.getException(), string);
                    }
                } else {
                    platform = (Platform)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
                this.usePlatform(platform);
            }
            catch (Exception exception) {
                throw ValidationException.platformClassNotFound(exception, string);
            }
        }
    }

    public void setPlatformClassName(String string, ClassLoader classLoader) throws ValidationException {
        boolean bl = false;
        Class<?> clazz = null;
        try {
            Platform platform = null;
            if (classLoader != null) {
                clazz = classLoader.loadClass(string);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        platform = (Platform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.platformClassNotFound(privilegedActionException.getException(), string);
                    }
                } else {
                    platform = (Platform)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
            }
            this.usePlatform(platform);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl || classLoader == null) {
            this.setPlatformClassName(string);
        }
    }

    public void usePlatform(Platform platform) {
        if (this.getDatasourcePlatform() != null) {
            this.getDatasourcePlatform().copyInto(platform);
        }
        this.setPlatform(platform);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void setTableQualifier(String string) {
        this.getDatasourcePlatform().setTableQualifier(string);
    }

    public void setTimestampQuery(ValueReadQuery valueReadQuery) {
        this.getDatasourcePlatform().setTimestampQuery(valueReadQuery);
    }

    public void setUserName(String string) {
        if (string != null) {
            this.setProperty("user", string);
        }
    }

    public void setUsesExternalConnectionPooling(boolean bl) {
        this.usesExternalConnectionPooling = bl;
    }

    public void setUsesExternalTransactionController(boolean bl) {
        this.usesExternalTransactionController = bl;
    }

    public void dontUseExternalConnectionPooling() {
        this.setUsesExternalConnectionPooling(false);
    }

    public void dontUseExternalTransactionController() {
        this.setUsesExternalTransactionController(false);
    }

    public boolean shouldAllowConcurrentReadWrite() {
        return this.getCacheTransactionIsolation() == 1;
    }

    public boolean shouldSynchronizedReadOnWrite() {
        return this.getCacheTransactionIsolation() == 3;
    }

    public boolean shouldSynchronizeWrites() {
        return this.getCacheTransactionIsolation() == 2;
    }

    public boolean shouldSynchronizeObjectLevelReadWrite() {
        return this.getCacheTransactionIsolation() == 4;
    }

    public boolean shouldSynchronizeObjectLevelReadWriteDatabase() {
        return this.getCacheTransactionIsolation() == 5;
    }

    public boolean shouldUseExternalConnectionPooling() {
        return this.usesExternalConnectionPooling;
    }

    public boolean shouldUseExternalTransactionController() {
        return this.usesExternalTransactionController;
    }

    public void useExternalConnectionPooling() {
        this.setUsesExternalConnectionPooling(true);
    }

    public void useExternalTransactionController() {
        this.setUsesExternalTransactionController(true);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.write(Helper.getShortClassName(this.getClass()));
        printWriter.println("(");
        printWriter.println("\t" + ToStringLocalization.buildMessage("platform", null) + "=> " + this.getDatasourcePlatform());
        if (!this.shouldUseExternalConnectionPooling()) {
            printWriter.println("\t" + ToStringLocalization.buildMessage("user_name", null) + "=> \"" + this.getUserName() + "\"");
        }
        printWriter.print("\t");
        this.getConnector().toString(printWriter);
        printWriter.write(")");
        return stringWriter.toString();
    }

    public Sequence getDefaultSequence() {
        return this.getDatasourcePlatform().getDefaultSequence();
    }

    public void setDefaultSequence(Sequence sequence) {
        this.getDatasourcePlatform().setDefaultSequence(sequence);
    }

    public void addSequence(Sequence sequence) {
        this.getDatasourcePlatform().addSequence(sequence);
    }

    public Sequence getSequence(String string) {
        return this.getDatasourcePlatform().getSequence(string);
    }

    public Map getSequences() {
        return this.getDatasourcePlatform().getSequences();
    }

    public Sequence removeSequence(String string) {
        return this.getDatasourcePlatform().removeSequence(string);
    }

    public void removeAllSequences() {
        this.getDatasourcePlatform().removeAllSequences();
    }

    public Sequence getDefaultSequenceToWrite() {
        return this.getDatasourcePlatform().getDefaultSequenceToWrite();
    }

    public Map getSequencesToWrite() {
        return this.getDatasourcePlatform().getSequencesToWrite();
    }

    public void setSequences(Map map) {
        this.getDatasourcePlatform().setSequences(map);
    }
}

