/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ConcurrentFixedCache;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements Serializable,
Cloneable {
    protected String name = "";
    protected Login datasourceLogin;
    protected Map descriptors;
    protected Vector orderedDescriptors;
    protected Vector defaultReadOnlyClasses;
    protected Map aliasDescriptors;
    protected boolean hasIsolatedClasses = false;
    protected boolean hasGenericHistorySupport = false;
    protected boolean hasProxyIndirection = false;
    protected Map sqlResultSetMappings;
    protected transient ConcurrentFixedCache jpqlParseCache;
    protected boolean defaultTemporalMutable = false;
    protected transient boolean hasMappingsPostCalculateChangesOnDeleted = false;
    protected Class defaultIdentityMapClass = AbstractIdentityMap.getDefaultIdentityMapClass();
    protected int defaultIdentityMapSize = 100;
    protected boolean defaultIsIsolated = false;
    protected transient List<DatabaseQuery> queries = null;

    public Project() {
        this.descriptors = new HashMap();
        this.defaultReadOnlyClasses = NonSynchronizedVector.newInstance();
        this.orderedDescriptors = NonSynchronizedVector.newInstance();
        this.jpqlParseCache = new ConcurrentFixedCache(200);
        this.queries = new ArrayList<DatabaseQuery>();
    }

    public Project(Login login) {
        this();
        this.datasourceLogin = login;
    }

    public Project(DatabaseLogin databaseLogin) {
        this();
        this.datasourceLogin = databaseLogin;
    }

    public boolean getDefaultTemporalMutable() {
        return this.defaultTemporalMutable;
    }

    public void setDefaultTemporalMutable(boolean bl) {
        this.defaultTemporalMutable = bl;
    }

    public ConcurrentFixedCache getJPQLParseCache() {
        return this.jpqlParseCache;
    }

    public void setJPQLParseCacheMaxSize(int n) {
        this.setJPQLParseCache(new ConcurrentFixedCache(n));
    }

    public int getJPQLParseCacheMaxSize() {
        return this.getJPQLParseCache().getMaxSize();
    }

    protected void setJPQLParseCache(ConcurrentFixedCache concurrentFixedCache) {
        this.jpqlParseCache = concurrentFixedCache;
    }

    public List<DatabaseQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DatabaseQuery> list) {
        this.queries = list;
    }

    public void addDefaultReadOnlyClass(Class clazz) {
        this.getDefaultReadOnlyClasses().addElement(clazz);
    }

    public void addDescriptor(ClassDescriptor classDescriptor) {
        this.getOrderedDescriptors().add(classDescriptor);
        String string = classDescriptor.getAlias();
        if (string != null) {
            this.addAlias(string, classDescriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(classDescriptor.getJavaClass(), classDescriptor);
        }
    }

    public void addDescriptor(ClassDescriptor classDescriptor, DatabaseSessionImpl databaseSessionImpl) {
        this.getOrderedDescriptors().add(classDescriptor);
        String string = classDescriptor.getAlias();
        if (string != null) {
            this.addAlias(string, classDescriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(classDescriptor.getJavaClass(), classDescriptor);
        }
        databaseSessionImpl.initializeDescriptorIfSessionAlive(classDescriptor);
    }

    public void addDescriptors(Collection collection, DatabaseSessionImpl databaseSessionImpl) {
        for (ClassDescriptor classDescriptor : collection) {
            this.getDescriptors().put(classDescriptor.getJavaClass(), classDescriptor);
            String string = classDescriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, classDescriptor);
        }
        if (databaseSessionImpl.isConnected()) {
            databaseSessionImpl.initializeDescriptors(collection);
            databaseSessionImpl.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(collection);
    }

    public void addDescriptors(Project project, DatabaseSessionImpl databaseSessionImpl) {
        for (ClassDescriptor classDescriptor : project.getDescriptors().values()) {
            this.getDescriptors().put(classDescriptor.getJavaClass(), classDescriptor);
            String string = classDescriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, classDescriptor);
        }
        if (databaseSessionImpl.isConnected()) {
            databaseSessionImpl.initializeDescriptors(project.getDescriptors());
            databaseSessionImpl.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(project.getOrderedDescriptors());
    }

    public void addSQLResultSetMapping(SQLResultSetMapping sQLResultSetMapping) {
        if (sQLResultSetMapping == null || sQLResultSetMapping.getName() == null) {
            return;
        }
        if (this.sqlResultSetMappings == null) {
            this.sqlResultSetMappings = new HashMap();
        }
        this.sqlResultSetMappings.put(sQLResultSetMapping.getName(), sQLResultSetMapping);
    }

    public void conformAllDescriptors() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.setShouldAlwaysConformResultsInUnitOfWork(true);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (Object object : this.orderedDescriptors) {
            ((ClassDescriptor)object).convertClassNamesToClasses(classLoader);
        }
        this.descriptors = new HashMap();
        if (this.sqlResultSetMappings != null) {
            Object object;
            object = this.sqlResultSetMappings.keySet().iterator();
            while (object.hasNext()) {
                SQLResultSetMapping sQLResultSetMapping = (SQLResultSetMapping)this.sqlResultSetMappings.get(object.next());
                sQLResultSetMapping.convertClassNamesToClasses(classLoader);
            }
        }
    }

    public void assumeExistenceForDoesExist() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.getQueryManager().assumeExistenceForDoesExist();
        }
    }

    public void checkCacheForDoesExist() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.getQueryManager().checkCacheForDoesExist();
        }
    }

    public void checkDatabaseForDoesExist() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.getQueryManager().checkDatabaseForDoesExist();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DatabaseSession createDatabaseSession() {
        return new DatabaseSessionImpl(this);
    }

    public Server createServerSession() {
        return new ServerSession(this);
    }

    public Server createServerSession(int n, int n2) {
        return new ServerSession(this, n, n2);
    }

    public Server createServerSession(ConnectionPolicy connectionPolicy) {
        return new ServerSession(this, connectionPolicy);
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.defaultReadOnlyClasses;
    }

    public Class getDefaultIdentityMapClass() {
        return this.defaultIdentityMapClass;
    }

    public int getDefaultIdentityMapSize() {
        return this.defaultIdentityMapSize;
    }

    public boolean getDefaultIsIsolated() {
        return this.defaultIsIsolated;
    }

    public ClassDescriptor getClassDescriptor(Class clazz) {
        return this.getDescriptor(clazz);
    }

    public ClassDescriptor getDescriptor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (ClassDescriptor)this.getDescriptors().get(clazz);
    }

    public Map getDescriptors() {
        if (this.descriptors.isEmpty() && !this.orderedDescriptors.isEmpty()) {
            for (ClassDescriptor classDescriptor : this.orderedDescriptors) {
                this.descriptors.put(classDescriptor.getJavaClass(), classDescriptor);
            }
        }
        return this.descriptors;
    }

    public Vector getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public void setOrderedDescriptors(Vector vector) {
        this.orderedDescriptors = vector;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            String string = classDescriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, classDescriptor);
        }
    }

    public DatabaseLogin getLogin() {
        return (DatabaseLogin)this.datasourceLogin;
    }

    public Login getDatasourceLogin() {
        return this.datasourceLogin;
    }

    public String getName() {
        return this.name;
    }

    public SQLResultSetMapping getSQLResultSetMapping(String string) {
        if (string == null || this.sqlResultSetMappings == null) {
            return null;
        }
        return (SQLResultSetMapping)this.sqlResultSetMappings.get(string);
    }

    public boolean hasGenericHistorySupport() {
        return this.hasGenericHistorySupport;
    }

    public void setDefaultReadOnlyClasses(Collection collection) {
        this.defaultReadOnlyClasses = new Vector(collection);
    }

    public void setDefaultIdentityMapClass(Class clazz) {
        this.defaultIdentityMapClass = clazz;
    }

    public void setDefaultIdentityMapSize(int n) {
        this.defaultIdentityMapSize = n;
    }

    public void setDefaultIsIsolated(boolean bl) {
        this.defaultIsIsolated = bl;
    }

    public void setDescriptors(Map map) {
        this.descriptors = map;
        for (ClassDescriptor classDescriptor : map.values()) {
            String string = classDescriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, classDescriptor);
        }
    }

    public void setDeferModificationsUntilCommit(int n) {
        for (ClassDescriptor classDescriptor : this.descriptors.values()) {
            if (classDescriptor.getCMPPolicy() == null) continue;
            classDescriptor.getCMPPolicy().setDeferModificationsUntilCommit(n);
        }
    }

    public void setHasGenericHistorySupport(boolean bl) {
        this.hasGenericHistorySupport = bl;
    }

    public boolean hasIsolatedClasses() {
        return this.hasIsolatedClasses;
    }

    public void setHasIsolatedClasses(boolean bl) {
        this.hasIsolatedClasses = bl;
    }

    public boolean hasProxyIndirection() {
        return this.hasProxyIndirection;
    }

    public void setHasProxyIndirection(boolean bl) {
        this.hasProxyIndirection = bl;
    }

    public void setLogin(DatabaseLogin databaseLogin) {
        this.datasourceLogin = databaseLogin;
    }

    public void setLogin(Login login) {
        this.datasourceLogin = login;
    }

    public void setDatasourceLogin(Login login) {
        this.datasourceLogin = login;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ")";
    }

    public void useCacheIdentityMap() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useCacheIdentityMap();
        }
    }

    public void useCacheIdentityMap(int n) {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useCacheIdentityMap();
            classDescriptor.setIdentityMapSize(n);
        }
    }

    public void useFullIdentityMap() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useFullIdentityMap();
        }
    }

    public void useFullIdentityMap(int n) {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useFullIdentityMap();
            classDescriptor.setIdentityMapSize(n);
        }
    }

    public void useNoIdentityMap() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useNoIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useSoftCacheWeakIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap(int n) {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useSoftCacheWeakIdentityMap();
            classDescriptor.setIdentityMapSize(n);
        }
    }

    public boolean usesOptimisticLocking() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            if (!classDescriptor.usesOptimisticLocking()) continue;
            return true;
        }
        return false;
    }

    public boolean usesSequencing() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            if (!classDescriptor.usesSequenceNumbers()) continue;
            return true;
        }
        return false;
    }

    public void useWeakIdentityMap() {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useWeakIdentityMap();
        }
    }

    public void useWeakIdentityMap(int n) {
        for (ClassDescriptor classDescriptor : this.getDescriptors().values()) {
            classDescriptor.useWeakIdentityMap();
            classDescriptor.setIdentityMapSize(n);
        }
    }

    public void applyLogin() {
    }

    public Map getAliasDescriptors() {
        return this.aliasDescriptors;
    }

    public void addAlias(String string, ClassDescriptor classDescriptor) {
        if (this.aliasDescriptors == null) {
            this.aliasDescriptors = new HashMap(10);
        }
        this.aliasDescriptors.put(string, classDescriptor);
    }

    public ClassDescriptor getDescriptorForAlias(String string) {
        ClassDescriptor classDescriptor = null;
        if (this.aliasDescriptors != null) {
            classDescriptor = (ClassDescriptor)this.aliasDescriptors.get(string);
        }
        return classDescriptor;
    }

    public void setAliasDescriptors(Map map) {
        this.aliasDescriptors = map;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.hasMappingsPostCalculateChangesOnDeleted;
    }

    public void setHasMappingsPostCalculateChangesOnDeleted(boolean bl) {
        this.hasMappingsPostCalculateChangesOnDeleted = bl;
    }
}

