/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;

public class XMLProjectWriter {
    public static void write(Project project, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            XMLProjectWriter.write(project, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public static void write(Project project, Writer writer) {
        XMLContext xMLContext = new XMLContext(new ObjectPersistenceWorkbenchXMLProject());
        xMLContext.getSession(project).getEventManager().addListener(new MissingDescriptorListener());
        XMLMarshaller xMLMarshaller = xMLContext.createMarshaller();
        xMLMarshaller.marshal((Object)project, writer);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public static void write(String string, Project project) {
        XMLProjectWriter.write(project, string);
    }

    public static void write(String string, Project project, Writer writer) {
        if (writer != null) {
            XMLProjectWriter.write(project, writer);
        } else {
            XMLProjectWriter.write(project, string);
        }
    }
}

