/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class UnaryTableSequenceDefinition
extends SequenceDefinition {
    public UnaryTableSequenceDefinition(Sequence sequence) {
        super(sequence);
    }

    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("INSERT INTO ");
            writer.write(this.getName());
            writer.write("(" + this.getSequenceCounterFieldName());
            writer.write(") values (" + Integer.toString(this.sequence.getInitialValue() - 1) + ")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("DELETE FROM ");
            writer.write(this.getName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession abstractSession) throws DatabaseException {
        Vector vector = abstractSession.executeSelectingCall(new SQLCall("SELECT * FROM " + this.getName()));
        return !vector.isEmpty();
    }

    public String getSequenceCounterFieldName() {
        return this.getUnaryTableSequence().getCounterFieldName();
    }

    public TableDefinition buildTableDefinition() {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(this.getName());
        tableDefinition.addField(this.getSequenceCounterFieldName(), BigDecimal.class);
        return tableDefinition;
    }

    protected UnaryTableSequence getUnaryTableSequence() {
        if (this.sequence instanceof UnaryTableSequence) {
            return (UnaryTableSequence)this.sequence;
        }
        return (UnaryTableSequence)((DefaultSequence)this.sequence).getDefaultSequence();
    }
}

