/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.Request;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterMap;

public final class ApplicationFilterFactory {
    private static ApplicationFilterFactory factory = new ApplicationFilterFactory();

    private ApplicationFilterFactory() {
    }

    public static ApplicationFilterFactory getInstance() {
        return factory;
    }

    public ApplicationFilterChain createFilterChain(ServletRequest request, Wrapper wrapper, Servlet servlet) {
        ApplicationFilterConfig filterConfig;
        int i;
        if (servlet == null) {
            return null;
        }
        ApplicationFilterChain filterChain = null;
        StandardContext context = (StandardContext)wrapper.getParent();
        FilterMap[] filterMaps = context.findFilterMaps();
        if (filterMaps == null || filterMaps.length == 0) {
            return filterChain;
        }
        DispatcherType dispatcher = request.getDispatcherType();
        String requestPath = null;
        Object attribute = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        String servletName = wrapper.getName();
        int n = 0;
        for (i = 0; i < filterMaps.length; ++i) {
            if (!filterMaps[i].getDispatcherTypes().contains((Object)dispatcher) || !this.matchFiltersURL(filterMaps[i], requestPath, context.isCaseSensitiveMapping()) || (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i].getFilterName())) == null) continue;
            if (filterChain == null) {
                filterChain = this.internalCreateFilterChain(request, wrapper, servlet);
            }
            filterChain.addFilter(filterConfig);
            ++n;
        }
        for (i = 0; i < filterMaps.length; ++i) {
            if (!filterMaps[i].getDispatcherTypes().contains((Object)dispatcher) || !this.matchFiltersServlet(filterMaps[i], servletName) || (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i].getFilterName())) == null) continue;
            if (filterChain == null) {
                filterChain = this.internalCreateFilterChain(request, wrapper, servlet);
            }
            filterChain.addFilter(filterConfig);
            ++n;
        }
        return filterChain;
    }

    private boolean matchFiltersURL(FilterMap filterMap, String requestPath, boolean caseSensitiveMapping) {
        if (requestPath == null) {
            return false;
        }
        String testPath = filterMap.getURLPattern();
        if (testPath == null) {
            return false;
        }
        if (!caseSensitiveMapping) {
            requestPath = requestPath.toLowerCase();
            testPath = testPath.toLowerCase();
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            if (testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
                if (requestPath.length() == testPath.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(testPath.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                return testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return false;
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        if (servletName == null) {
            return false;
        }
        return servletName.equals(filterMap.getServletName()) || "*".equals(filterMap.getServletName());
    }

    private ApplicationFilterChain internalCreateFilterChain(ServletRequest request, Wrapper wrapper, Servlet servlet) {
        ApplicationFilterChain filterChain = null;
        if (!Globals.IS_SECURITY_ENABLED && request instanceof Request) {
            Request req = (Request)((Object)request);
            filterChain = (ApplicationFilterChain)req.getFilterChain();
            if (filterChain == null) {
                filterChain = new ApplicationFilterChain();
                req.setFilterChain(filterChain);
            }
        } else {
            filterChain = new ApplicationFilterChain();
        }
        filterChain.setServlet(servlet);
        filterChain.setWrapper((StandardWrapper)wrapper);
        return filterChain;
    }
}

