/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-components")
@I18n(value="list.components")
@Scoped(value=PerLookup.class)
public class ListComponentsCommand
implements AdminCommand {
    @Param(optional=true)
    String type = null;
    @Inject
    Applications applications;
    @Inject
    SnifferManager snifferManager;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        for (Named module : this.applications.getModules()) {
            Application app;
            if (!(module instanceof Application) || !(app = (Application)module).getObjectType().equals("user") || this.type != null && !this.isApplicationOfThisType(app, this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(app.getName() + " " + this.getSnifferEngines((Module)app.getModule().get(0), true));
            ++numOfApplications;
        }
        if (numOfApplications == 0) {
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    boolean isApplicationOfThisType(Application app, String type) {
        for (Module module : app.getModule()) {
            List engineList = module.getEngines();
            for (Engine engine : engineList) {
                if (!engine.getSniffer().equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    String getSnifferEngines(Module module, boolean format) {
        List engineList = module.getEngines();
        StringBuffer se = new StringBuffer();
        if (!engineList.isEmpty()) {
            if (format) {
                se.append("<");
            }
            for (Engine engine : engineList) {
                String engType = engine.getSniffer();
                if (!this.displaySnifferEngine(engType)) continue;
                se.append(engine.getSniffer() + ", ");
            }
            if (se.length() > 2) {
                se.replace(se.length() - 2, se.length(), format ? ">" : "");
            } else if (format) {
                se.append(">");
            }
        }
        return se.toString();
    }

    boolean displaySnifferEngine(String engType) {
        Sniffer sniffer = this.snifferManager.getSniffer(engType);
        return sniffer.isUserVisible();
    }
}

