/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class FetchGroupManager
implements Cloneable {
    private Map fetchGroups = null;
    private FetchGroup defaultFetchGroup;
    private ClassDescriptor descriptor;

    public void addFetchGroup(FetchGroup fetchGroup) {
        this.getFetchGroups().put(fetchGroup.getName(), fetchGroup);
    }

    public Map getFetchGroups() {
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashMap(2);
        }
        return this.fetchGroups;
    }

    public FetchGroup getDefaultFetchGroup() {
        return this.defaultFetchGroup;
    }

    public FetchGroup getFetchGroup(String string) {
        return (FetchGroup)this.getFetchGroups().get(string);
    }

    public void setDefaultFetchGroup(FetchGroup fetchGroup) {
        this.defaultFetchGroup = fetchGroup;
    }

    public boolean isPartialObject(Object object) {
        if (object != null) {
            FetchGroup fetchGroup = ((FetchGroupTracker)object)._persistence_getFetchGroup();
            return fetchGroup != null;
        }
        return false;
    }

    public boolean isObjectValidForFetchGroup(Object object, FetchGroup fetchGroup) {
        FetchGroup fetchGroup2 = ((FetchGroupTracker)object)._persistence_getFetchGroup();
        return fetchGroup2 == null || fetchGroup2.isSupersetOf(fetchGroup);
    }

    public boolean shouldWriteInto(Object object, Object object2) {
        if (this.isPartialObject(object2)) {
            FetchGroup fetchGroup = ((FetchGroupTracker)object)._persistence_getFetchGroup();
            FetchGroup fetchGroup2 = ((FetchGroupTracker)object2)._persistence_getFetchGroup();
            return fetchGroup2 != null && !fetchGroup2.isSupersetOf(fetchGroup) || ((FetchGroupTracker)object)._persistence_shouldRefreshFetchGroup();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePartialIntoClones(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        FetchGroup fetchGroup = ((FetchGroupTracker)object2)._persistence_getFetchGroup();
        FetchGroup fetchGroup2 = ((FetchGroupTracker)object)._persistence_getFetchGroup();
        Object object3 = unitOfWorkImpl.getBackupClone(object2, this.descriptor);
        FetchGroup fetchGroup3 = this.unionFetchGroups(fetchGroup2, fetchGroup);
        this.setObjectFetchGroup(object2, fetchGroup3, unitOfWorkImpl);
        if (object2 != object3) {
            this.setObjectFetchGroup(object3, fetchGroup3, unitOfWorkImpl);
        }
        ObjectChangePolicy objectChangePolicy = this.descriptor.getObjectChangePolicy();
        objectChangePolicy.dissableEventProcessing(object2);
        try {
            if (((FetchGroupTracker)object)._persistence_shouldRefreshFetchGroup()) {
                this.refreshFetchGroupIntoClones(object, object2, object3, fetchGroup2, fetchGroup, unitOfWorkImpl);
            } else {
                this.revertDataIntoUnfetchedAttributesOfClones(object, object2, object3, fetchGroup2, fetchGroup, unitOfWorkImpl);
            }
        }
        finally {
            objectChangePolicy.enableEventProcessing(object2);
        }
    }

    private void refreshFetchGroupIntoClones(Object object, Object object2, Object object3, FetchGroup fetchGroup, FetchGroup fetchGroup2, UnitOfWorkImpl unitOfWorkImpl) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        boolean bl = fetchGroup != null;
        Set set = bl ? fetchGroup.getAttributes() : null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = vector.get(i);
            if (bl && (set == null || !set.contains(databaseMapping.getAttributeName()))) continue;
            databaseMapping.buildClone(object, object2, unitOfWorkImpl);
            if (object2 == object3) continue;
            databaseMapping.buildClone(object2, object3, unitOfWorkImpl);
        }
    }

    private void revertDataIntoUnfetchedAttributesOfClones(Object object, Object object2, Object object3, FetchGroup fetchGroup, FetchGroup fetchGroup2, UnitOfWorkImpl unitOfWorkImpl) {
        Vector<DatabaseMapping> vector = this.descriptor.getMappings();
        Set set = fetchGroup2.getAttributes();
        Set set2 = null;
        if (fetchGroup != null) {
            set2 = fetchGroup.getAttributes();
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseMapping databaseMapping = vector.get(i);
            String string = databaseMapping.getAttributeName();
            if (set2 != null && !set2.contains(string) || set.contains(string)) continue;
            databaseMapping.buildClone(object, object2, unitOfWorkImpl);
            if (object2 == object3) continue;
            databaseMapping.buildClone(object2, object3, unitOfWorkImpl);
        }
    }

    public void copyFetchGroupInto(Object object, Object object2, AbstractSession abstractSession) {
        if (this.isPartialObject(object)) {
            this.setObjectFetchGroup(object2, ((FetchGroupTracker)object)._persistence_getFetchGroup(), abstractSession);
        }
    }

    public void unionFetchGroupIntoObject(Object object, FetchGroup fetchGroup, AbstractSession abstractSession) {
        this.setObjectFetchGroup(object, this.unionFetchGroups(((FetchGroupTracker)object)._persistence_getFetchGroup(), fetchGroup), abstractSession);
    }

    public FetchGroup unionFetchGroups(FetchGroup fetchGroup, FetchGroup fetchGroup2) {
        if (fetchGroup == null || fetchGroup2 == null) {
            return null;
        }
        if (fetchGroup.isSupersetOf(fetchGroup2)) {
            return fetchGroup;
        }
        if (fetchGroup2.isSupersetOf(fetchGroup)) {
            return fetchGroup2;
        }
        StringBuffer stringBuffer = new StringBuffer(fetchGroup.getName());
        stringBuffer.append("_");
        stringBuffer.append(fetchGroup2.getName());
        FetchGroup fetchGroup3 = new FetchGroup(stringBuffer.toString());
        fetchGroup3.addAttributes(fetchGroup.getAttributes());
        fetchGroup3.addAttributes(fetchGroup2.getAttributes());
        return fetchGroup3;
    }

    public void reset(Object object) {
        ((FetchGroupTracker)object)._persistence_resetFetchGroup();
    }

    public void setObjectFetchGroup(Object object, FetchGroup fetchGroup, AbstractSession abstractSession) {
        FetchGroupTracker fetchGroupTracker = (FetchGroupTracker)object;
        fetchGroupTracker._persistence_setFetchGroup(fetchGroup);
        fetchGroupTracker._persistence_setSession(abstractSession);
    }

    public void setRefreshOnFetchGroupToObject(Object object, boolean bl) {
        ((FetchGroupTracker)object)._persistence_setShouldRefreshFetchGroup(bl);
    }

    public boolean isAttributeFetched(Object object, String string) {
        FetchGroup fetchGroup = ((FetchGroupTracker)object)._persistence_getFetchGroup();
        return fetchGroup == null || fetchGroup.containsAttribute(string);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.getDescriptor();
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void prepareQueryWithFetchGroup(ObjectLevelReadQuery objectLevelReadQuery) {
        DatabaseMapping databaseMapping;
        objectLevelReadQuery.initializeFetchGroup();
        if (!objectLevelReadQuery.hasFetchGroup()) {
            return;
        }
        if (objectLevelReadQuery.isReportQuery()) {
            throw QueryException.fetchGroupNotSupportOnReportQuery();
        }
        if (objectLevelReadQuery.hasPartialAttributeExpressions()) {
            throw QueryException.fetchGroupNotSupportOnPartialAttributeReading();
        }
        Object object = this.getDescriptor().getObjectBuilder().getPrimaryKeyMappings().iterator();
        while (object.hasNext()) {
            databaseMapping = object.next();
            objectLevelReadQuery.getFetchGroup().addAttribute(databaseMapping.getAttributeName());
        }
        if (objectLevelReadQuery.shouldMaintainCache() && this.getDescriptor().usesOptimisticLocking() && (object = this.getDescriptor().getOptimisticLockingPolicy().getWriteLockField()) != null && (databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField((DatabaseField)object)) != null) {
            objectLevelReadQuery.getFetchGroup().addAttribute(databaseMapping.getAttributeName());
        }
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        if (!Helper.classImplementsInterface(this.getDescriptor().getJavaClass(), ClassConstants.FetchGroupTracker_class)) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.needToImplementFetchGroupTracker(this.getDescriptor().getJavaClass(), this.getDescriptor()));
        }
        if (this.getDefaultFetchGroup() == null) {
            FetchGroup fetchGroup = new FetchGroup();
            boolean bl = false;
            for (DatabaseMapping databaseMapping : this.getDescriptor().getMappings()) {
                if (databaseMapping.isForeignReferenceMapping() || !databaseMapping.isLazy()) {
                    fetchGroup.addAttribute(databaseMapping.getAttributeName());
                    continue;
                }
                bl = true;
            }
            if (bl) {
                this.setDefaultFetchGroup(fetchGroup);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }
}

