/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.history;

import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;

public class AsOfClause
implements Serializable {
    public static final AsOfClause NO_CLAUSE = new AsOfClause((Expression)null);
    private final Object value;

    public AsOfClause(Date date) {
        this.value = date;
    }

    public AsOfClause(Timestamp timestamp) {
        this.value = timestamp;
    }

    public AsOfClause(Calendar calendar) {
        this.value = calendar;
    }

    public AsOfClause(long l) {
        this.value = new Long(l);
    }

    public AsOfClause(Long l) {
        this.value = l;
    }

    protected AsOfClause(Number number) {
        this.value = number;
    }

    public AsOfClause(Expression expression) {
        this.value = expression;
    }

    protected AsOfClause(AsOfClause asOfClause) {
        this.value = asOfClause;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printString("AS OF TIMESTAMP (");
        Object object = this.getValue();
        if (object instanceof Expression) {
            if (object instanceof ConstantExpression && ((ConstantExpression)object).getValue() instanceof String) {
                expressionSQLPrinter.printString((String)((ConstantExpression)object).getValue());
            } else {
                expressionSQLPrinter.printExpression((Expression)object);
            }
        } else {
            ConversionManager conversionManager = ConversionManager.getDefaultManager();
            object = conversionManager.convertObject(object, ClassConstants.TIMESTAMP);
            expressionSQLPrinter.printPrimitive(object);
        }
        expressionSQLPrinter.printString(")");
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isAsOfSCNClause() {
        return false;
    }

    public boolean isUniversal() {
        return false;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        stringWriter.write(this.getValue().toString());
        stringWriter.write(")");
        return stringWriter.toString();
    }
}

