/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLUpdateAllStatement
extends SQLModifyStatement {
    protected HashMap m_updateClauses;
    protected HashMap databaseFieldsToTableAliases;
    protected SQLCall selectCallForExist;
    protected String tableAliasInSelectCallForExist;
    protected Collection primaryKeyFields;
    protected boolean shouldExtractWhereClauseFromSelectCallForExist;

    public void setSelectCallForExist(SQLCall sQLCall) {
        this.selectCallForExist = sQLCall;
    }

    public SQLCall getSelectCallForExist() {
        return this.selectCallForExist;
    }

    public void setTableAliasInSelectCallForExist(String string) {
        this.tableAliasInSelectCallForExist = string;
    }

    public String getTableAliasInSelectCallForExist() {
        return this.tableAliasInSelectCallForExist;
    }

    public void setPrimaryKeyFieldsForAutoJoin(Collection collection) {
        this.primaryKeyFields = collection;
    }

    public Collection getPrimaryKeyFieldsForAutoJoin() {
        return this.primaryKeyFields;
    }

    public void setUpdateClauses(HashMap hashMap) {
        this.m_updateClauses = hashMap;
    }

    public HashMap getUpdateClauses() {
        return this.m_updateClauses;
    }

    public void setDatabaseFieldsToTableAliases(HashMap hashMap) {
        this.databaseFieldsToTableAliases = hashMap;
    }

    public HashMap getDatabaseFieldsToTableAliases() {
        return this.databaseFieldsToTableAliases;
    }

    public void setShouldExtractWhereClauseFromSelectCallForExist(boolean bl) {
        this.shouldExtractWhereClauseFromSelectCallForExist = bl;
    }

    public boolean shouldExtractWhereClauseFromSelectCallForExist() {
        return this.shouldExtractWhereClauseFromSelectCallForExist;
    }

    public DatabaseCall buildCall(AbstractSession abstractSession) {
        SQLCall sQLCall = this.buildSimple(abstractSession);
        if (this.selectCallForExist == null) {
            return sQLCall;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(100);
        try {
            charArrayWriter.write(sQLCall.getSQLString());
            if (this.selectCallForExist != null) {
                if (this.shouldExtractWhereClauseFromSelectCallForExist) {
                    this.writeWhere(charArrayWriter, this.selectCallForExist, sQLCall);
                } else {
                    charArrayWriter.write(" WHERE EXISTS(");
                    this.writeSelect(charArrayWriter, this.selectCallForExist, this.tableAliasInSelectCallForExist, sQLCall);
                    charArrayWriter.write(")");
                }
            }
            sQLCall.setSQLString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return sQLCall;
    }

    protected SQLCall buildSimple(AbstractSession abstractSession) {
        SQLCall sQLCall = new SQLCall();
        sQLCall.returnNothing();
        CharArrayWriter charArrayWriter = new CharArrayWriter(100);
        ExpressionSQLPrinter expressionSQLPrinter = new ExpressionSQLPrinter(abstractSession, this.getTranslationRow(), sQLCall, false);
        expressionSQLPrinter.setWriter(charArrayWriter);
        try {
            charArrayWriter.write("UPDATE ");
            if (this.getHintString() != null) {
                charArrayWriter.write(this.getHintString());
                charArrayWriter.write(" ");
            }
            charArrayWriter.write(this.getTable().getQualifiedName());
            charArrayWriter.write(" SET ");
            Iterator iterator = this.m_updateClauses.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    charArrayWriter.write(", ");
                }
                DatabaseField databaseField = (DatabaseField)iterator.next();
                Object v = this.m_updateClauses.get(databaseField);
                charArrayWriter.write(databaseField.getName());
                charArrayWriter.write(" = ");
                if (v instanceof Expression) {
                    expressionSQLPrinter.printExpression((Expression)v);
                } else {
                    SQLCall sQLCall2 = (SQLCall)v;
                    String string = (String)this.getDatabaseFieldsToTableAliases().get(databaseField);
                    charArrayWriter.write("(");
                    this.writeSelect(charArrayWriter, sQLCall2, string, sQLCall);
                    charArrayWriter.write(")");
                }
                bl = true;
            }
            if (this.getWhereClause() != null) {
                charArrayWriter.write(" WHERE ");
                expressionSQLPrinter.printExpression(this.getWhereClause());
            }
            sQLCall.setSQLString(((Object)charArrayWriter).toString());
            return sQLCall;
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected void writeSelect(Writer writer, SQLCall sQLCall, String string, SQLCall sQLCall2) throws IOException {
        String string2 = sQLCall.getSQLString();
        writer.write(string2);
        boolean bl = string2.toUpperCase().indexOf(" WHERE ") >= 0;
        Iterator iterator = this.getPrimaryKeyFieldsForAutoJoin().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                writer.write(" WHERE ");
                bl = true;
            } else {
                writer.write(" AND ");
            }
            String string3 = ((DatabaseField)iterator.next()).getName();
            if (string != null) {
                writer.write(string);
                writer.write(46);
            }
            writer.write(string3);
            writer.write(" = ");
            writer.write(this.table.getQualifiedName());
            writer.write(46);
            writer.write(string3);
        }
        sQLCall2.getParameters().addAll(sQLCall.getParameters());
        sQLCall2.getParameterTypes().addAll(sQLCall.getParameterTypes());
    }

    protected boolean writeWhere(Writer writer, SQLCall sQLCall, SQLCall sQLCall2) throws IOException {
        String string = this.selectCallForExist.getSQLString();
        int n = string.toUpperCase().indexOf(" WHERE ");
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n);
        writer.write(string2);
        sQLCall2.getParameters().addAll(sQLCall.getParameters());
        sQLCall2.getParameterTypes().addAll(sQLCall.getParameterTypes());
        return true;
    }
}

