/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.TransformerBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class BasicIndirectionPolicy
extends IndirectionPolicy {
    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)object;
        ValueHolder valueHolder = new ValueHolder();
        if (!(valueHolderInterface instanceof UnitOfWorkValueHolder) || valueHolderInterface.isInstantiated()) {
            valueHolder.setValue(super.backupCloneAttribute(valueHolderInterface.getValue(), object2, object3, unitOfWorkImpl));
        } else {
            ((UnitOfWorkValueHolder)valueHolderInterface).setBackupValueHolder(valueHolder);
        }
        return valueHolder;
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolderInterface) {
        return valueHolderInterface;
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface;
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)object;
        if (!bl && unitOfWorkImpl.isOriginalNewObject(object2)) {
            if (valueHolderInterface instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolderInterface).isInstantiated() && ((DatabaseValueHolder)valueHolderInterface).getSession() == null && !((DatabaseValueHolder)valueHolderInterface).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(object2, this.getMapping());
            }
            if (this.getMapping().getRelationshipPartner() == null) {
                weavedAttributeValueHolderInterface = new ValueHolder();
                weavedAttributeValueHolderInterface.setValue(this.getMapping().buildCloneForPartObject(valueHolderInterface.getValue(), object2, object3, unitOfWorkImpl, false));
            } else {
                AbstractRecord abstractRecord = null;
                if (valueHolderInterface instanceof DatabaseValueHolder) {
                    abstractRecord = ((DatabaseValueHolder)valueHolderInterface).getRow();
                }
                weavedAttributeValueHolderInterface = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, abstractRecord, unitOfWorkImpl, bl);
                Object object4 = this.getMapping().buildCloneForPartObject(valueHolderInterface.getValue(), object2, object3, unitOfWorkImpl, false);
                ((UnitOfWorkValueHolder)weavedAttributeValueHolderInterface).privilegedSetValue(object4);
                ((UnitOfWorkValueHolder)weavedAttributeValueHolderInterface).setInstantiated();
            }
        } else {
            AbstractRecord abstractRecord = null;
            if (valueHolderInterface instanceof DatabaseValueHolder) {
                abstractRecord = ((DatabaseValueHolder)valueHolderInterface).getRow();
            }
            weavedAttributeValueHolderInterface = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, abstractRecord, unitOfWorkImpl, bl);
        }
        return weavedAttributeValueHolderInterface;
    }

    public Vector extractPrimaryKeyForReferenceObject(Object object, AbstractSession abstractSession) {
        if (this.objectIsInstantiated(object)) {
            return super.extractPrimaryKeyForReferenceObject(((ValueHolderInterface)object).getValue(), abstractSession);
        }
        return this.getOneToOneMapping().extractPrimaryKeysForReferenceObjectFromRow(this.extractReferenceRow(object));
    }

    public AbstractRecord extractReferenceRow(Object object) {
        if (this.objectIsInstantiated(object)) {
            return null;
        }
        return ((DatabaseValueHolder)object).getRow();
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getMapping().getAttributeValueFromObject(object);
        if (object2 instanceof RemoteValueHolder) {
            RemoteValueHolder remoteValueHolder = (RemoteValueHolder)this.getMapping().getAttributeValueFromObject(object);
            remoteValueHolder.setSession(remoteSession);
            remoteValueHolder.setMapping(this.getMapping());
            if (!objectLevelReadQuery.shouldMaintainCache() && (!objectLevelReadQuery.shouldCascadeParts() || objectLevelReadQuery.shouldCascadePrivateParts() && !this.getMapping().isPrivateOwned())) {
                remoteValueHolder.setQuery(null);
            } else {
                remoteValueHolder.setQuery(objectLevelReadQuery);
            }
            remoteValueHolder.setUninstantiated();
        } else {
            this.getMapping().fixRealObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
        }
    }

    public Object getOriginalIndirectionObject(Object object, AbstractSession abstractSession) {
        return this.getOriginalValueHolder(object, abstractSession);
    }

    public Object getOriginalValueHolder(Object object, AbstractSession abstractSession) {
        if (object instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)object).getWrappedValueHolder();
            if (valueHolderInterface == null && abstractSession.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)abstractSession).getParentSessionController();
                ObjID objID = ((UnitOfWorkValueHolder)object).getWrappedValueHolderRemoteID();
                if (objID == null) {
                    Object object2 = ((UnitOfWorkValueHolder)object).getSourceObject();
                    AbstractRecord abstractRecord = this.getMapping().getDescriptor().getObjectBuilder().buildRow(object2, abstractSession);
                    ReadObjectQuery readObjectQuery = new ReadObjectQuery();
                    readObjectQuery.setSession(((RemoteUnitOfWork)abstractSession).getParent());
                    valueHolderInterface = (ValueHolderInterface)this.getMapping().valueFromRow(abstractRecord, null, readObjectQuery);
                } else {
                    valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(objID);
                }
            }
            if (valueHolderInterface != null && valueHolderInterface instanceof DatabaseValueHolder) {
                ((DatabaseValueHolder)valueHolderInterface).releaseWrappedValueHolder();
            }
            return valueHolderInterface;
        }
        return object;
    }

    public void reset(Object object) {
        this.getMapping().setAttributeValueInObject(object, new ValueHolder());
    }

    public Object getRealAttributeValueFromObject(Object object, Object object2) {
        if (object2 instanceof ValueHolderInterface) {
            return ((ValueHolderInterface)object2).getValue();
        }
        return object2;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return remoteValueHolder.getValue();
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iterateValueHolderForMapping((ValueHolderInterface)object, this.getMapping());
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        RemoteValueHolder remoteValueHolder = (RemoteValueHolder)this.getMapping().getAttributeValueFromObject(object2);
        this.mergeClientIntoServerValueHolder(remoteValueHolder, mergeManager);
        this.getMapping().setAttributeValueInObject(object, remoteValueHolder);
    }

    public Object nullValueFromRow() {
        return new ValueHolder();
    }

    public boolean objectIsInstantiated(Object object) {
        return ((ValueHolderInterface)object).isInstantiated();
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)this.getMapping().getAttributeValueFromObject(object);
        if (valueHolderInterface == null) {
            valueHolderInterface = new ValueHolder(object2);
        } else {
            valueHolderInterface.setValue(object2);
        }
        super.setRealAttributeValueInObject(object, valueHolderInterface);
    }

    protected boolean typeIsValid(Class clazz) {
        return clazz == ClassConstants.ValueHolderInterface_Class || clazz == ClassConstants.WeavedAttributeValueHolderInterface_Class;
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (object == null) {
            return new ValueHolder();
        }
        if (!(object instanceof ValueHolderInterface)) {
            throw DescriptorException.valueHolderInstantiationMismatch(object, this.getMapping());
        }
        return object;
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.returnAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.parameterAndMappingWithIndirectionMismatch(this.getMapping()));
        }
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, AbstractRecord abstractRecord, ObjectLevelReadQuery objectLevelReadQuery) {
        return new BatchValueHolder(readQuery, abstractRecord, this.getForeignReferenceMapping(), objectLevelReadQuery);
    }

    public Object valueFromMethod(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        return new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, abstractRecord, abstractSession);
    }

    public Object valueFromQuery(ReadQuery readQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        return new QueryBasedValueHolder(readQuery, abstractRecord, abstractSession);
    }

    public Object valueFromRow(Object object) {
        return new ValueHolder(object);
    }
}

