/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;

public class UnitOfWorkQueryValueHolder
extends UnitOfWorkValueHolder {
    protected UnitOfWorkQueryValueHolder(ValueHolderInterface valueHolderInterface, Object object, DatabaseMapping databaseMapping, UnitOfWorkImpl unitOfWorkImpl) {
        super(valueHolderInterface, object, databaseMapping, unitOfWorkImpl);
    }

    public UnitOfWorkQueryValueHolder(ValueHolderInterface valueHolderInterface, Object object, ForeignReferenceMapping foreignReferenceMapping, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl) {
        this(valueHolderInterface, object, foreignReferenceMapping, unitOfWorkImpl);
        this.row = abstractRecord;
    }

    protected Object buildBackupCloneFor(Object object) {
        return this.getMapping().buildBackupCloneForPartObject(object, null, null, this.getUnitOfWork());
    }

    public Object buildCloneFor(Object object) {
        return this.getMapping().buildCloneForPartObject(object, null, this.relationshipSourceObject, this.getUnitOfWork(), true);
    }

    public void setValue(Object object) {
        if (!this.isInstantiated()) {
            this.instantiate();
        }
        Object object2 = this.getValue();
        super.setValue(object);
        this.updateForeignReferenceSet(object, object2);
    }

    public void updateForeignReferenceRemove(Object object) {
        DatabaseMapping databaseMapping = this.getMapping();
        if (databaseMapping == null) {
            return;
        }
        if (databaseMapping.isPrivateOwned()) {
            return;
        }
        ForeignReferenceMapping foreignReferenceMapping = this.getRelationshipPartnerFor(object);
        if (foreignReferenceMapping != null && object != null) {
            Object object2 = foreignReferenceMapping.getDescriptor().getObjectBuilder().unwrapObject(object, this.getSession());
            Object object3 = foreignReferenceMapping.getRealAttributeValueFromObject(object2, this.getSession());
            Object object4 = this.getRelationshipSourceObject();
            if (object3 == null) {
                return;
            }
            if (foreignReferenceMapping.isCollectionMapping() && (!(object3 instanceof IndirectContainer) || ((IndirectContainer)object3).isInstantiated()) && !foreignReferenceMapping.getContainerPolicy().contains(object4, object3, this.getSession())) {
                return;
            }
            if (foreignReferenceMapping.isObjectReferenceMapping()) {
                foreignReferenceMapping.setRealAttributeValueInObject(object2, null);
            } else if (foreignReferenceMapping.isCollectionMapping()) {
                foreignReferenceMapping.getContainerPolicy().removeFrom(object4, object3, this.getSession());
            }
        }
    }

    public void updateForeignReferenceSet(Object object, Object object2) {
        if (object != null && ClassConstants.Collection_Class.isAssignableFrom(object.getClass())) {
            return;
        }
        if (this.getMapping() == null) {
            return;
        }
        ForeignReferenceMapping foreignReferenceMapping = this.getRelationshipPartnerFor(object);
        if (foreignReferenceMapping != null) {
            if (object != null) {
                Object object3 = foreignReferenceMapping.getDescriptor().getObjectBuilder().unwrapObject(object, this.getSession());
                Object object4 = foreignReferenceMapping.getRealAttributeValueFromObject(object3, this.getSession());
                Object object5 = this.getRelationshipSourceObject();
                Object object6 = this.getMapping().getDescriptor().getObjectBuilder().wrapObject(object5, this.getSession());
                if (object4 == object5) {
                    return;
                }
                if (foreignReferenceMapping.isCollectionMapping() && (!(object4 instanceof IndirectContainer) || ((IndirectContainer)object4).isInstantiated()) && foreignReferenceMapping.getContainerPolicy().contains(object5, object4, this.getSession())) {
                    return;
                }
                if (object4 != null) {
                    if (this.getMapping().isObjectReferenceMapping()) {
                        if (!foreignReferenceMapping.isCollectionMapping()) {
                            ((ObjectReferenceMapping)this.getMapping()).setRealAttributeValueInObject(object4, null);
                        }
                    } else if (this.getMapping().isCollectionMapping() && !foreignReferenceMapping.isManyToManyMapping()) {
                        this.getMapping().getContainerPolicy().removeFrom(object3, this.getMapping().getRealAttributeValueFromObject(object4, this.getSession()), this.getSession());
                    }
                }
                if (object2 != null) {
                    Object object7 = foreignReferenceMapping.getDescriptor().getObjectBuilder().unwrapObject(object2, this.getSession());
                    if (foreignReferenceMapping.isObjectReferenceMapping()) {
                        foreignReferenceMapping.setRealAttributeValueInObject(object7, null);
                    } else if (foreignReferenceMapping.isCollectionMapping()) {
                        foreignReferenceMapping.getContainerPolicy().removeFrom(object5, foreignReferenceMapping.getRealAttributeValueFromObject(object7, this.getSession()), this.getSession());
                    }
                }
                if (foreignReferenceMapping.isObjectReferenceMapping()) {
                    foreignReferenceMapping.setRealAttributeValueInObject(object3, object6);
                } else if (foreignReferenceMapping.isCollectionMapping()) {
                    foreignReferenceMapping.getContainerPolicy().addInto(object6, object4, this.getSession());
                }
            } else {
                this.updateForeignReferenceRemove(object2);
            }
        }
    }

    private ForeignReferenceMapping getRelationshipPartnerFor(Object object) {
        ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)this.getMapping().getRelationshipPartner();
        if (foreignReferenceMapping == null || object == null) {
            return foreignReferenceMapping;
        }
        if (foreignReferenceMapping.getDescriptor().hasInheritance()) {
            ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
            if (!foreignReferenceMapping.getDescriptor().getJavaClass().isAssignableFrom(classDescriptor.getJavaClass())) {
                return (ForeignReferenceMapping)classDescriptor.getObjectBuilder().getMappingForAttributeName(foreignReferenceMapping.getAttributeName());
            }
        }
        return foreignReferenceMapping;
    }
}

