/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SimpleConditionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.SubqueryNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ReportQuery;

public class InNode
extends SimpleConditionalExpressionNode {
    private List theObjects = null;
    private boolean notIndicated = false;

    public void addNodeToTheObjects(Node node) {
        this.getTheObjects().add(node);
    }

    public void validate(ParseTreeContext parseTreeContext) {
        Object object = null;
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            object = this.left.getType();
        }
        for (Node node : this.getTheObjects()) {
            node.validate(parseTreeContext);
            node.validateParameter(parseTreeContext, object);
            Object object2 = node.getType();
            if (object == null || typeHelper.isAssignableFrom(object, object2)) continue;
            throw JPQLException.invalidExpressionArgument(parseTreeContext.getQueryInfo(), node.getLine(), node.getColumn(), "IN", node.getAsString(), typeHelper.getTypeName(object));
        }
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        List list = this.getTheObjects();
        Node node = (Node)list.get(0);
        if (node.isSubqueryNode()) {
            SubqueryNode subqueryNode = (SubqueryNode)node;
            ReportQuery reportQuery = subqueryNode.getReportQuery(generationContext);
            expression = this.notIndicated() ? expression.notIn(reportQuery) : expression.in(reportQuery);
        } else {
            Vector<Expression> vector = new Vector<Expression>(list.size());
            for (Node node2 : list) {
                vector.add(node2.generateExpression(generationContext));
            }
            if (vector.size() > 0) {
                expression = this.notIndicated() ? expression.notIn(vector) : expression.in(vector);
            }
        }
        return expression;
    }

    public List getTheObjects() {
        if (this.theObjects == null) {
            this.setTheObjects(new Vector());
        }
        return this.theObjects;
    }

    public void setTheObjects(List list) {
        this.theObjects = list;
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }
}

