/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class LiteralNode
extends Node {
    public Object literal;

    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            reportQuery.addAttribute("CONSTANT", this.generateExpression(generationContext));
        }
    }

    public Expression generateExpression(GenerationContext generationContext) {
        ConstantExpression constantExpression = new ConstantExpression(this.getLiteral(), generationContext.getBaseExpression());
        return constantExpression;
    }

    public String getAsString() {
        return this.getLiteral().toString();
    }

    public Object getLiteral() {
        return this.literal;
    }

    public boolean isLiteralNode() {
        return true;
    }

    public void setLiteral(Object object) {
        this.literal = object;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringIndent(n, stringBuffer);
        stringBuffer.append(this.toStringDisplayName() + "[" + this.getLiteral() + "]");
        return stringBuffer.toString();
    }
}

