/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Content;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelGenerator {
    protected static final String SCHEMA_FILE_NAME = "schema";
    protected static final String SCHEMA_FILE_EXT = ".xsd";
    protected static final String COLON = ":";
    protected static final String EMPTY_STRING = "";

    public Map<String, Schema> generateSchemas(java.util.List<XMLDescriptor> list, SchemaModelGeneratorProperties schemaModelGeneratorProperties) throws DescriptorException {
        HashMap<String, Schema> hashMap = new HashMap<String, Schema>();
        Schema schema = null;
        if (schemaModelGeneratorProperties == null) {
            schemaModelGeneratorProperties = new SchemaModelGeneratorProperties();
        }
        for (XMLDescriptor xMLDescriptor : list) {
            String string;
            XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
            if (xMLSchemaReference != null) {
                string = xMLSchemaReference.getSchemaContextAsQName(xMLDescriptor.getNamespaceResolver()).getNamespaceURI();
                schema = this.getSchema(string, xMLDescriptor.getNamespaceResolver(), hashMap, schemaModelGeneratorProperties);
                this.addNamespacesToWorkingSchema(xMLDescriptor.getNamespaceResolver(), schema);
                continue;
            }
            for (DatabaseTable databaseTable : xMLDescriptor.getTables()) {
                string = this.getDefaultRootElementAsQName(xMLDescriptor, databaseTable.getName()).getNamespaceURI();
                schema = this.getSchema(string, xMLDescriptor.getNamespaceResolver(), hashMap, schemaModelGeneratorProperties);
                this.addNamespacesToWorkingSchema(xMLDescriptor.getNamespaceResolver(), schema);
            }
        }
        for (XMLDescriptor xMLDescriptor : list) {
            this.processDescriptor(xMLDescriptor, hashMap, schema, schemaModelGeneratorProperties, list);
        }
        return hashMap;
    }

    protected void processDescriptor(XMLDescriptor xMLDescriptor, HashMap<String, Schema> hashMap, Schema schema, SchemaModelGeneratorProperties schemaModelGeneratorProperties, java.util.List<XMLDescriptor> list) {
        XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
        if (xMLSchemaReference != null) {
            if (xMLSchemaReference.getType() == 1) {
                schema.addTopLevelComplexTypes(this.buildComplexType(false, xMLDescriptor, hashMap, schema, schemaModelGeneratorProperties, list));
            } else if (xMLSchemaReference.getType() == 2) {
                schema.addTopLevelSimpleTypes(this.buildSimpleType(xMLDescriptor, schema));
            }
            for (DatabaseTable databaseTable : xMLDescriptor.getTables()) {
                String string = this.getDefaultRootElementAsQName(xMLDescriptor, databaseTable.getName()).getLocalPart();
                Element element = new Element();
                element.setName(string);
                QName qName = xMLSchemaReference.getSchemaContextAsQName(schema.getNamespaceResolver());
                String string2 = qName.getLocalPart();
                String string3 = qName.getNamespaceURI();
                String string4 = schema.getNamespaceResolver().resolveNamespaceURI(string3);
                if (string4 != null) {
                    string2 = string4 + COLON + string2;
                }
                element.setType(string2);
                schema.addTopLevelElement(element);
            }
        } else {
            for (DatabaseTable databaseTable : xMLDescriptor.getTables()) {
                String string = this.getDefaultRootElementAsQName(xMLDescriptor, databaseTable.getName()).getLocalPart();
                if (schema.getTopLevelElements().get(string) != null) continue;
                Element element = new Element();
                element.setName(string);
                element.setComplexType(this.buildComplexType(true, xMLDescriptor, hashMap, schema, schemaModelGeneratorProperties, list));
                schema.addTopLevelElement(element);
            }
        }
    }

    private Schema getSchema(String string, NamespaceResolver namespaceResolver, HashMap<String, Schema> hashMap, SchemaModelGeneratorProperties schemaModelGeneratorProperties) {
        Schema schema = hashMap.get(string);
        if (schema == null) {
            schema = this.buildNewSchema(string, namespaceResolver, hashMap.size(), schemaModelGeneratorProperties);
            hashMap.put(string, schema);
        }
        return schema;
    }

    protected SimpleType buildSimpleType(XMLDescriptor xMLDescriptor, Schema schema) {
        Object object;
        SimpleType simpleType = this.buildNewSimpleType(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()).getLocalPart());
        DatabaseMapping databaseMapping = xMLDescriptor.getMappings().get(0);
        QName qName = (QName)XMLConversionManager.getDefaultJavaTypes().get(databaseMapping.getAttributeClassification());
        String string = qName.getLocalPart();
        if (qName.getNamespaceURI() != null) {
            object = schema.getNamespaceResolver().resolveNamespaceURI(qName.getNamespaceURI());
            if (object == null) {
                object = schema.getNamespaceResolver().generatePrefix();
                schema.getNamespaceResolver().put((String)object, qName.getNamespaceURI());
            }
            string = (String)object + COLON + string;
        }
        object = new Restriction();
        ((Restriction)object).setBaseType(string);
        simpleType.setRestriction((Restriction)object);
        return simpleType;
    }

    protected SimpleType buildNewSimpleType(String string) {
        SimpleType simpleType = new SimpleType();
        simpleType.setName(string);
        return simpleType;
    }

    private ComplexType buildComplexType(boolean bl, XMLDescriptor xMLDescriptor, HashMap<String, Schema> hashMap, Schema schema, SchemaModelGeneratorProperties schemaModelGeneratorProperties, java.util.List<XMLDescriptor> list) {
        Object object;
        ComplexType complexType = new ComplexType();
        if (!bl) {
            complexType.setName(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()).getLocalPart());
        }
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicyOrNull();
        Extension extension = null;
        if (inheritancePolicy != null && inheritancePolicy.getParentClass() != null) {
            extension = new Extension();
            extension.setBaseType(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()).getLocalPart());
            object = new ComplexContent();
            ((Content)object).setExtension(extension);
            complexType.setComplexContent((ComplexContent)object);
        }
        object = new Sequence();
        for (DatabaseMapping databaseMapping : xMLDescriptor.getMappings()) {
            this.processMapping(databaseMapping, (Sequence)object, complexType, hashMap, schema, schemaModelGeneratorProperties, list);
        }
        if (extension != null) {
            extension.setSequence((Sequence)object);
        } else {
            complexType.setSequence((Sequence)object);
        }
        return complexType;
    }

    protected String getSchemaTypeForDirectMapping(XMLDirectMapping xMLDirectMapping, Schema schema) {
        return this.getSchemaTypeForElement((XMLField)xMLDirectMapping.getField(), xMLDirectMapping.getAttributeClassification(), schema);
    }

    protected String getSchemaTypeForElement(XMLField xMLField, Class clazz, Schema schema) {
        String string = null;
        QName qName = xMLField.getSchemaType();
        string = qName != null ? this.getSchemaTypeString(qName, schema) : (clazz != null && !clazz.equals(ClassConstants.STRING) ? this.getSchemaTypeString((QName)XMLConversionManager.getDefaultJavaTypes().get(clazz), schema) : this.getSchemaTypeString(XMLConstants.STRING_QNAME, schema));
        return string;
    }

    private XMLDescriptor getDescriptorByName(String string, java.util.List<XMLDescriptor> list) {
        for (XMLDescriptor xMLDescriptor : list) {
            if (!xMLDescriptor.getJavaClassName().equals(string)) continue;
            return xMLDescriptor;
        }
        return null;
    }

    private void processXMLDirectMapping(XMLDirectMapping xMLDirectMapping, Sequence sequence, ComplexType complexType, Schema schema) {
        XPathFragment xPathFragment = ((XMLField)xMLDirectMapping.getField()).getXPathFragment();
        if (xPathFragment.isSelfFragment()) {
            return;
        }
        String string = this.getSchemaTypeForDirectMapping(xMLDirectMapping, schema);
        if (xPathFragment.isAttribute()) {
            Attribute attribute = this.buildAttribute(xMLDirectMapping, string);
            complexType.getOrderedAttributes().add(attribute);
        } else {
            Element element = this.buildElement(xPathFragment, string, "0", null);
            sequence.addElement(element);
        }
    }

    private void processXMLCompositeDirectCollectionMapping(XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping, Sequence sequence, ComplexType complexType, Schema schema) {
        Element element;
        XMLField xMLField = (XMLField)xMLCompositeDirectCollectionMapping.getField();
        String string = this.getSchemaTypeForElement(xMLField, xMLCompositeDirectCollectionMapping.getAttributeElementClass(), schema);
        if (xMLField.usesSingleNode()) {
            SimpleType simpleType = new SimpleType();
            List list = new List();
            if (string == null) {
                string = this.getSchemaTypeString(XMLConstants.ANY_SIMPLE_TYPE_QNAME, schema);
            }
            list.setItemType(string);
            simpleType.setList(list);
            element = this.buildElement(xMLField.getXPathFragment(), null, "0", null);
            element.setSimpleType(simpleType);
        } else {
            element = this.buildElement(xMLField.getXPathFragment(), string, "0", null);
            element.setMaxOccurs("unbounded");
        }
        sequence.addElement(element);
    }

    private void processXMLCompositeObjectMapping(XMLCompositeObjectMapping xMLCompositeObjectMapping, Sequence sequence, ComplexType complexType, HashMap<String, Schema> hashMap, Schema schema, SchemaModelGeneratorProperties schemaModelGeneratorProperties, java.util.List<XMLDescriptor> list) {
        String string = xMLCompositeObjectMapping.getReferenceClassName();
        XMLDescriptor xMLDescriptor = this.getDescriptorByName(string, list);
        if (xMLDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(string, xMLCompositeObjectMapping);
        }
        Element element = this.buildElement(((XMLField)xMLCompositeObjectMapping.getField()).getXPathFragment(), null, "0", null);
        ComplexType complexType2 = null;
        if (xMLDescriptor.getSchemaReference() == null) {
            complexType2 = this.buildComplexType(true, xMLDescriptor, hashMap, schema, schemaModelGeneratorProperties, list);
        } else {
            element.setType(this.getSchemaTypeString(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()), schema));
        }
        XPathFragment xPathFragment = ((XMLField)xMLCompositeObjectMapping.getField()).getXPathFragment();
        String string2 = xPathFragment.getNamespaceURI();
        if (string2 != null) {
            Schema schema2 = this.getSchema(string2, null, hashMap, schemaModelGeneratorProperties);
            String string3 = schema.getTargetNamespace();
            if (schema2.isElementFormDefault() && !string2.equals(string3) || !schema2.isElementFormDefault() && !string2.equals(EMPTY_STRING)) {
                if (schema2.getTopLevelElements().get(xPathFragment.getShortName()) == null) {
                    Element element2 = new Element();
                    element2.setName(xPathFragment.getLocalName());
                    if (complexType2 != null) {
                        element2.setComplexType(complexType2);
                    } else {
                        element2.setType(this.getSchemaTypeString(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()), schema));
                    }
                    schema2.getTopLevelElements().put(xPathFragment.getShortName(), element2);
                }
                element = new Element();
                element.setMinOccurs("0");
                element.setRef(xPathFragment.getShortName());
            } else {
                element.setComplexType(complexType2);
            }
        } else if (complexType2 != null) {
            element.setComplexType(complexType2);
        }
        sequence.addElement(element);
    }

    private void processXMLCompositeCollectionMapping(XMLCompositeCollectionMapping xMLCompositeCollectionMapping, Sequence sequence, ComplexType complexType, HashMap<String, Schema> hashMap, Schema schema, SchemaModelGeneratorProperties schemaModelGeneratorProperties, java.util.List<XMLDescriptor> list) {
        String string = xMLCompositeCollectionMapping.getReferenceClassName();
        XMLDescriptor xMLDescriptor = this.getDescriptorByName(string, list);
        if (xMLDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(string, xMLCompositeCollectionMapping);
        }
        Element element = this.buildElement(((XMLField)xMLCompositeCollectionMapping.getField()).getXPathFragment(), null, "0", "unbounded");
        ComplexType complexType2 = null;
        if (xMLDescriptor.getSchemaReference() == null) {
            complexType2 = this.buildComplexType(true, xMLDescriptor, hashMap, schema, schemaModelGeneratorProperties, list);
        } else {
            element.setType(this.getSchemaTypeString(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()), schema));
        }
        XPathFragment xPathFragment = ((XMLField)xMLCompositeCollectionMapping.getField()).getXPathFragment();
        String string2 = xPathFragment.getNamespaceURI();
        if (string2 != null) {
            Schema schema2 = this.getSchema(string2, null, hashMap, schemaModelGeneratorProperties);
            String string3 = schema.getTargetNamespace();
            if (schema2.isElementFormDefault() && !string2.equals(string3) || !schema2.isElementFormDefault() && !string2.equals(EMPTY_STRING)) {
                if (schema2.getTopLevelElements().get(xPathFragment.getShortName()) == null) {
                    Element element2 = new Element();
                    element2.setName(xPathFragment.getLocalName());
                    if (complexType2 != null) {
                        element2.setComplexType(complexType2);
                    } else {
                        element2.setType(this.getSchemaTypeString(xMLDescriptor.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver()), schema));
                    }
                    schema2.getTopLevelElements().put(xPathFragment.getShortName(), element2);
                }
                element = new Element();
                element.setMinOccurs("0");
                element.setMaxOccurs("unbounded");
                element.setRef(xPathFragment.getShortName());
            } else {
                element.setComplexType(complexType2);
            }
        } else if (complexType2 != null) {
            element.setComplexType(complexType2);
        }
        sequence.addElement(element);
    }

    private void processMapping(DatabaseMapping databaseMapping, Sequence sequence, ComplexType complexType, HashMap<String, Schema> hashMap, Schema schema, SchemaModelGeneratorProperties schemaModelGeneratorProperties, java.util.List<XMLDescriptor> list) {
        if (databaseMapping instanceof XMLDirectMapping) {
            this.processXMLDirectMapping((XMLDirectMapping)databaseMapping, sequence, complexType, schema);
        } else if (databaseMapping instanceof XMLCompositeDirectCollectionMapping) {
            this.processXMLCompositeDirectCollectionMapping((XMLCompositeDirectCollectionMapping)databaseMapping, sequence, complexType, schema);
        } else if (databaseMapping instanceof XMLCompositeObjectMapping) {
            this.processXMLCompositeObjectMapping((XMLCompositeObjectMapping)databaseMapping, sequence, complexType, hashMap, schema, schemaModelGeneratorProperties, list);
        } else if (databaseMapping instanceof XMLCompositeCollectionMapping) {
            this.processXMLCompositeCollectionMapping((XMLCompositeCollectionMapping)databaseMapping, sequence, complexType, hashMap, schema, schemaModelGeneratorProperties, list);
        }
    }

    protected Attribute buildAttribute(XMLDirectMapping xMLDirectMapping, String string) {
        XPathFragment xPathFragment = ((XMLField)xMLDirectMapping.getField()).getXPathFragment();
        Attribute attribute = new Attribute();
        attribute.setName(xPathFragment.getShortName());
        attribute.setType(string);
        return attribute;
    }

    private Element buildElement(XPathFragment xPathFragment, String string, String string2, String string3) {
        Element element = new Element();
        element.setName(xPathFragment.getLocalName());
        element.setMinOccurs(string2);
        element.setMaxOccurs(string3);
        if (string != null) {
            element.setType(string);
        }
        return element;
    }

    private Element buildElement(String string, String string2, String string3) {
        Element element = new Element();
        element.setName(string);
        element.setMinOccurs(string2);
        element.setMaxOccurs(string3);
        return element;
    }

    protected String getSchemaTypeString(QName qName, Schema schema) {
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        String string3 = schema.getNamespaceResolver().resolveNamespaceURI(string2);
        if (string3 == null && !string2.equals(schema.getDefaultNamespace())) {
            string3 = string2.equals("http://www.w3.org/2001/XMLSchema") ? schema.getNamespaceResolver().generatePrefix("xsd") : (string2.equals("http://www.w3.org/2001/XMLSchema-instance") ? schema.getNamespaceResolver().generatePrefix("xsi") : schema.getNamespaceResolver().generatePrefix());
            schema.getNamespaceResolver().put(string3, string2);
        }
        if (string3 != null) {
            string = string3 + COLON + string;
        }
        return string;
    }

    private void addNamespacesToWorkingSchema(NamespaceResolver namespaceResolver, Schema schema) {
        if (namespaceResolver != null) {
            Vector vector = namespaceResolver.getNamespaces();
            for (Namespace namespace : vector) {
                schema.getNamespaceResolver().put(namespace.getPrefix(), namespace.getNamespaceURI());
            }
        }
    }

    private Schema buildNewSchema(String string, NamespaceResolver namespaceResolver, int n, SchemaModelGeneratorProperties schemaModelGeneratorProperties) {
        Object object;
        Schema schema = new Schema();
        schema.setName(SCHEMA_FILE_NAME + n + SCHEMA_FILE_EXT);
        ++n;
        String string2 = null;
        if (namespaceResolver != null && (string2 = namespaceResolver.getDefaultNamespaceURI()) != null) {
            schema.setDefaultNamespace(string2);
            schema.getNamespaceResolver().setDefaultNamespaceURI(string2);
        }
        if (!string.equals(EMPTY_STRING)) {
            schema.setTargetNamespace(string);
            object = null;
            if (namespaceResolver != null) {
                object = namespaceResolver.resolveNamespaceURI(string);
            }
            if (object == null && !string.equals(string2)) {
                object = schema.getNamespaceResolver().generatePrefix();
                schema.getNamespaceResolver().put((String)object, string);
            }
        }
        if ((object = schemaModelGeneratorProperties.getProperties(string)) != null) {
            if (((Properties)object).containsKey("elementFormQualified")) {
                schema.setElementFormDefault((Boolean)((Properties)object).get("elementFormQualified"));
            }
            if (((Properties)object).containsKey("attributeFormQualified")) {
                schema.setAttributeFormDefault((Boolean)((Properties)object).get("attributeFormQualified"));
            }
        }
        return schema;
    }

    private boolean importExists(Schema schema, String string) {
        java.util.List list = schema.getImports();
        for (Import import_ : list) {
            if (import_.getSchemaLocation() == null || !import_.getSchemaLocation().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected QName getDefaultRootElementAsQName(XMLDescriptor xMLDescriptor, String string) {
        QName qName = null;
        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
        int n = string.indexOf(COLON);
        String string2 = string.substring(n + 1);
        if (n > -1) {
            String string3 = string.substring(0, n);
            String string4 = namespaceResolver.resolveNamespacePrefix(string3);
            qName = new QName(string4, string2);
        } else {
            qName = namespaceResolver.getDefaultNamespaceURI() != null ? new QName(namespaceResolver.getDefaultNamespaceURI(), string2) : new QName(string2);
        }
        return qName;
    }
}

