/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;

public abstract class AbstractSessionLog
implements SessionLog,
Cloneable {
    protected int level;
    protected static SessionLog defaultLog;
    protected Session session;
    protected static String SEVERE_PREFIX;
    protected static String WARNING_PREFIX;
    protected static String INFO_PREFIX;
    protected static String CONFIG_PREFIX;
    protected static String FINE_PREFIX;
    protected static String FINER_PREFIX;
    protected static String FINEST_PREFIX;
    protected static String TOPLINK_PREFIX;
    protected static final String CONNECTION_STRING = "Connection";
    protected static final String THREAD_STRING = "Thread";
    protected Writer writer = new PrintWriter(System.out);
    protected static String DATE_FORMAT_STR;
    protected DateFormat dateFormat;
    protected Boolean shouldLogExceptionStackTrace;
    protected Boolean shouldPrintDate;
    protected Boolean shouldPrintThread;
    protected Boolean shouldPrintSession;
    protected Boolean shouldPrintConnection;

    public static int getDefaultLoggingLevel() {
        String string = System.getProperty("eclipselink.logging.level");
        return AbstractSessionLog.translateStringToLoggingLevel(string);
    }

    public AbstractSessionLog() {
        this.level = AbstractSessionLog.getDefaultLoggingLevel();
    }

    public int getLevel() {
        return this.getLevel(null);
    }

    public String getLevelString() {
        int n = this.getLevel();
        switch (n) {
            case 8: {
                return "OFF";
            }
            case 7: {
                return "SEVERE";
            }
            case 6: {
                return "WARNING";
            }
            case 5: {
                return "INFO";
            }
            case 4: {
                return "CONFIG";
            }
            case 3: {
                return "FINE";
            }
            case 2: {
                return "FINER";
            }
            case 1: {
                return "FINEST";
            }
            case 0: {
                return "ALL";
            }
        }
        return "INFO";
    }

    public int getLevel(String string) {
        return this.level;
    }

    public void setLevel(int n) {
        this.setLevel(n, null);
    }

    public void setLevel(int n, String string) {
        this.level = n;
    }

    public boolean shouldLog(int n) {
        return this.shouldLog(n, null);
    }

    public boolean shouldLog(int n, String string) {
        return this.level <= n && !this.isOff();
    }

    public static SessionLog getLog() {
        if (defaultLog == null) {
            defaultLog = new DefaultSessionLog();
        }
        return defaultLog;
    }

    public static void setLog(SessionLog sessionLog) {
        defaultLog = sessionLog;
        defaultLog.setSession(null);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void log(int n, String string) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, null, false);
    }

    public void log(int n, String string, Object object) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, new Object[]{object});
    }

    public void log(int n, String string, Object object, Object object2) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, new Object[]{object, object2});
    }

    public void log(int n, String string, Object object, Object object2, Object object3) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, new Object[]{object, object2, object3});
    }

    public void log(int n, String string, Object[] objectArray) {
        this.log(n, string, objectArray, true);
    }

    public void log(int n, String string, Object[] objectArray, boolean bl) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(new SessionLogEntry(n, null, string, objectArray, null, bl));
    }

    public abstract void log(SessionLogEntry var1);

    public boolean shouldPrintSession() {
        return this.shouldPrintSession == null || this.shouldPrintSession != false;
    }

    public void setShouldPrintSession(boolean bl) {
        this.shouldPrintSession = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintConnection() {
        return this.shouldPrintConnection == null || this.shouldPrintConnection != false;
    }

    public void setShouldPrintConnection(boolean bl) {
        this.shouldPrintConnection = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldLogExceptionStackTrace() {
        if (this.shouldLogExceptionStackTrace == null) {
            return this.getLevel() <= 2;
        }
        return this.shouldLogExceptionStackTrace;
    }

    public void setShouldLogExceptionStackTrace(boolean bl) {
        this.shouldLogExceptionStackTrace = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintDate() {
        return this.shouldPrintDate == null || this.shouldPrintDate != false;
    }

    public void setShouldPrintDate(boolean bl) {
        this.shouldPrintDate = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintThread() {
        if (this.shouldPrintThread == null) {
            return this.getLevel() <= 3;
        }
        return this.shouldPrintThread;
    }

    public void setShouldPrintThread(boolean bl) {
        this.shouldPrintThread = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream outputStream) {
        this.writer = new OutputStreamWriter(outputStream);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    protected String getDateString(Date date) {
        if (this.getDateFormat() != null) {
            return this.getDateFormat().format(date);
        }
        if (date == null) {
            return null;
        }
        return ConversionManager.getDefaultManager().convertObject(date, String.class).toString();
    }

    protected String getSupplementDetailString(SessionLogEntry sessionLogEntry) {
        StringWriter stringWriter = new StringWriter();
        if (this.shouldPrintDate()) {
            stringWriter.write(this.getDateString(sessionLogEntry.getDate()));
            stringWriter.write("--");
        }
        if (this.shouldPrintSession() && sessionLogEntry.getSession() != null) {
            stringWriter.write(this.getSessionString(sessionLogEntry.getSession()));
            stringWriter.write("--");
        }
        if (this.shouldPrintConnection() && sessionLogEntry.getConnection() != null) {
            stringWriter.write(this.getConnectionString(sessionLogEntry.getConnection()));
            stringWriter.write("--");
        }
        if (this.shouldPrintThread()) {
            stringWriter.write(this.getThreadString(sessionLogEntry.getThread()));
            stringWriter.write("--");
        }
        return stringWriter.toString();
    }

    protected String getSessionString(Session session) {
        if (session != null) {
            return ((AbstractSession)session).getLogSessionString();
        }
        return "";
    }

    protected String getConnectionString(Accessor accessor) {
        if (accessor.getDatasourceConnection() == null) {
            return "Connection(" + String.valueOf(System.identityHashCode(accessor)) + ")";
        }
        return "Connection(" + String.valueOf(System.identityHashCode(accessor.getDatasourceConnection())) + ")";
    }

    protected String getThreadString(Thread thread) {
        return "Thread(" + String.valueOf(thread) + ")";
    }

    protected void printPrefixString(int n) {
        try {
            switch (n) {
                case 7: {
                    if (SEVERE_PREFIX == null) {
                        SEVERE_PREFIX = LoggingLocalization.buildMessage("toplink_severe");
                    }
                    this.getWriter().write(SEVERE_PREFIX);
                    break;
                }
                case 6: {
                    if (WARNING_PREFIX == null) {
                        WARNING_PREFIX = LoggingLocalization.buildMessage("toplink_warning");
                    }
                    this.getWriter().write(WARNING_PREFIX);
                    break;
                }
                case 5: {
                    if (INFO_PREFIX == null) {
                        INFO_PREFIX = LoggingLocalization.buildMessage("toplink_info");
                    }
                    this.getWriter().write(INFO_PREFIX);
                    break;
                }
                case 4: {
                    if (CONFIG_PREFIX == null) {
                        CONFIG_PREFIX = LoggingLocalization.buildMessage("toplink_config");
                    }
                    this.getWriter().write(CONFIG_PREFIX);
                    break;
                }
                case 3: {
                    if (FINE_PREFIX == null) {
                        FINE_PREFIX = LoggingLocalization.buildMessage("toplink_fine");
                    }
                    this.getWriter().write(FINE_PREFIX);
                    break;
                }
                case 2: {
                    if (FINER_PREFIX == null) {
                        FINER_PREFIX = LoggingLocalization.buildMessage("toplink_finer");
                    }
                    this.getWriter().write(FINER_PREFIX);
                    break;
                }
                case 1: {
                    if (FINEST_PREFIX == null) {
                        FINEST_PREFIX = LoggingLocalization.buildMessage("toplink_finest");
                    }
                    this.getWriter().write(FINEST_PREFIX);
                    break;
                }
                default: {
                    if (TOPLINK_PREFIX == null) {
                        TOPLINK_PREFIX = LoggingLocalization.buildMessage("toplink");
                    }
                    this.getWriter().write(TOPLINK_PREFIX);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw ValidationException.logIOError(iOException);
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected String formatMessage(SessionLogEntry sessionLogEntry) {
        String string = sessionLogEntry.getMessage();
        if (sessionLogEntry.shouldTranslate()) {
            string = sessionLogEntry.getLevel() > 3 ? LoggingLocalization.buildMessage(string, sessionLogEntry.getParameters()) : TraceLocalization.buildMessage(string, sessionLogEntry.getParameters(), true);
        } else if (sessionLogEntry.getParameters() != null && sessionLogEntry.getParameters().length > 0 && string.indexOf("{0") >= 0) {
            string = MessageFormat.format(string, sessionLogEntry.getParameters());
        } else if (string.indexOf("{") == -1) {
            string = TraceLocalization.buildMessage(string, false);
        }
        return string;
    }

    public static int translateStringToLoggingLevel(String string) {
        if (string == null) {
            return 5;
        }
        String string2 = string.toUpperCase();
        if (string2.equals("OFF")) {
            return 8;
        }
        if (string2.equals("SEVERE")) {
            return 7;
        }
        if (string2.equals("WARNING")) {
            return 6;
        }
        if (string2.equals("INFO")) {
            return 5;
        }
        if (string2.equals("CONFIG")) {
            return 4;
        }
        if (string2.equals("FINE")) {
            return 3;
        }
        if (string2.equals("FINER")) {
            return 2;
        }
        if (string2.equals("FINEST")) {
            return 1;
        }
        if (string2.equals("ALL")) {
            return 0;
        }
        return 5;
    }

    public void throwing(Throwable throwable) {
        if (this.shouldLog(2)) {
            SessionLogEntry sessionLogEntry = new SessionLogEntry(null, throwable);
            sessionLogEntry.setLevel(2);
            this.log(sessionLogEntry);
        }
    }

    public void severe(String string) {
        this.log(7, string, null);
    }

    public void warning(String string) {
        this.log(6, string, null);
    }

    public void info(String string) {
        this.log(5, string, null);
    }

    public void config(String string) {
        this.log(4, string, null);
    }

    public void fine(String string) {
        this.log(3, string, null);
    }

    public void finer(String string) {
        this.log(2, string, null);
    }

    public void finest(String string) {
        this.log(1, string, null);
    }

    public void logThrowable(int n, Throwable throwable) {
        if (this.shouldLog(n)) {
            this.log(new SessionLogEntry(null, n, null, throwable));
        }
    }

    public boolean isOff() {
        return this.level == 8;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String translateLoggingLevelToString(int n) {
        if (n == 8) {
            return "OFF";
        }
        if (n == 7) {
            return "SEVERE";
        }
        if (n == 6) {
            return "WARNING";
        }
        if (n == 5) {
            return "INFO";
        }
        if (n == 4) {
            return "CONFIG";
        }
        if (n == 3) {
            return "FINE";
        }
        if (n == 2) {
            return "FINER";
        }
        if (n == 1) {
            return "FINEST";
        }
        if (n == 0) {
            return "ALL";
        }
        return "INFO";
    }

    static {
        SEVERE_PREFIX = null;
        WARNING_PREFIX = null;
        INFO_PREFIX = null;
        CONFIG_PREFIX = null;
        FINE_PREFIX = null;
        FINER_PREFIX = null;
        FINEST_PREFIX = null;
        TOPLINK_PREFIX = null;
        DATE_FORMAT_STR = "yyyy.MM.dd HH:mm:ss.SSS";
    }
}

