/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.weaving.ClassWeaver;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class ForeignReferenceMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient AbstractSession tempInitSession;
    protected transient ClassDescriptor referenceDescriptor;
    protected transient ReadQuery selectionQuery;
    protected boolean isPrivateOwned = false;
    protected boolean usesBatchReading = false;
    protected IndirectionPolicy indirectionPolicy;
    protected transient boolean hasCustomSelectionQuery = false;
    protected DatabaseMapping relationshipPartner;
    protected String relationshipPartnerAttributeName;
    protected boolean cascadePersist;
    protected boolean cascadeMerge;
    protected boolean cascadeRefresh;
    protected boolean cascadeRemove;
    protected boolean requiresTransientWeavedFields;
    protected int joinFetch = 0;
    public static final int INNER_JOIN = 1;
    public static final int OUTER_JOIN = 2;
    public static final int NONE = 0;
    protected boolean forceInitializationOfSelectionCriteria;

    protected ForeignReferenceMapping() {
        this.useBasicIndirection();
        this.cascadePersist = false;
        this.cascadeMerge = false;
        this.cascadeRefresh = false;
        this.cascadeRemove = false;
        this.requiresTransientWeavedFields = true;
        this.forceInitializationOfSelectionCriteria = false;
    }

    protected Object batchedValueFromRow(AbstractRecord abstractRecord, ReadAllQuery readAllQuery) {
        ReadQuery readQuery = (ReadQuery)readAllQuery.getProperty(this);
        if (readQuery == null) {
            if (readAllQuery.getBatchReadMappingQueries() != null) {
                readQuery = (ReadQuery)readAllQuery.getBatchReadMappingQueries().get(this);
            }
            if (readQuery == null) {
                readQuery = this.prepareNestedBatchQuery(readAllQuery);
                readQuery.setIsExecutionClone(true);
            } else {
                readQuery = (ReadQuery)readQuery.clone();
                readQuery.setIsExecutionClone(true);
            }
            readAllQuery.setProperty(this, readQuery);
        }
        return this.getIndirectionPolicy().valueFromBatchQuery(readQuery, abstractRecord, readAllQuery);
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.getIndirectionPolicy().backupCloneAttribute(object3, object, object2, unitOfWorkImpl);
        this.setAttributeValueInObject(object2, object4);
    }

    public abstract Object buildBackupCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4);

    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.getIndirectionPolicy().cloneAttribute(object3, object, object2, unitOfWorkImpl, false);
        this.setAttributeValueInObject(object2, object4);
    }

    public void buildCloneFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        Object object2 = this.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
        Object object3 = this.getIndirectionPolicy().cloneAttribute(object2, null, object, unitOfWorkImpl, true);
        this.setAttributeValueInObject(object, object3);
    }

    public abstract Object buildCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4, boolean var5);

    public Object clone() {
        ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)super.clone();
        foreignReferenceMapping.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        foreignReferenceMapping.setSelectionQuery((ReadQuery)this.getSelectionQuery().clone());
        return foreignReferenceMapping;
    }

    public abstract Object[] buildReferencesPKList(Object var1, Object var2, AbstractSession var3);

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        if (this.isPrivateOwned()) {
            return this.compareObjectsWithPrivateOwned(object, object2, abstractSession);
        }
        return this.compareObjectsWithoutPrivateOwned(object, object2, abstractSession);
    }

    protected abstract boolean compareObjectsWithoutPrivateOwned(Object var1, Object var2, AbstractSession var3);

    protected abstract boolean compareObjectsWithPrivateOwned(Object var1, Object var2, AbstractSession var3);

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.getReferenceClassName() != null) {
            Class clazz;
            block7: {
                clazz = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                            break block7;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), privilegedActionException.getException());
                        }
                    }
                    clazz = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), classNotFoundException);
                }
            }
            this.setReferenceClass(clazz);
        }
        if (this.getSelectionQuery() != null) {
            this.getSelectionQuery().convertClassNamesToClasses(classLoader);
        }
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return new UnitOfWorkQueryValueHolder(valueHolderInterface, object2, this, abstractRecord, unitOfWorkImpl);
    }

    protected boolean dontDoMerge(Object object, Object object2, MergeManager mergeManager) {
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return true;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            if (!this.isAttributeValueInstantiated(object)) {
                return true;
            }
        } else {
            if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
                return true;
            }
            if (!this.isAttributeValueInstantiated(object2)) {
                return true;
            }
        }
        return false;
    }

    public void dontUseBatchReading() {
        this.setUsesBatchReading(false);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) throws QueryException {
        throw QueryException.batchReadingNotSupported(this, databaseQuery);
    }

    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)((ObjectLevelReadQuery)this.getSelectionQuery()).deepClone();
        objectLevelReadQuery.setSession(abstractSession);
        if (objectBuildingQuery.hasPartialAttributeExpressions()) {
            objectLevelReadQuery.setPartialAttributeExpressions(this.extractNestedExpressions(((ObjectLevelReadQuery)objectBuildingQuery).getPartialAttributeExpressions(), objectLevelReadQuery.getExpressionBuilder(), false));
            if (objectLevelReadQuery.getPartialAttributeExpressions().isEmpty() && this.hasRootExpressionThatShouldUseOuterJoin(((ObjectLevelReadQuery)objectBuildingQuery).getPartialAttributeExpressions())) {
                objectLevelReadQuery.setShouldBuildNullForNullPk(true);
            }
        } else {
            Vector vector = this.extractNestedExpressions(joinedAttributeManager.getJoinedAttributeExpressions(), objectLevelReadQuery.getExpressionBuilder(), false);
            if (vector.size() > 0) {
                objectLevelReadQuery.getJoinedAttributeManager().clear();
                objectLevelReadQuery.getJoinedAttributeManager().setJoinedAttributeExpressions_(vector);
                objectLevelReadQuery.getJoinedAttributeManager().prepareJoinExpressions(abstractSession);
                objectLevelReadQuery.getJoinedAttributeManager().computeJoiningMappingIndexes(true, abstractSession, 0);
            } else if (objectLevelReadQuery.hasJoining()) {
                objectLevelReadQuery.setJoinedAttributeManager(null);
            }
            if (objectBuildingQuery.isLockQuery()) {
                if (((ObjectLevelReadQuery)objectBuildingQuery).getLockingClause().isForUpdateOfClause()) {
                    ForUpdateOfClause forUpdateOfClause = (ForUpdateOfClause)((ObjectLevelReadQuery)objectBuildingQuery).getLockingClause().clone();
                    forUpdateOfClause.setLockedExpressions(this.extractNestedExpressions(forUpdateOfClause.getLockedExpressions(), objectLevelReadQuery.getExpressionBuilder(), true));
                    objectLevelReadQuery.setLockingClause(forUpdateOfClause);
                } else {
                    objectLevelReadQuery.setLockingClause(((ObjectLevelReadQuery)objectBuildingQuery).getLockingClause());
                }
            }
        }
        objectLevelReadQuery.setShouldMaintainCache(objectBuildingQuery.shouldMaintainCache());
        objectLevelReadQuery.setShouldRefreshIdentityMapResult(objectBuildingQuery.shouldRefreshIdentityMapResult());
        if (objectBuildingQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)objectBuildingQuery).hasAsOfClause()) {
            objectLevelReadQuery.setAsOfClause(((ObjectLevelReadQuery)objectBuildingQuery).getAsOfClause());
        }
        objectLevelReadQuery.setCascadePolicy(objectBuildingQuery.getCascadePolicy());
        if (objectLevelReadQuery.hasJoining()) {
            objectLevelReadQuery.getJoinedAttributeManager().computeJoiningMappingQueries(abstractSession);
        }
        objectLevelReadQuery.setSession(null);
        return objectLevelReadQuery;
    }

    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
    }

    public ReadQuery prepareNestedBatchQuery(ReadAllQuery readAllQuery) {
        Object object;
        ReadQuery readQuery;
        ReadAllQuery readAllQuery2 = new ReadAllQuery();
        readAllQuery2.setReferenceClass(this.getReferenceClass());
        readAllQuery2.setDescriptor(this.getReferenceDescriptor());
        readAllQuery2.setSession(readAllQuery.getSession());
        readAllQuery2.setShouldUseWrapperPolicy(false);
        if (readAllQuery.shouldCascadeAllParts() || readAllQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || readAllQuery.shouldCascadeByMapping() && this.cascadeRefresh) {
            readAllQuery2.setShouldRefreshIdentityMapResult(readAllQuery.shouldRefreshIdentityMapResult());
            readAllQuery2.setCascadePolicy(readAllQuery.getCascadePolicy());
            readAllQuery2.setShouldMaintainCache(readAllQuery.shouldMaintainCache());
            if (readAllQuery.hasAsOfClause()) {
                readAllQuery2.setAsOfClause(readAllQuery.getAsOfClause());
            }
            readAllQuery2.setShouldBindAllParameters(readAllQuery.getShouldBindAllParameters());
            readAllQuery2.setShouldPrepare(readAllQuery.shouldPrepare());
        }
        readAllQuery2.setQueryId(readAllQuery.getQueryId());
        ClassDescriptor classDescriptor = readAllQuery.getDescriptor();
        if (classDescriptor != this.getDescriptor() && !classDescriptor.getMappings().contains(this) && !this.getDescriptor().isAggregateDescriptor()) {
            classDescriptor = this.getDescriptor();
        }
        ExpressionBuilder expressionBuilder = readAllQuery2.getExpressionBuilder();
        Expression expression = expressionBuilder.getManualQueryKey(this.getAttributeName() + "-back-ref", classDescriptor);
        Expression expression2 = expression.twist(this.getSelectionCriteria(), expressionBuilder);
        if (readAllQuery.getSelectionCriteria() != null) {
            expression2 = expression2.and(readAllQuery.getSelectionCriteria().cloneUsing(expression));
        }
        if (classDescriptor.getQueryManager().getAdditionalJoinExpression() != null) {
            expression2 = expression2.and(classDescriptor.getQueryManager().getAdditionalJoinExpression().rebuildOn(expression));
        }
        if (classDescriptor.getHistoryPolicy() != null) {
            if (readAllQuery.getSession().getAsOfClause() != null) {
                expression.asOf(readAllQuery.getSession().getAsOfClause());
            } else if (readAllQuery2.getAsOfClause() == null) {
                expression.asOf(AsOfClause.NO_CLAUSE);
            } else {
                expression.asOf(readAllQuery2.getAsOfClause());
            }
            expression2 = expression2.and(classDescriptor.getHistoryPolicy().additionalHistoryExpression((ObjectExpression)expression));
        }
        readAllQuery2.setSelectionCriteria(expression2);
        if (readAllQuery.isDistinctComputed()) {
            readAllQuery2.setDistinctState(readAllQuery.getDistinctState());
        }
        if ((readQuery = this.getSelectionQuery()).isReadAllQuery()) {
            readAllQuery2.setOrderByExpressions((Vector)((ReadAllQuery)readQuery).getOrderByExpressions().clone());
            object = ((ReadAllQuery)readQuery).getBatchReadAttributeExpressions().elements();
            while (object.hasMoreElements()) {
                Expression expression3 = ((Expression)object.nextElement()).rebuildOn(readAllQuery2.getExpressionBuilder());
                readAllQuery2.addBatchReadAttribute(expression3);
            }
        }
        object = this.extractNestedExpressions(readAllQuery.getBatchReadAttributeExpressions(), readAllQuery2.getExpressionBuilder(), false);
        Helper.addAllToVector(readAllQuery2.getBatchReadAttributeExpressions(), (Vector)object);
        this.postPrepareNestedBatchQuery(readAllQuery2, readAllQuery);
        if (readAllQuery2.shouldPrepare()) {
            readAllQuery2.checkPrepare(readAllQuery.getSession(), readAllQuery.getTranslationRow());
        }
        readAllQuery2.setSession(null);
        return readAllQuery2;
    }

    protected Hashtable getBatchReadObjects(DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        if (abstractSession.isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)abstractSession;
            return (Hashtable)unitOfWorkImpl.getBatchReadObjects().get(databaseQuery);
        }
        return (Hashtable)databaseQuery.getProperty("batched objects");
    }

    protected void setBatchReadObjects(Hashtable hashtable, DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        if (abstractSession.isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)abstractSession;
            unitOfWorkImpl.getBatchReadObjects().put(databaseQuery, hashtable);
        } else {
            databaseQuery.setProperty("batched objects", hashtable);
        }
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        this.getIndirectionPolicy().fixObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object object2 = super.getAttributeValueFromObject(object);
        Object object3 = this.getIndirectionPolicy().validateAttributeOfInstantiatedObject(object2);
        if (object3 != object2) {
            this.setAttributeValueInObject(object, object3);
            object2 = object3;
        }
        return object2;
    }

    public Object getAttributeValueWithClonedValueHolders(Object object) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 instanceof DatabaseValueHolder) {
            return ((DatabaseValueHolder)object2).clone();
        }
        if (object2 instanceof ValueHolder) {
            return ((ValueHolder)object2).clone();
        }
        return object2;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        Expression expression = this.getSelectionCriteria();
        return queryKeyExpression.getBaseExpression().twist(expression, queryKeyExpression);
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession remoteSession, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery) {
        return remoteSession.getObjectCorrespondingTo(object, map, map2, objectLevelReadQuery);
    }

    public Object getRealAttributeValueFromAttribute(Object object, Object object2, AbstractSession abstractSession) {
        return this.indirectionPolicy.getRealAttributeValueFromObject(object2, object);
    }

    public boolean isLazy() {
        if (this.isLazy == null) {
            this.isLazy = this.usesIndirection();
        }
        return this.isLazy;
    }

    public boolean isLockableMapping() {
        return !this.usesIndirection();
    }

    public void instantiateAttribute(Object object, AbstractSession abstractSession) {
        this.getIndirectionPolicy().instantiateObject(object, this.getAttributeValueFromObject(object));
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            if (this.getTempSession() == null) {
                return null;
            }
            this.referenceDescriptor = this.getTempSession().getDescriptor(this.getReferenceClass());
        }
        return this.referenceDescriptor;
    }

    public DatabaseMapping getRelationshipPartner() {
        if (this.relationshipPartner == null && this.relationshipPartnerAttributeName != null) {
            this.setRelationshipPartner(this.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(this.getRelationshipPartnerAttributeName()));
        }
        return this.relationshipPartner;
    }

    public String getRelationshipPartnerAttributeName() {
        return this.relationshipPartnerAttributeName;
    }

    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    protected AbstractSession getTempSession() {
        return this.tempInitSession;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.getIndirectionPolicy().getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public boolean hasCustomSelectionQuery() {
        return this.hasCustomSelectionQuery;
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        Class clazz;
        super.preInitialize(abstractSession);
        if (this.getIndirectionPolicy() instanceof BasicIndirectionPolicy && ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass()) && !ClassConstants.ValueHolderInterface_Class.isAssignableFrom(clazz = this.getAttributeAccessor().getAttributeClass())) {
            boolean bl = this.getAttributeAccessor().isMethodAttributeAccessor();
            String string = null;
            if (bl) {
                string = this.getSetMethodName();
            }
            this.setGetMethodName(ClassWeaver.getWeavedValueHolderGetMethodName(this.getAttributeName()));
            this.setSetMethodName(ClassWeaver.getWeavedValueHolderSetMethodName(this.getAttributeName()));
            if (bl) {
                this.useWeavedIndirection(string);
            }
            super.preInitialize(abstractSession);
        }
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.initializeReferenceDescriptor(abstractSession);
        this.initializeSelectionQuery(abstractSession);
        this.getIndirectionPolicy().initialize();
    }

    protected void initializeReferenceDescriptor(AbstractSession abstractSession) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getReferenceClass());
        if (classDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        if (classDescriptor.isAggregateDescriptor() && !this.isAggregateCollectionMapping()) {
            throw DescriptorException.referenceDescriptorCannotBeAggregate(this);
        }
        if ((this.getDescriptor() == null || !this.getDescriptor().isIsolated()) && classDescriptor.isIsolated()) {
            throw DescriptorException.isolateDescriptorReferencedBySharedDescriptor(classDescriptor.getJavaClassName(), this.getDescriptor().getJavaClassName(), this);
        }
        this.setReferenceDescriptor(classDescriptor);
    }

    protected void initializeSelectionQuery(AbstractSession abstractSession) throws DescriptorException {
        if (((ObjectLevelReadQuery)this.getSelectionQuery()).getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.getSelectionQuery().setName(this.getAttributeName());
        this.getSelectionQuery().setDescriptor(this.getReferenceDescriptor());
        this.getSelectionQuery().setSourceMapping(this);
    }

    public boolean isAttributeValueInstantiated(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    public boolean isForeignReferenceMapping() {
        return true;
    }

    public boolean isJoiningSupported() {
        return false;
    }

    public boolean isPrivateOwned() {
        return this.isPrivateOwned;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        Object object = this.getAttributeValueFromObject(descriptorIterator.getVisitedParent());
        this.getIndirectionPolicy().iterateOnAttributeValue(descriptorIterator, object);
    }

    public abstract void iterateOnRealAttributeValue(DescriptorIterator var1, Object var2);

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        this.getIndirectionPolicy().mergeRemoteValueHolder(object, object2, mergeManager);
    }

    public void privateOwnedRelationship() {
        this.setIsPrivateOwned(true);
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        super.remoteInitialization(distributedSession);
        this.setTempSession(distributedSession);
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersIn(object);
    }

    public boolean requiresTransientWeavedFields() {
        return this.requiresTransientWeavedFields;
    }

    public void setCascadeAll(boolean bl) {
        this.setCascadePersist(bl);
        this.setCascadeMerge(bl);
        this.setCascadeRefresh(bl);
        this.setCascadeRemove(bl);
    }

    public void setCascadePersist(boolean bl) {
        this.cascadePersist = bl;
    }

    public void setCascadeMerge(boolean bl) {
        this.cascadeMerge = bl;
    }

    public void setCascadeRefresh(boolean bl) {
        this.cascadeRefresh = bl;
    }

    public void setCascadeRemove(boolean bl) {
        this.cascadeRemove = bl;
    }

    public void setCustomSelectionQuery(ReadQuery readQuery) {
        this.setSelectionQuery(readQuery);
        this.setHasCustomSelectionQuery(true);
    }

    protected void setHasCustomSelectionQuery(boolean bl) {
        this.hasCustomSelectionQuery = bl;
    }

    public void setForceInitializationOfSelectionCriteria(boolean bl) {
        this.forceInitializationOfSelectionCriteria = bl;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setIsPrivateOwned(boolean bl) {
        this.isPrivateOwned = bl;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        this.getIndirectionPolicy().setRealAttributeValueInObject(object, object2);
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
        if (clazz != null) {
            this.setReferenceClassName(clazz.getName());
            this.setSelectionQuery(this.getSelectionQuery());
        }
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    protected void setReferenceDescriptor(ClassDescriptor classDescriptor) {
        this.referenceDescriptor = classDescriptor;
    }

    public void setRelationshipPartner(DatabaseMapping databaseMapping) {
        this.relationshipPartner = databaseMapping;
    }

    public void setRelationshipPartnerAttributeName(String string) {
        this.relationshipPartnerAttributeName = string;
    }

    public void setRequiresTransientWeavedFields(boolean bl) {
        this.requiresTransientWeavedFields = bl;
    }

    public void setSelectionCriteria(Expression expression) {
        this.getSelectionQuery().setSelectionCriteria(expression);
    }

    protected void setSelectionQuery(ReadQuery readQuery) {
        this.selectionQuery = readQuery;
        if (this.selectionQuery != null && this.selectionQuery.isObjectLevelReadQuery() && this.selectionQuery.getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)this.selectionQuery).setReferenceClass(this.getReferenceClass());
        }
    }

    public void setSelectionSQLString(String string) {
        this.getSelectionQuery().setSQLString(string);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setSelectionCall(Call call) {
        this.getSelectionQuery().setCall(call);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    protected void setTempSession(AbstractSession abstractSession) {
        this.tempInitSession = abstractSession;
    }

    public void setUsesBatchReading(boolean bl) {
        this.usesBatchReading = bl;
    }

    public void setUsesIndirection(boolean bl) {
        if (bl) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    protected boolean shouldForceInitializationOfSelectionCriteria() {
        return this.forceInitializationOfSelectionCriteria;
    }

    protected boolean shouldInitializeSelectionCriteria() {
        if (this.shouldForceInitializationOfSelectionCriteria()) {
            return true;
        }
        if (this.hasCustomSelectionQuery()) {
            return false;
        }
        return this.getSelectionCriteria() == null;
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeByMapping() && this.isCascadeMerge() || mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isReadOnly()) {
            return false;
        }
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            return this.hasConstraintDependency();
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    public boolean shouldUseBatchReading() {
        return this.usesBatchReading;
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useBatchReading() {
        this.setUsesBatchReading(true);
    }

    public void useWeavedIndirection(String string) {
        this.setIndirectionPolicy(new WeavedObjectBasicIndirectionPolicy(string));
    }

    public void useContainerIndirection(Class clazz) {
        ContainerIndirectionPolicy containerIndirectionPolicy = new ContainerIndirectionPolicy();
        containerIndirectionPolicy.setContainerClass(clazz);
        this.setIndirectionPolicy(containerIndirectionPolicy);
    }

    public boolean usesIndirection() {
        return this.getIndirectionPolicy().usesIndirection();
    }

    public void setJoinFetch(int n) {
        this.joinFetch = n;
    }

    public int getJoinFetch() {
        return this.joinFetch;
    }

    public boolean isJoinFetched() {
        return this.getJoinFetch() != 0;
    }

    public boolean isInnerJoinFetched() {
        return this.getJoinFetch() == 1;
    }

    public boolean isOuterJoinFetched() {
        return this.getJoinFetch() == 2;
    }

    public void useInnerJoinFetch() {
        this.setJoinFetch(1);
    }

    public void useOuterJoinFetch() {
        this.setJoinFetch(2);
    }

    public void validateBeforeInitialization(AbstractSession abstractSession) throws DescriptorException {
        super.validateBeforeInitialization(abstractSession);
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class clazz = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeType(clazz, abstractSession.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class clazz = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnType(clazz, abstractSession.getIntegrityChecker());
            Class clazz2 = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterType(clazz2, abstractSession.getIntegrityChecker());
        }
    }

    public abstract Object valueFromPKList(Object[] var1, AbstractSession var2);

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        if (objectBuildingQuery.isReadAllQuery() && (((ReadAllQuery)objectBuildingQuery).isAttributeBatchRead(this.descriptor, this.getAttributeName()) || this.usesBatchReading)) {
            return this.batchedValueFromRow(abstractRecord, (ReadAllQuery)objectBuildingQuery);
        }
        if (this.shouldUseValueFromRowWithJoin(joinedAttributeManager, objectBuildingQuery)) {
            return this.valueFromRowInternalWithJoin(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
        }
        return this.valueFromRowInternal(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
    }

    protected boolean shouldUseValueFromRowWithJoin(JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery) {
        return joinedAttributeManager != null && joinedAttributeManager.isAttributeJoined(this.descriptor, this.getAttributeName()) || objectBuildingQuery.hasPartialAttributeExpressions();
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        throw ValidationException.mappingDoesNotOverrideValueFromRowInternalWithJoin(Helper.getShortClassName(this.getClass()));
    }

    protected Object valueFromRowInternal(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        ReadQuery readQuery = this.selectionQuery;
        if (!this.indirectionPolicy.usesIndirection()) {
            if (readQuery.shouldPrepare()) {
                readQuery.checkPrepare(abstractSession, abstractRecord);
            }
            readQuery = (ReadQuery)readQuery.clone();
            readQuery.setIsExecutionClone(true);
            readQuery.setQueryId(objectBuildingQuery.getQueryId());
        }
        if (readQuery.isObjectLevelReadQuery() && (objectBuildingQuery.shouldCascadeAllParts() || this.isPrivateOwned && objectBuildingQuery.shouldCascadePrivateParts() || this.cascadeRefresh && objectBuildingQuery.shouldCascadeByMapping())) {
            if (readQuery == this.selectionQuery) {
                if (readQuery.shouldPrepare()) {
                    readQuery.checkPrepare(abstractSession, abstractRecord);
                }
                readQuery = (ObjectLevelReadQuery)readQuery.clone();
                readQuery.setIsExecutionClone(true);
            }
            ((ObjectLevelReadQuery)readQuery).setShouldRefreshIdentityMapResult(objectBuildingQuery.shouldRefreshIdentityMapResult());
            readQuery.setCascadePolicy(objectBuildingQuery.getCascadePolicy());
            if (readQuery.shouldMaintainCache()) {
                readQuery.setShouldMaintainCache(objectBuildingQuery.shouldMaintainCache());
            }
            if (((ObjectLevelReadQuery)objectBuildingQuery).hasAsOfClause()) {
                readQuery.setSelectionCriteria((Expression)readQuery.getSelectionCriteria().clone());
                ((ObjectLevelReadQuery)readQuery).setAsOfClause(((ObjectLevelReadQuery)objectBuildingQuery).getAsOfClause());
            }
        }
        readQuery = this.prepareHistoricalQuery(readQuery, objectBuildingQuery, abstractSession);
        return this.indirectionPolicy.valueFromQuery(readQuery, abstractRecord, objectBuildingQuery.getSession());
    }

    protected ReadQuery prepareHistoricalQuery(ReadQuery readQuery, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return readQuery;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, AbstractSession abstractSession) {
        Object object;
        if (joinedAttributeManager != null && joinedAttributeManager.getJoinedMappingIndexes_() != null && (object = joinedAttributeManager.getJoinedMappingIndexes_().get(this)) != null) {
            return this.trimRowForJoin(abstractRecord, object, abstractSession);
        }
        return abstractRecord;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        Serializable serializable;
        Object object2;
        int n;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else {
            object2 = (Map)object;
            serializable = this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().classFromRow(abstractRecord, abstractSession) : this.getDescriptor().getJavaClass();
            n = (Integer)object2.get(serializable);
        }
        object2 = new NonSynchronizedSubVector(abstractRecord.getFields(), n, abstractRecord.size());
        serializable = new NonSynchronizedSubVector(abstractRecord.getValues(), n, abstractRecord.size());
        return new DatabaseRecord((Vector)object2, (Vector)serializable);
    }

    protected ObjectLevelReadQuery prepareNestedJoinQueryClone(AbstractRecord abstractRecord, List arrayList, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        ObjectLevelReadQuery objectLevelReadQuery = null;
        if (joinedAttributeManager == null) {
            objectLevelReadQuery = this.prepareNestedJoins(joinedAttributeManager, objectBuildingQuery, abstractSession);
            objectLevelReadQuery.setSession(abstractSession);
            return objectLevelReadQuery;
        }
        if (joinedAttributeManager.getJoinedMappingQueryClones() == null) {
            joinedAttributeManager.setJoinedMappingQueryClones(new HashMap(5));
        }
        if ((objectLevelReadQuery = joinedAttributeManager.getJoinedMappingQueryClones().get(this)) == null) {
            if (joinedAttributeManager.getJoinedMappingQueries_() != null) {
                objectLevelReadQuery = joinedAttributeManager.getJoinedMappingQueries_().get(this);
                objectLevelReadQuery = (ObjectLevelReadQuery)objectLevelReadQuery.clone();
            } else {
                objectLevelReadQuery = this.prepareNestedJoins(joinedAttributeManager, objectBuildingQuery, abstractSession);
            }
            objectLevelReadQuery.setSession(abstractSession);
            objectLevelReadQuery.setQueryId(joinedAttributeManager.getBaseQuery().getQueryId());
            objectLevelReadQuery.setExecutionTime(joinedAttributeManager.getBaseQuery().getExecutionTime());
            joinedAttributeManager.getJoinedMappingQueryClones().put(this, objectLevelReadQuery);
        }
        if (objectLevelReadQuery.hasJoining() && objectLevelReadQuery.getJoinedAttributeManager().isToManyJoin()) {
            Object object;
            List<AbstractRecord> list = arrayList;
            if (list == null) {
                object = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord, abstractSession);
                CacheKey cacheKey = new CacheKey((Vector)object);
                list = joinedAttributeManager.getDataResultsByPrimaryKey().get(cacheKey);
            }
            list = new ArrayList(list);
            object = joinedAttributeManager.getJoinedMappingIndexes_().get(this);
            for (int i = 0; i < list.size(); ++i) {
                AbstractRecord abstractRecord2 = (AbstractRecord)list.get(i);
                list.set(i, this.trimRowForJoin(abstractRecord2, object, abstractSession));
            }
            objectLevelReadQuery.getJoinedAttributeManager().setDataResults(list, abstractSession);
        }
        return objectLevelReadQuery;
    }
}

