/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceListener;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLObjectReferenceMapping
extends AggregateMapping
implements XMLMapping {
    protected HashMap sourceToTargetKeyFieldAssociations = new HashMap();
    protected Vector sourceToTargetKeys = new Vector();

    public void addSourceToTargetKeyFieldAssociation(String string, String string2) {
        XMLField xMLField = new XMLField(string);
        this.sourceToTargetKeys.add(xMLField);
        this.sourceToTargetKeyFieldAssociations.put(xMLField, new XMLField(string2));
    }

    public Object buildFieldValue(Object object, XMLField xMLField, AbstractSession abstractSession) {
        if (object == null || this.getReferenceClass() == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object, abstractSession);
        int n = classDescriptor.getPrimaryKeyFields().indexOf(this.getSourceToTargetKeyFieldAssociations().get(xMLField));
        if (n == -1) {
            return null;
        }
        return vector.get(n);
    }

    public void buildReference(UnmarshalRecord unmarshalRecord, XMLField xMLField, Object object, AbstractSession abstractSession) {
        Cloneable cloneable;
        ReferenceResolver referenceResolver = ReferenceResolver.getInstance(abstractSession);
        if (referenceResolver == null) {
            return;
        }
        Object object2 = unmarshalRecord.getCurrentObject();
        ClassDescriptor classDescriptor = abstractSession.getClassDescriptor(this.getReferenceClass());
        Vector<String> vector = classDescriptor.getPrimaryKeyFieldNames();
        Reference reference = referenceResolver.getReference(this, object2);
        if (reference == null) {
            cloneable = new Vector();
            ((Vector)cloneable).setSize(vector.size());
            reference = new Reference((XMLMapping)this, object2, this.getReferenceClass(), (Vector)cloneable);
            referenceResolver.addReference(reference);
            unmarshalRecord.reference(reference);
        }
        cloneable = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xMLField);
        int n = vector.indexOf(((XMLField)cloneable).getXPath());
        Vector vector2 = reference.getPrimaryKeys();
        Object object3 = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, classDescriptor.getTypedField((DatabaseField)cloneable).getType());
        if (object3 != null) {
            vector2.setElementAt(object3, n);
        }
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object2, unitOfWorkImpl, map);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object2, unitOfWorkImpl, map);
        }
    }

    public Vector getFields() {
        return this.sourceToTargetKeys;
    }

    protected QName getSchemaType(XMLField xMLField, Object object, AbstractSession abstractSession) {
        QName qName = null;
        if (xMLField.isTypedTextField()) {
            qName = xMLField.getXMLType(object.getClass());
        } else {
            if (xMLField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xMLField, object, abstractSession);
            }
            if (xMLField.getSchemaType() != null) {
                qName = xMLField.getSchemaType();
            }
        }
        return qName;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xMLUnionField, Object object, AbstractSession abstractSession) {
        ArrayList arrayList = xMLUnionField.getSchemaTypes();
        QName qName = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            QName qName2 = (QName)xMLUnionField.getSchemaTypes().get(i);
            try {
                if (qName2 == null) continue;
                Class clazz = xMLUnionField.getJavaClass(qName2);
                object = ((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, clazz, qName2);
                qName = qName2;
                break;
            }
            catch (ConversionException conversionException) {
                if (i != arrayList.size() - 1) continue;
                qName = qName2;
            }
        }
        return qName;
    }

    public HashMap getSourceToTargetKeyFieldAssociations() {
        return this.sourceToTargetKeyFieldAssociations;
    }

    protected String getValueToWrite(QName qName, Object object, AbstractSession abstractSession) {
        return (String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, ClassConstants.STRING, qName);
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            this.setReferenceClass(abstractSession.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        super.initialize(abstractSession);
        ReferenceListener referenceListener = new ReferenceListener();
        if (!abstractSession.getEventManager().getListeners().contains(referenceListener)) {
            abstractSession.getEventManager().addListener(referenceListener);
        }
        XMLDescriptor xMLDescriptor = (XMLDescriptor)this.getDescriptor();
        XMLDescriptor xMLDescriptor2 = (XMLDescriptor)this.getReferenceDescriptor();
        for (int i = 0; i < this.sourceToTargetKeys.size(); ++i) {
            XMLField xMLField = (XMLField)this.sourceToTargetKeys.get(i);
            xMLField = (XMLField)xMLDescriptor.buildField(xMLField);
            this.sourceToTargetKeys.set(i, xMLField);
            XMLField xMLField2 = (XMLField)this.sourceToTargetKeyFieldAssociations.get(xMLField);
            xMLField2 = (XMLField)xMLDescriptor2.buildField(xMLField2);
            this.sourceToTargetKeyFieldAssociations.put(xMLField, xMLField2);
        }
    }

    public boolean isXMLMapping() {
        return true;
    }

    public Object readFromRowIntoObject(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Object object22;
        ClassDescriptor classDescriptor = objectBuildingQuery.getSession().getClassDescriptor(this.getReferenceClass());
        Vector<String> vector = classDescriptor.getPrimaryKeyFieldNames();
        Vector<Object> vector2 = new Vector<Object>();
        vector2.setSize(vector.size());
        for (Object object22 : this.sourceToTargetKeys) {
            Object object3;
            XMLField xMLField = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(object22);
            int n = vector.indexOf(xMLField.getXPath());
            if (n == -1 || (object3 = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(abstractRecord.get((DatabaseField)object22), classDescriptor.getTypedField(xMLField).getType())) == null) continue;
            vector2.setElementAt(object3, n);
        }
        object22 = ReferenceResolver.getInstance(objectBuildingQuery.getSession());
        if (object22 != null) {
            ((ReferenceResolver)object22).addReference(new Reference((XMLMapping)this, object, this.referenceClass, vector2));
        }
        return null;
    }

    public void setField(DatabaseField databaseField) {
    }

    public void setSourceToTargetKeyFieldAssociations(HashMap hashMap) {
        this.sourceToTargetKeyFieldAssociations = hashMap;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Object object2 = this.getAttributeValueFromObject(object);
        this.writeSingleValue(object2, object, (XMLRecord)abstractRecord, abstractSession);
    }

    public void writeSingleValue(Object object, Object object2, XMLRecord xMLRecord, AbstractSession abstractSession) {
        for (XMLField xMLField : this.getFields()) {
            Object object3 = this.buildFieldValue(object, xMLField, abstractSession);
            if (object3 == null) continue;
            QName qName = this.getSchemaType(xMLField, object3, abstractSession);
            String string = this.getValueToWrite(qName, object3, abstractSession);
            xMLRecord.put(xMLField, (Object)string);
        }
    }
}

