/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerRecord
extends MarshalRecord {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private String namespaceURI;
    private XPathFragment xPathFragment;
    private AttributesImpl attributes;
    private static final String CDATA = "CDATA";
    protected boolean isStartElementOpen = false;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void startDocument(String string, String string2) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void endDocument() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void startPrefixMapping(String string, String string2) {
        try {
            this.contentHandler.startPrefixMapping(string, string2);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void endPrefixMapping(String string) {
        try {
            this.contentHandler.endPrefixMapping(string);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    private void openAndCloseStartElement() {
        try {
            this.contentHandler.startElement(this.namespaceURI, this.xPathFragment.getLocalName(), this.xPathFragment.getShortName(), this.attributes);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.xPathFragment = xPathFragment;
        this.attributes = new AttributesImpl();
    }

    public void element(String string, String string2, String string3) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.attributes = new AttributesImpl();
            this.contentHandler.startElement(string, string2, string3, this.attributes);
            this.contentHandler.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String string) {
        String string2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.attributes.addAttribute(string2, xPathFragment.getLocalName(), xPathFragment.getShortName(), CDATA, string);
    }

    public void attribute(String string, String string2, String string3, String string4) {
        this.attributes.addAttribute(string, string2, string3, CDATA, string4);
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            String string = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
            this.contentHandler.endElement(string, xPathFragment.getLocalName(), xPathFragment.getShortName());
            this.isStartElementOpen = false;
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void characters(String string) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.contentHandler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void cdata(String string) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
            this.characters(string);
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endCDATA();
            }
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String string = null;
            if (namespaceResolver != null) {
                string = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (string != null) {
                this.attribute(attr.getNamespaceURI(), "", string + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            if (node.getNodeType() == 3) {
                this.characters(node.getNodeValue());
            } else {
                XMLFragmentReader xMLFragmentReader = new XMLFragmentReader(namespaceResolver);
                xMLFragmentReader.setContentHandler(this.contentHandler);
                try {
                    xMLFragmentReader.parse(node);
                }
                catch (SAXException sAXException) {
                    throw XMLMarshalException.marshalException(sAXException);
                }
            }
        }
    }

    public String resolveNamespacePrefix(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        String string = super.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String resolveNamespacePrefix(String string) {
        String string2 = super.resolveNamespacePrefix(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }
}

