/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;

public class AccessPlatform
extends DatabasePlatform {
    protected Hashtable buildClassTypes() {
        Hashtable hashtable = super.buildClassTypes();
        hashtable.put("LONG", Long.class);
        hashtable.put("TEXT", String.class);
        return hashtable;
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("BIT", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("LONG", false));
        hashtable.put(Long.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Float.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Double.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SHORT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("BYTE", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Number.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(String.class, new FieldTypeDefinition("TEXT", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("TEXT", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("LONGBINARY", false));
        hashtable.put(Character[].class, new FieldTypeDefinition("MEMO", false));
        hashtable.put(byte[].class, new FieldTypeDefinition("LONGBINARY", false));
        hashtable.put(char[].class, new FieldTypeDefinition("MEMO", false));
        hashtable.put(Blob.class, new FieldTypeDefinition("LONGBINARY", false));
        hashtable.put(Clob.class, new FieldTypeDefinition("MEMO", false));
        hashtable.put(Date.class, new FieldTypeDefinition("DATETIME", false));
        hashtable.put(Time.class, new FieldTypeDefinition("DATETIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("DATETIME", false));
        return hashtable;
    }

    public int getMaxFieldNameSize() {
        return 64;
    }

    public Timestamp getTimestampFromServer(AbstractSession abstractSession, String string) {
        if (this.getTimestampQuery() == null) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            timestamp.setNanos(0);
            return timestamp;
        }
        this.getTimestampQuery().setSessionName(string);
        return (Timestamp)abstractSession.executeQuery(this.getTimestampQuery());
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(28, "UCASE"));
        this.addOperator(ExpressionOperator.simpleFunction(29, "LCASE"));
    }

    public boolean isAccess() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, new Long(Long.MAX_VALUE));
        hashtable.put(Double.class, new Double(Double.MAX_VALUE));
        hashtable.put(Short.class, new Short(Short.MAX_VALUE));
        hashtable.put(Byte.class, new Byte(127));
        hashtable.put(Float.class, new Float(1.2345679E8f));
        hashtable.put(BigInteger.class, new BigInteger("999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("99999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, new Long(Long.MIN_VALUE));
        hashtable.put(Double.class, new Double(Double.MIN_VALUE));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float(-1.2345679E8f));
        hashtable.put(BigInteger.class, new BigInteger("-999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public void printFieldNotNullClause(Writer writer) {
    }

    public boolean requiresNamedPrimaryKeyConstraints() {
        return true;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }
}

