/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class MySQLPlatform
extends DatabasePlatform {
    private static final String LIMIT = " LIMIT ";

    public MySQLPlatform() {
        this.pingSQL = "SELECT 1";
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("TINYINT(1) default 0", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Double.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 38));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL", 38));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(Character[].class, new FieldTypeDefinition("TEXT", 64000));
        hashtable.put(byte[].class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(char[].class, new FieldTypeDefinition("TEXT", 64000));
        hashtable.put(Blob.class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(Clob.class, new FieldTypeDefinition("TEXT", 64000));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("TIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("DATETIME", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT LAST_INSERT_ID()");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public String buildProcedureCallString(StoredProcedureCall storedProcedureCall, AbstractSession abstractSession) {
        return "{ " + super.buildProcedureCallString(storedProcedureCall, abstractSession);
    }

    public int computeMaxRowsForSQL(int n, int n2) {
        return n2 - (n >= 0 ? n : 0);
    }

    public String getConstraintDeletionString() {
        return " DROP FOREIGN KEY ";
    }

    public String getFunctionCallHeader() {
        return "? " + this.getAssignmentString() + this.getProcedureCallHeader();
    }

    public String getProcedureCallTail() {
        return " }";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT NOW()");
        }
        return this.timestampQuery;
    }

    public boolean isMySQL() {
        return true;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.toNumberOperator());
        this.addOperator(this.toCharOperator());
        this.addOperator(this.toDateOperator());
        this.addOperator(this.dateToStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "IFNULL"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(75, "TRUNCATE"));
        this.addOperator(this.leftTrim2());
        this.addOperator(this.rightTrim2());
    }

    protected ExpressionOperator logOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(66);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("LOG(10, ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(FunctionExpression.class);
        return expressionOperator;
    }

    protected ExpressionOperator toNumberOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(42);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", SIGNED)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator toDateOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(53);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", DATETIME)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator toCharOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(114);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", CHAR)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator dateToStringOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(48);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", CHAR)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator leftTrim2() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(122);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(5);
        ((Vector)nonSynchronizedVector).addElement("TRIM(LEADING ");
        ((Vector)nonSynchronizedVector).addElement(" FROM ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        int[] nArray = new int[]{1, 0};
        expressionOperator.setArgumentIndices(nArray);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator rightTrim2() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(116);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(5);
        ((Vector)nonSynchronizedVector).addElement("TRIM(TRAILING ");
        ((Vector)nonSynchronizedVector).addElement(" FROM ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        int[] nArray = new int[]{1, 0};
        expressionOperator.setArgumentIndices(nArray);
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator currentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT_DATE");
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" AUTO_INCREMENT");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsGlobalTempTables() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return true;
    }

    protected String getCreateTempTableSqlPrefix() {
        return "CREATE TEMPORARY TABLE IF NOT EXISTS ";
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable databaseTable) {
        return " LIKE " + databaseTable.getQualifiedName();
    }

    public boolean shouldAlwaysUseTempStorageForModifyAll() {
        return true;
    }

    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return false;
    }

    public String getIdentifierQuoteCharacter() {
        return "`";
    }

    public String getInOutputProcedureToken() {
        return "INOUT";
    }

    public String getProcedureAsString() {
        return "";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    public String getProcedureCallHeader() {
        return "CALL ";
    }

    public String getProcedureBeginString() {
        return "BEGIN ";
    }

    public String getProcedureEndString() {
        return "END";
    }

    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable databaseTable, Collection collection, Collection collection2) throws IOException {
        writer.write("UPDATE ");
        String string = databaseTable.getQualifiedName();
        writer.write(string);
        writer.write(", ");
        String string2 = this.getTempTableForTable(databaseTable).getQualifiedName();
        writer.write(string2);
        MySQLPlatform.writeAutoAssignmentSetClause(writer, string, string2, collection2);
        MySQLPlatform.writeAutoJoinWhereClause(writer, string, string2, collection);
    }

    public void writeDeleteFromTargetTableUsingTempTableSql(Writer writer, DatabaseTable databaseTable, DatabaseTable databaseTable2, Collection collection, Collection collection2) throws IOException {
        writer.write("DELETE FROM ");
        String string = databaseTable2.getQualifiedName();
        writer.write(string);
        writer.write(" USING ");
        writer.write(string);
        writer.write(", ");
        String string2 = this.getTempTableForTable(databaseTable).getQualifiedName();
        writer.write(string2);
        MySQLPlatform.writeJoinWhereClause(writer, string, string2, collection2, collection);
    }

    public void printSQLSelectStatement(DatabaseCall databaseCall, ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        int n = 0;
        int n2 = 0;
        if (sQLSelectStatement.getQuery() != null) {
            n = sQLSelectStatement.getQuery().getMaxRows();
            n2 = sQLSelectStatement.getQuery().getFirstResult();
        }
        if (n <= 0 || !this.shouldUseRownumFiltering()) {
            super.printSQLSelectStatement(databaseCall, expressionSQLPrinter, sQLSelectStatement);
            return;
        }
        sQLSelectStatement.setUseUniqueFieldAliases(true);
        databaseCall.setFields(sQLSelectStatement.printSQL(expressionSQLPrinter));
        expressionSQLPrinter.printString(LIMIT);
        expressionSQLPrinter.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        expressionSQLPrinter.printString(", ");
        expressionSQLPrinter.printParameter(DatabaseCall.MAXROW_FIELD);
        databaseCall.setIgnoreFirstRowMaxResultsSettings(true);
    }
}

