/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SQLServerPlatform
extends DatabasePlatform {
    public SQLServerPlatform() {
        this.pingSQL = "SELECT 1";
    }

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL() && !this.usesByteArrayBinding()) {
            writer.write("0x");
            Helper.writeHexString(byArray, writer);
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendSybaseTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(58);
        String string = Integer.toString(timestamp.getNanos());
        int n = 0;
        for (int i = Math.min(9 - string.length(), 3); i > 0; --i) {
            writer.write(48);
            ++n;
        }
        if (string.length() + n > 3) {
            string = string.substring(0, 3 - n);
        }
        writer.write(string);
        writer.write("'");
    }

    protected void appendSybaseCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("BIT default 0", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT(16)", false));
        hashtable.put(Double.class, new FieldTypeDefinition("FLOAT(32)", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 28));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        hashtable.put(Number.class, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("IMAGE", false));
        hashtable.put(Character[].class, new FieldTypeDefinition("TEXT", false));
        hashtable.put(byte[].class, new FieldTypeDefinition("IMAGE", false));
        hashtable.put(char[].class, new FieldTypeDefinition("TEXT", false));
        hashtable.put(Blob.class, new FieldTypeDefinition("IMAGE", false));
        hashtable.put(Clob.class, new FieldTypeDefinition("TEXT", false));
        hashtable.put(Date.class, new FieldTypeDefinition("DATETIME", false));
        hashtable.put(Time.class, new FieldTypeDefinition("DATETIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("DATETIME", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT @@IDENTITY");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public String getBatchDelimiterString() {
        return "";
    }

    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    public String getCreationOutputProcedureToken() {
        return "OUTPUT";
    }

    public String getInOutputProcedureToken() {
        return "OUT";
    }

    public int getMaxFieldNameSize() {
        return 22;
    }

    public Vector getNativeTableInfo(String string, String string2, AbstractSession abstractSession) {
        String string3 = "SELECT * FROM sysobjects WHERE table_type <> 'SYSTEM_TABLE'";
        if (string != null) {
            string3 = string.indexOf(37) != -1 ? string3 + " AND table_name LIKE " + string : string3 + " AND table_name = " + string;
        }
        if (string2 != null) {
            string3 = string2.indexOf(37) != -1 ? string3 + " AND table_owner LIKE " + string2 : string3 + " AND table_owner = " + string2;
        }
        return abstractSession.executeSelectingCall(new SQLCall(string3));
    }

    public String getOutputProcedureToken() {
        return "";
    }

    public String getProcedureArgumentString() {
        return "@";
    }

    public String getProcedureCallHeader() {
        return "EXECUTE ";
    }

    public String getStoredProcedureParameterPrefix() {
        return "@";
    }

    public String getStoredProcedureTerminationToken() {
        return " go";
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT GETDATE()");
        }
        return this.timestampQuery;
    }

    public String getSelectForUpdateString() {
        return " WITH (UPDLOCK)";
    }

    public String getSelectForUpdateNoWaitString() {
        return " WITH (UPDLOCK, NOWAIT)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeStoredProcedure(DatabaseCall databaseCall, PreparedStatement preparedStatement, DatabaseAccessor databaseAccessor, AbstractSession abstractSession) throws SQLException {
        Object object = null;
        ResultSet resultSet = null;
        if (!databaseCall.getReturnsResultSet()) {
            databaseAccessor.executeDirectNoSelect(preparedStatement, databaseCall, abstractSession);
            object = databaseAccessor.buildOutputRow((CallableStatement)preparedStatement, databaseCall, abstractSession);
            if (databaseCall.areManyRowsReturned()) {
                Vector<AbstractRecord> vector = new Vector<AbstractRecord>();
                vector.add((AbstractRecord)object);
                object = vector;
            }
        } else {
            abstractSession.startOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
            try {
                resultSet = preparedStatement.executeQuery();
                Object var9_9 = null;
                abstractSession.endOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                abstractSession.endOperationProfile("sql execute", databaseCall.getQuery(), Integer.MAX_VALUE);
                throw throwable;
            }
            databaseCall.matchFieldOrder(resultSet, databaseAccessor, abstractSession);
            if (databaseCall.isCursorReturned()) {
                databaseCall.setStatement(preparedStatement);
                databaseCall.setResult(resultSet);
                return databaseCall;
            }
            object = this.processResultSet(resultSet, databaseCall, preparedStatement, databaseAccessor, abstractSession);
            if (databaseCall.shouldBuildOutputRow()) {
                AbstractRecord abstractRecord = databaseAccessor.buildOutputRow((CallableStatement)preparedStatement, databaseCall, abstractSession);
                databaseCall.getQuery().setProperty("output", abstractRecord);
                abstractSession.getEventManager().outputParametersDetected(abstractRecord, databaseCall);
            }
            return object;
        }
        return object;
    }

    public boolean shouldPrintLockingClauseAfterWhereClause() {
        return false;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(ExpressionOperator.simpleFunction(54, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(123, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(128, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "CHAR_LENGTH"));
        this.addOperator(ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTRING"));
        this.addOperator(ExpressionOperator.addDate());
        this.addOperator(ExpressionOperator.dateName());
        this.addOperator(ExpressionOperator.datePart());
        this.addOperator(ExpressionOperator.dateDifference());
        this.addOperator(ExpressionOperator.difference());
        this.addOperator(ExpressionOperator.charIndex());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.reverse());
        this.addOperator(ExpressionOperator.replicate());
        this.addOperator(ExpressionOperator.right());
        this.addOperator(ExpressionOperator.cot());
        this.addOperator(ExpressionOperator.sybaseAtan2Operator());
        this.addOperator(ExpressionOperator.sybaseAddMonthsOperator());
        this.addOperator(ExpressionOperator.sybaseInStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "ISNULL"));
        this.addOperator(ExpressionOperator.sybaseToNumberOperator());
        this.addOperator(ExpressionOperator.sybaseToDateToStringOperator());
        this.addOperator(ExpressionOperator.sybaseToDateOperator());
        this.addOperator(ExpressionOperator.sybaseToCharOperator());
        this.addOperator(ExpressionOperator.sybaseLocateOperator());
        this.addOperator(SQLServerPlatform.locate2Operator());
        this.addOperator(ExpressionOperator.simpleFunction(55, "CEILING"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "LEN"));
        this.addOperator(this.modOperator());
        this.addOperator(ExpressionOperator.simpleAggregate(24, "STDEV", "standardDeviation"));
    }

    public boolean isSQLServer() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, new Long(Long.MAX_VALUE));
        hashtable.put(Double.class, new Double(0.0));
        hashtable.put(Short.class, new Short(Short.MAX_VALUE));
        hashtable.put(Byte.class, new Byte(127));
        hashtable.put(Float.class, new Float(0.0f));
        hashtable.put(BigInteger.class, new BigInteger("9999999999999999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, new Long(Long.MIN_VALUE));
        hashtable.put(Double.class, new Double(-9.0));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float(-9.0f));
        hashtable.put(BigInteger.class, new BigInteger("-9999999999999999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("-999999999.9999999999999999999"));
        return hashtable;
    }

    public ExpressionOperator modOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(67);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(" % ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(FunctionExpression.class);
        return expressionOperator;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(6);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addElement(" =* ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(RelationExpression.class);
        return expressionOperator;
    }

    public static ExpressionOperator locate2Operator() {
        ExpressionOperator expressionOperator = ExpressionOperator.simpleThreeArgumentFunction(113, "CHARINDEX");
        int[] nArray = new int[]{1, 0, 2};
        expressionOperator.setArgumentIndices(nArray);
        return expressionOperator;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" IDENTITY");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    public boolean requiresProcedureCallOuputToken() {
        return true;
    }

    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return false;
    }

    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsLocalTempTables() {
        return true;
    }

    protected String getCreateTempTableSqlPrefix() {
        return "CREATE TABLE ";
    }

    public DatabaseTable getTempTableForTable(DatabaseTable databaseTable) {
        return new DatabaseTable("#" + databaseTable.getName(), databaseTable.getTableQualifier());
    }

    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable databaseTable, Collection collection, Collection collection2) throws IOException {
        writer.write("UPDATE ");
        String string = databaseTable.getQualifiedName();
        writer.write(string);
        String string2 = this.getTempTableForTable(databaseTable).getQualifiedName();
        SQLServerPlatform.writeAutoAssignmentSetClause(writer, null, string2, collection2);
        writer.write(" FROM ");
        writer.write(string);
        writer.write(", ");
        writer.write(string2);
        SQLServerPlatform.writeAutoJoinWhereClause(writer, string, string2, collection);
    }
}

