/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSQLStoredProcedureCall
extends StoredProcedureCall {
    static final String BEGIN_DECLARE_BLOCK = Helper.NL + "DECLARE" + Helper.NL;
    static final String BEGIN_BEGIN_BLOCK = "BEGIN" + Helper.NL;
    static final String END_BEGIN_BLOCK = "END;";
    static final String PL2SQL_PREFIX = "EL_PL2SQL_";
    static final String SQL2PL_PREFIX = "EL_SQL2PL_";
    static final String BEGIN_DECLARE_FUNCTION = "FUNCTION ";
    static final String RTURN = "RETURN ";
    protected List<PLSQLargument> arguments = new ArrayList<PLSQLargument>();
    protected int originalIndex = 0;
    protected AbstractRecord translationRow;
    protected Map<String, TypeInfo> typesInfo;
    protected int functionId = 0;

    public void addNamedArgument(String string, DatabaseType databaseType) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, IN, databaseType2));
    }

    public void addNamedArgument(String string, DatabaseType databaseType, int n) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, IN, databaseType2, n));
    }

    public void addNamedArgument(String string, DatabaseType databaseType, int n, int n2) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, IN, databaseType2, n, n2));
    }

    @Override
    public void addNamedArgument(String string, String string2, int n) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, IN, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedArgument(String string, String string2, int n, String string3) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, IN, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    public void addNamedInOutputArgument(String string, DatabaseType databaseType) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, databaseType2));
    }

    public void addNamedInOutputArgument(String string, DatabaseType databaseType, int n) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, databaseType2, n));
    }

    public void addNamedInOutputArgument(String string, DatabaseType databaseType, int n, int n2) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, databaseType2, n, n2));
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2, String string3, int n) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2, String string3, int n, String string4) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2, String string3, int n, String string4, Class clazz) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2, String string3, int n, String string4, Class clazz, DatabaseField databaseField) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    public void addNamedOutputArgument(String string, DatabaseType databaseType) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, databaseType2));
    }

    public void addNamedOutputArgument(String string, DatabaseType databaseType, int n) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, databaseType2, n));
    }

    public void addNamedOutputArgument(String string, DatabaseType databaseType, int n, int n2) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, databaseType2, n, n2));
    }

    @Override
    public void addNamedOutputArgument(String string, String string2, int n, String string3, Class clazz) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedOutputArgument(String string, String string2, int n, String string3, Class clazz, DatabaseField databaseField) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedOutputArgument(String string, String string2, int n, String string3) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedOutputArgument(String string, String string2, int n) {
        this.arguments.add(new PLSQLargument(string, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(n)));
    }

    @Override
    public void addNamedArgument(String string) {
        throw QueryException.addArgumentsNotSupported("named arguments without DatabaseType classification");
    }

    @Override
    public void addNamedArgumentValue(String string, Object object) {
        throw QueryException.addArgumentsNotSupported("named argument values without DatabaseType classification");
    }

    @Override
    public void addNamedArgument(String string, String string2) {
        throw QueryException.addArgumentsNotSupported("named argument values without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String string) {
        throw QueryException.addArgumentsNotSupported("named IN OUT argument without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2, Class clazz) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String string, String string2, String string3, Class clazz) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgumentValue(String string, Object object, String string2, Class clazz) {
        throw QueryException.addArgumentsNotSupported("named IN OUT argument values without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String string) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String string, String string2) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String string, String string2, Class clazz) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void useNamedCursorOutputAsResultSet(String string) {
        throw QueryException.addArgumentsNotSupported("named OUT cursor arguments without DatabaseType classification");
    }

    @Override
    public void addUnamedArgument(String string, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String string, int n, String string2, DatabaseField databaseField) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String string, int n, String string2) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String string, int n) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String string) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgumentValue(Object object) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string, String string2, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string, String string2, int n, String string3, Class clazz, DatabaseField databaseField) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string, String string2, int n, String string3, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string, String string2, int n, String string3) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string, String string2, int n) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String string) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgumentValue(Object object, String string, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String string, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String string, int n, String string2, Class clazz, DatabaseField databaseField) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String string, int n, String string2, Class clazz) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String string, int n, String string2) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String string, int n) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String string) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void useUnnamedCursorOutputAsResultSet() {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    public void useNamedCursorOutputAsResultSet(String string, DatabaseType databaseType) {
        DatabaseType databaseType2 = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        PLSQLargument pLSQLargument = new PLSQLargument(string, this.originalIndex++, OUT, databaseType2);
        pLSQLargument.cursorOutput = true;
        this.arguments.add(pLSQLargument);
    }

    protected void assignIndices() {
        Object object;
        DatabaseType databaseType;
        DatabaseType databaseType2;
        Object object2;
        List<PLSQLargument> list = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        List<PLSQLargument> list2 = PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT);
        list.addAll(list2);
        int n = 1;
        ArrayList<PLSQLargument> arrayList = new ArrayList<PLSQLargument>();
        Object object3 = list.listIterator();
        while (object3.hasNext()) {
            PLSQLargument iterator2 = object3.next();
            if (!iterator2.databaseType.isComplexDatabaseType() || ((ComplexDatabaseType)iterator2.databaseType).hasCompatibleType()) continue;
            arrayList.add(iterator2);
            object3.remove();
        }
        list.addAll(arrayList);
        object3 = list.listIterator();
        while (object3.hasNext()) {
            PLSQLargument pLSQLargument = object3.next();
            n = pLSQLargument.databaseType.computeInIndex(pLSQLargument, n, (ListIterator<PLSQLargument>)object3);
        }
        for (PLSQLargument pLSQLargument : list) {
            object2 = pLSQLargument.databaseType;
            if (!object2.isComplexDatabaseType()) {
                super.addNamedArgument(pLSQLargument.name, pLSQLargument.name, object2.getConversionCode());
                continue;
            }
            databaseType2 = (ComplexDatabaseType)object2;
            if (pLSQLargument.inIndex == Integer.MIN_VALUE) continue;
            if (object2 instanceof PLSQLCollection) {
                databaseType = ((PLSQLCollection)object2).getNestedType();
                if (databaseType != null) {
                    object = new ObjectRelationalDatabaseField(pLSQLargument.name);
                    ((DatabaseField)object).setSqlType(databaseType.getConversionCode());
                    if (databaseType.isComplexDatabaseType()) {
                        ((ObjectRelationalDatabaseField)object).setSqlTypeName(((ComplexDatabaseType)databaseType).getCompatibleType());
                    }
                    super.addNamedArgument(pLSQLargument.name, pLSQLargument.name, object2.getConversionCode(), ((ComplexDatabaseType)databaseType2).getCompatibleType(), (DatabaseField)object);
                    continue;
                }
                super.addNamedArgument(pLSQLargument.name, pLSQLargument.name, object2.getConversionCode(), ((ComplexDatabaseType)databaseType2).getCompatibleType());
                continue;
            }
            super.addNamedArgument(pLSQLargument.name, pLSQLargument.name, object2.getConversionCode(), ((ComplexDatabaseType)databaseType2).getCompatibleType());
        }
        object3 = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        object3.addAll(list2);
        ListIterator<PLSQLargument> listIterator = object3.listIterator();
        while (listIterator.hasNext()) {
            object2 = (PLSQLargument)listIterator.next();
            n = ((PLSQLargument)object2).databaseType.computeOutIndex((PLSQLargument)object2, n, listIterator);
        }
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (PLSQLargument)iterator.next();
            databaseType2 = ((PLSQLargument)object2).databaseType;
            if (!databaseType2.isComplexDatabaseType()) {
                super.addNamedOutputArgument(((PLSQLargument)object2).name, ((PLSQLargument)object2).name, databaseType2.getConversionCode());
                continue;
            }
            databaseType = (ComplexDatabaseType)databaseType2;
            if (((PLSQLargument)object2).outIndex == Integer.MIN_VALUE) continue;
            if (databaseType instanceof PLSQLCollection) {
                object = ((PLSQLCollection)databaseType).getNestedType();
                if (object != null) {
                    ObjectRelationalDatabaseField objectRelationalDatabaseField = new ObjectRelationalDatabaseField(((PLSQLargument)object2).name);
                    objectRelationalDatabaseField.setSqlType(object.getConversionCode());
                    if (object.isComplexDatabaseType()) {
                        ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)object;
                        objectRelationalDatabaseField.setType(complexDatabaseType.getJavaType());
                        objectRelationalDatabaseField.setSqlTypeName(complexDatabaseType.getCompatibleType());
                    }
                    super.addNamedOutputArgument(((PLSQLargument)object2).name, ((PLSQLargument)object2).name, databaseType2.getConversionCode(), ((ComplexDatabaseType)databaseType).getCompatibleType(), ((ComplexDatabaseType)databaseType).getJavaType(), objectRelationalDatabaseField);
                    continue;
                }
                super.addNamedOutputArgument(((PLSQLargument)object2).name, ((PLSQLargument)object2).name, databaseType2.getConversionCode(), ((ComplexDatabaseType)databaseType).getCompatibleType());
                continue;
            }
            if (((ComplexDatabaseType)databaseType).hasCompatibleType()) {
                super.addNamedOutputArgument(((PLSQLargument)object2).name, ((PLSQLargument)object2).name, databaseType2.getConversionCode(), ((ComplexDatabaseType)databaseType).getCompatibleType(), ((ComplexDatabaseType)databaseType).getJavaType());
                continue;
            }
            super.addNamedOutputArgument(((PLSQLargument)object2).name, ((PLSQLargument)object2).name, databaseType2.getConversionCode());
        }
    }

    protected void buildDeclareBlock(StringBuilder stringBuilder) {
        List<PLSQLargument> list = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        List<PLSQLargument> list2 = PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT);
        list.addAll(list2);
        List<PLSQLargument> list3 = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        for (PLSQLargument pLSQLargument : list) {
            pLSQLargument.databaseType.buildInDeclare(stringBuilder, pLSQLargument);
        }
        for (PLSQLargument pLSQLargument : list3) {
            pLSQLargument.databaseType.buildOutDeclare(stringBuilder, pLSQLargument);
        }
    }

    protected void addNestedFunctionsForArgument(List list, PLSQLargument pLSQLargument, DatabaseType databaseType, Set<DatabaseType> set) {
        Object object;
        if (databaseType == null || !databaseType.isComplexDatabaseType() || databaseType.isJDBCType() || set.contains(databaseType)) {
            return;
        }
        ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)databaseType;
        if (!complexDatabaseType.hasCompatibleType()) {
            return;
        }
        set.add(complexDatabaseType);
        if (complexDatabaseType instanceof PLSQLCollection) {
            object = ((PLSQLCollection)complexDatabaseType).getNestedType();
            this.addNestedFunctionsForArgument(list, pLSQLargument, (DatabaseType)object, set);
        } else if (complexDatabaseType instanceof PLSQLrecord) {
            for (PLSQLargument pLSQLargument2 : ((PLSQLrecord)complexDatabaseType).getFields()) {
                DatabaseType databaseType2 = pLSQLargument2.databaseType;
                this.addNestedFunctionsForArgument(list, pLSQLargument, databaseType2, set);
            }
        }
        object = this.typesInfo.get(complexDatabaseType.getTypeName());
        if (object == null) {
            object = this.generateNestedFunction(complexDatabaseType);
        }
        if (pLSQLargument.direction == IN) {
            if (!list.contains(((TypeInfo)object).sql2PlConv)) {
                list.add(((TypeInfo)object).sql2PlConv);
            }
        } else if (pLSQLargument.direction == INOUT) {
            if (!list.contains(((TypeInfo)object).sql2PlConv)) {
                list.add(((TypeInfo)object).sql2PlConv);
            }
            if (!list.contains(((TypeInfo)object).pl2SqlConv)) {
                list.add(((TypeInfo)object).pl2SqlConv);
            }
        } else if (pLSQLargument.direction == OUT && !list.contains(((TypeInfo)object).pl2SqlConv)) {
            list.add(((TypeInfo)object).pl2SqlConv);
        }
    }

    protected TypeInfo generateNestedFunction(ComplexDatabaseType complexDatabaseType) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.pl2SqlName = PL2SQL_PREFIX + this.functionId++;
        typeInfo.sql2PlName = SQL2PL_PREFIX + this.functionId++;
        if (complexDatabaseType.isRecord()) {
            PLSQLrecord pLSQLrecord = (PLSQLrecord)complexDatabaseType;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_DECLARE_FUNCTION);
            stringBuilder.append(typeInfo.pl2SqlName);
            stringBuilder.append("(aPlsqlItem ");
            stringBuilder.append(pLSQLrecord.getTypeName());
            stringBuilder.append(")");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append(pLSQLrecord.getCompatibleType());
            stringBuilder.append(" IS");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aSqlItem ");
            stringBuilder.append(pLSQLrecord.getCompatibleType());
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_BEGIN_BLOCK);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aSqlItem := ");
            stringBuilder.append(pLSQLrecord.getCompatibleType());
            stringBuilder.append("(");
            int n = pLSQLrecord.getFields().size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("NULL");
                if (i + 1 == n) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(");");
            stringBuilder.append(Helper.NL);
            for (PLSQLargument pLSQLargument : pLSQLrecord.getFields()) {
                stringBuilder.append(Helper.INDENT);
                stringBuilder.append(Helper.INDENT);
                stringBuilder.append("aSqlItem.");
                stringBuilder.append(pLSQLargument.name);
                if (pLSQLargument.databaseType.isComplexDatabaseType()) {
                    stringBuilder.append(" := ");
                    stringBuilder.append(this.getPl2SQLName((ComplexDatabaseType)pLSQLargument.databaseType));
                    stringBuilder.append("(aPlsqlItem.");
                    stringBuilder.append(pLSQLargument.name);
                    stringBuilder.append(");");
                } else if (pLSQLargument.databaseType.equals(OraclePLSQLTypes.PLSQLBoolean)) {
                    stringBuilder.append(" := ");
                    stringBuilder.append("SYS.SQLJUTL.BOOL2INT");
                    stringBuilder.append("(aPlsqlItem.");
                    stringBuilder.append(pLSQLargument.name);
                    stringBuilder.append(");");
                } else {
                    stringBuilder.append(" := aPlsqlItem.");
                    stringBuilder.append(pLSQLargument.name);
                    stringBuilder.append(";");
                }
                stringBuilder.append(Helper.NL);
            }
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append("aSqlItem;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END ");
            stringBuilder.append(typeInfo.pl2SqlName);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            typeInfo.pl2SqlConv = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_DECLARE_FUNCTION);
            stringBuilder.append(typeInfo.sql2PlName);
            stringBuilder.append("(aSqlItem ");
            stringBuilder.append(pLSQLrecord.getCompatibleType());
            stringBuilder.append(") ");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append(pLSQLrecord.getTypeName());
            stringBuilder.append(" IS");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aPlsqlItem ");
            stringBuilder.append(pLSQLrecord.getTypeName());
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_BEGIN_BLOCK);
            for (PLSQLargument pLSQLargument : pLSQLrecord.getFields()) {
                stringBuilder.append(Helper.INDENT);
                stringBuilder.append(Helper.INDENT);
                stringBuilder.append("aPlsqlItem.");
                stringBuilder.append(pLSQLargument.name);
                if (pLSQLargument.databaseType.isComplexDatabaseType()) {
                    stringBuilder.append(" := ");
                    stringBuilder.append(this.getSQL2PlName((ComplexDatabaseType)pLSQLargument.databaseType));
                    stringBuilder.append("(aSqlItem.");
                    stringBuilder.append(pLSQLargument.name);
                    stringBuilder.append(");");
                } else if (pLSQLargument.databaseType.equals(OraclePLSQLTypes.PLSQLBoolean)) {
                    stringBuilder.append(" := ");
                    stringBuilder.append("SYS.SQLJUTL.INT2BOOL");
                    stringBuilder.append("(aSqlItem.");
                    stringBuilder.append(pLSQLargument.name);
                    stringBuilder.append(");");
                } else {
                    stringBuilder.append(" := aSqlItem.");
                    stringBuilder.append(pLSQLargument.name);
                    stringBuilder.append(";");
                }
                stringBuilder.append(Helper.NL);
            }
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append("aPlsqlItem;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END ");
            stringBuilder.append(typeInfo.sql2PlName);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            typeInfo.sql2PlConv = stringBuilder.toString();
        } else if (complexDatabaseType.isCollection()) {
            PLSQLCollection pLSQLCollection = (PLSQLCollection)complexDatabaseType;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_DECLARE_FUNCTION);
            stringBuilder.append(typeInfo.pl2SqlName);
            stringBuilder.append("(aPlsqlItem ");
            stringBuilder.append(pLSQLCollection.getTypeName());
            stringBuilder.append(")");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append(pLSQLCollection.getCompatibleType());
            stringBuilder.append(" IS");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aSqlItem ");
            stringBuilder.append(pLSQLCollection.getCompatibleType());
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_BEGIN_BLOCK);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aSqlItem := ");
            stringBuilder.append(pLSQLCollection.getCompatibleType());
            stringBuilder.append("();");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aSqlItem.EXTEND(aPlsqlItem.COUNT);");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("IF aPlsqlItem.COUNT > 0 THEN");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("FOR I IN aPlsqlItem.FIRST..aPlsqlItem.LAST LOOP");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aSqlItem(I + 1 - aPlsqlItem.FIRST) := ");
            if (pLSQLCollection.nestedType != null && pLSQLCollection.nestedType.isComplexDatabaseType()) {
                stringBuilder.append(this.getPl2SQLName((ComplexDatabaseType)pLSQLCollection.nestedType));
                stringBuilder.append("(aPlsqlItem(I));");
            } else if (pLSQLCollection.nestedType.equals(OraclePLSQLTypes.PLSQLBoolean)) {
                stringBuilder.append("SYS.SQLJUTL.BOOL2INT");
                stringBuilder.append("(aPlsqlItem(I));");
            } else {
                stringBuilder.append("aPlsqlItem(I);");
            }
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END LOOP;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END IF;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append("aSqlItem;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END ");
            stringBuilder.append(typeInfo.pl2SqlName);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            typeInfo.pl2SqlConv = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_DECLARE_FUNCTION);
            stringBuilder.append(typeInfo.sql2PlName);
            stringBuilder.append("(aSqlItem ");
            stringBuilder.append(pLSQLCollection.getCompatibleType());
            stringBuilder.append(")");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append(pLSQLCollection.getTypeName());
            stringBuilder.append(" IS");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("aPlsqlItem ");
            stringBuilder.append(pLSQLCollection.getTypeName());
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(BEGIN_BEGIN_BLOCK);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("IF aSqlItem.COUNT > 0 THEN");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("FOR I IN 1..aSqlItem.COUNT LOOP");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            if (pLSQLCollection.nestedType != null && pLSQLCollection.nestedType.isComplexDatabaseType()) {
                stringBuilder.append("aPlsqlItem(I) := ");
                stringBuilder.append(this.getSQL2PlName((ComplexDatabaseType)pLSQLCollection.nestedType));
                stringBuilder.append("(aSqlItem(I));");
            } else if (pLSQLCollection.nestedType.equals(OraclePLSQLTypes.PLSQLBoolean)) {
                stringBuilder.append("aSqlItem(I + 1 - aPlsqlItem.FIRST) := ");
                stringBuilder.append("SYS.SQLJUTL.INT2BOOL");
                stringBuilder.append("(aPlsqlItem(I));");
            } else {
                stringBuilder.append("aPlsqlItem(I) := aSqlItem(I);");
            }
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END LOOP;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END IF;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append(RTURN);
            stringBuilder.append("aPlsqlItem;");
            stringBuilder.append(Helper.NL);
            stringBuilder.append(Helper.INDENT);
            stringBuilder.append("END ");
            stringBuilder.append(typeInfo.sql2PlName);
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
            typeInfo.sql2PlConv = stringBuilder.toString();
        }
        this.typesInfo.put(complexDatabaseType.getTypeName(), typeInfo);
        return typeInfo;
    }

    protected void buildNestedFunctions(StringBuilder stringBuilder) {
        ArrayList arrayList = new ArrayList();
        HashSet<DatabaseType> hashSet = new HashSet<DatabaseType>();
        for (PLSQLargument object : this.arguments) {
            DatabaseType databaseType = object.databaseType;
            this.addNestedFunctionsForArgument(arrayList, object, databaseType, hashSet);
        }
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                stringBuilder.append(string);
            }
        }
    }

    protected void buildBeginBlock(StringBuilder stringBuilder) {
        List<PLSQLargument> list = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        list.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        for (PLSQLargument pLSQLargument : list) {
            pLSQLargument.databaseType.buildBeginBlock(stringBuilder, pLSQLargument, this);
        }
    }

    protected void buildProcedureInvocation(StringBuilder stringBuilder) {
        stringBuilder.append("  ");
        stringBuilder.append(this.getProcedureName());
        stringBuilder.append("(");
        int n = this.arguments.size();
        int n2 = 1;
        for (PLSQLargument pLSQLargument : this.arguments) {
            stringBuilder.append(pLSQLargument.name);
            stringBuilder.append("=>");
            stringBuilder.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(pLSQLargument));
            if (n2 >= n) continue;
            stringBuilder.append(", ");
            ++n2;
        }
        stringBuilder.append(");");
        stringBuilder.append(Helper.NL);
    }

    protected void buildOutAssignments(StringBuilder stringBuilder) {
        List<PLSQLargument> list = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        list.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        for (PLSQLargument pLSQLargument : list) {
            pLSQLargument.databaseType.buildOutAssignment(stringBuilder, pLSQLargument, this);
        }
    }

    @Override
    protected void prepareInternal(AbstractSession abstractSession) {
        this.typesInfo = new HashMap<String, TypeInfo>();
        this.assignIndices();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BEGIN_DECLARE_BLOCK);
        this.buildDeclareBlock(stringBuilder);
        this.buildNestedFunctions(stringBuilder);
        stringBuilder.append(BEGIN_BEGIN_BLOCK);
        this.buildBeginBlock(stringBuilder);
        this.buildProcedureInvocation(stringBuilder);
        this.buildOutAssignments(stringBuilder);
        stringBuilder.append(END_BEGIN_BLOCK);
        this.setSQLStringInternal(stringBuilder.toString());
        super.prepareInternalParameters(abstractSession);
    }

    @Override
    public void translate(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        AbstractRecord abstractRecord3 = (AbstractRecord)abstractRecord.clone();
        int n = abstractRecord3.size();
        Vector vector = abstractRecord3.getFields();
        abstractRecord.clear();
        Vector vector2 = abstractRecord.getFields();
        vector2.setSize(n);
        Vector vector3 = abstractRecord.getValues();
        vector3.setSize(n);
        for (PLSQLargument pLSQLargument : this.arguments) {
            if (pLSQLargument.direction != IN && pLSQLargument.direction != INOUT) continue;
            pLSQLargument.databaseType.translate(pLSQLargument, abstractRecord, abstractRecord3, vector, vector2, vector3, this);
        }
        this.translationRow = abstractRecord;
        super.translate(abstractRecord, abstractRecord2, abstractSession);
    }

    @Override
    public AbstractRecord buildOutputRow(CallableStatement callableStatement) throws SQLException {
        AbstractRecord abstractRecord = super.buildOutputRow(callableStatement);
        Vector vector = abstractRecord.getFields();
        Vector vector2 = abstractRecord.getValues();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        List<PLSQLargument> list = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        list.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(list, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument pLSQLargument, PLSQLargument pLSQLargument2) {
                return pLSQLargument.originalIndex - pLSQLargument2.originalIndex;
            }
        });
        for (PLSQLargument pLSQLargument : list) {
            pLSQLargument.databaseType.buildOutputRow(pLSQLargument, abstractRecord, databaseRecord, vector, vector2);
        }
        return databaseRecord;
    }

    @Override
    public String getLogString(Accessor accessor) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(this.getSQLString());
        stringBuilder.append(Helper.cr());
        stringBuilder.append(Helper.INDENT);
        stringBuilder.append("bind => [");
        List<PLSQLargument> list = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        list.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(list, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument pLSQLargument, PLSQLargument pLSQLargument2) {
                return pLSQLargument.inIndex - pLSQLargument2.inIndex;
            }
        });
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ((PLSQLargument)object).databaseType.logParameter(stringBuilder, IN, (PLSQLargument)object, this.translationRow, this.getQuery().getSession().getPlatform());
            if (!object2.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object2 = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        object2.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(object2, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument pLSQLargument, PLSQLargument pLSQLargument2) {
                return pLSQLargument.outIndex - pLSQLargument2.outIndex;
            }
        });
        if (!list.isEmpty() && !object2.isEmpty()) {
            stringBuilder.append(", ");
        }
        object = object2.iterator();
        while (object.hasNext()) {
            PLSQLargument pLSQLargument = (PLSQLargument)object.next();
            pLSQLargument.databaseType.logParameter(stringBuilder, OUT, pLSQLargument, this.translationRow, this.getQuery().getSession().getPlatform());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected static List<PLSQLargument> getArguments(List<PLSQLargument> list, Integer n) {
        ArrayList<PLSQLargument> arrayList = new ArrayList<PLSQLargument>();
        for (PLSQLargument pLSQLargument : list) {
            if (pLSQLargument.direction != n) continue;
            arrayList.add(pLSQLargument);
        }
        return arrayList;
    }

    public String getSQL2PlName(ComplexDatabaseType complexDatabaseType) {
        if (this.typesInfo == null) {
            return null;
        }
        TypeInfo typeInfo = this.typesInfo.get(complexDatabaseType.getTypeName());
        if (typeInfo == null) {
            typeInfo = this.generateNestedFunction(complexDatabaseType);
        }
        return typeInfo.sql2PlName;
    }

    public String getPl2SQLName(ComplexDatabaseType complexDatabaseType) {
        if (this.typesInfo == null) {
            return null;
        }
        TypeInfo typeInfo = this.typesInfo.get(complexDatabaseType.getTypeName());
        if (typeInfo == null) {
            typeInfo = this.generateNestedFunction(complexDatabaseType);
        }
        return typeInfo.pl2SqlName;
    }

    class TypeInfo {
        String sql2PlName;
        String sql2PlConv;
        String pl2SqlName;
        String pl2SqlConv;

        TypeInfo() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Helper.NL);
            stringBuilder.append(this.sql2PlName == null ? "" : this.sql2PlConv);
            stringBuilder.append(this.pl2SqlName == null ? "" : this.pl2SqlConv);
            return stringBuilder.toString();
        }
    }
}

