/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;

public class XMLPlatformFactory {
    public static final String XML_PLATFORM_PROPERTY = "eclipselink.xml.platform";
    public static final String XDK_PLATFORM_CLASS_NAME = "org.eclipse.persistence.platform.xml.xdk.XDKPlatform";
    public static final String JAXP_PLATFORM_CLASS_NAME = "org.eclipse.persistence.platform.xml.jaxp.JAXPPlatform";
    private static XMLPlatformFactory instance;
    private Class xmlPlatformClass;

    private XMLPlatformFactory() {
    }

    public static XMLPlatformFactory getInstance() throws XMLPlatformException {
        if (null == instance) {
            instance = new XMLPlatformFactory();
        }
        return instance;
    }

    public Class getXMLPlatformClass() throws XMLPlatformException {
        if (null != this.xmlPlatformClass) {
            return this.xmlPlatformClass;
        }
        String string = System.getProperty(XML_PLATFORM_PROPERTY);
        if (null == string) {
            string = JAXP_PLATFORM_CLASS_NAME;
        }
        try {
            ClassLoader classLoader = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(this.getClass()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (RuntimeException)privilegedActionException.getCause();
                }
            } else {
                classLoader = PrivilegedAccessHelper.getClassLoaderForClass(this.getClass());
            }
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class<?> clazz = classLoader.loadClass(string);
            this.setXMLPlatformClass(clazz);
            return this.xmlPlatformClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw XMLPlatformException.xmlPlatformClassNotFound(string, classNotFoundException);
        }
    }

    public void setXMLPlatformClass(Class clazz) {
        this.xmlPlatformClass = clazz;
    }

    public XMLPlatform getXMLPlatform() throws XMLPlatformException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (XMLPlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getXMLPlatformClass()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (RuntimeException)privilegedActionException.getCause();
                }
            }
            return (XMLPlatform)PrivilegedAccessHelper.newInstanceFromClass(this.getXMLPlatformClass());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), instantiationException);
        }
    }
}

