/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursor;

public abstract class Cursor
implements Enumeration,
Serializable {
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    protected transient AbstractSession session;
    protected transient AbstractSession executionSession;
    protected transient Vector fields;
    protected int size = -1;
    public transient CursorPolicy policy;
    protected Vector objectCollection;
    protected Map initiallyConformingIndex;
    protected Expression selectionCriteriaClone;
    protected AbstractRecord translationRow;
    protected int position;

    public Cursor() {
    }

    public Cursor(DatabaseCall databaseCall, CursorPolicy cursorPolicy) {
        this.session = cursorPolicy.getQuery().getSession();
        this.executionSession = this.session.getExecutionSession(cursorPolicy.getQuery());
        this.statement = databaseCall.getStatement();
        this.fields = databaseCall.getFields();
        this.resultSet = databaseCall.getResult();
        this.policy = cursorPolicy;
        this.setObjectCollection(new Vector());
        if (this.getQuery().getSession().isUnitOfWork() && this.getQuery().isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
            objectLevelReadQuery.registerResultInUnitOfWork(this, (UnitOfWorkImpl)this.session, this.getQuery().getTranslationRow(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DatabaseException {
        RuntimeException runtimeException = null;
        try {
            block14: {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.getAccessor().closeCursor(this.getResultSet(), this.getSession());
                    this.getAccessor().closeStatement(this.getStatement(), this.getSession(), null);
                }
                catch (RuntimeException runtimeException2) {
                    runtimeException = runtimeException2;
                }
                finally {
                    block15: {
                        try {
                            this.getSession().releaseReadConnection(this.getQuery().getAccessor());
                        }
                        catch (RuntimeException runtimeException3) {
                            if (runtimeException != null) break block15;
                            throw runtimeException3;
                        }
                    }
                    if (runtimeException == null) break block14;
                    throw runtimeException;
                }
            }
            this.setResultSet(null);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this.getAccessor(), this.getSession(), false);
        }
    }

    protected void finalize() throws DatabaseException {
        this.close();
    }

    protected DatabaseAccessor getAccessor() {
        try {
            return (DatabaseAccessor)this.getQuery().getAccessor();
        }
        catch (ClassCastException classCastException) {
            throw QueryException.invalidDatabaseAccessor(this.getQuery().getAccessor());
        }
    }

    protected abstract int getCursorSize() throws DatabaseException, QueryException;

    protected Vector getFields() {
        return this.fields;
    }

    public Map getInitiallyConformingIndex() {
        return this.initiallyConformingIndex;
    }

    public Vector getObjectCollection() {
        return this.objectCollection;
    }

    public int getPageSize() {
        return this.getPolicy().getPageSize();
    }

    public CursorPolicy getPolicy() {
        return this.policy;
    }

    public abstract int getPosition();

    public ReadQuery getQuery() {
        return this.getPolicy().getQuery();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Expression getSelectionCriteriaClone() {
        return this.selectionCriteriaClone;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    protected AbstractSession getExecutionSession() {
        return this.executionSession;
    }

    protected Statement getStatement() {
        return this.statement;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public boolean isClosed() {
        return this.getResultSet() == null;
    }

    protected Object buildAndRegisterObject(AbstractRecord abstractRecord) {
        Object object = null;
        if (this.getSession().isUnitOfWork() && !this.getQuery().isReportQuery() && this.getQuery().shouldMaintainCache() && this.getQuery().isObjectLevelReadQuery()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
            if (objectLevelReadQuery.shouldConformResultsInUnitOfWork() || objectLevelReadQuery.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
                object = objectLevelReadQuery.conformIndividualResult(abstractRecord, unitOfWorkImpl, this.getTranslationRow(), this.getSelectionCriteriaClone(), this.getInitiallyConformingIndex(), true);
                if (object == null) {
                    return InvalidObject.instance;
                }
            } else {
                object = objectLevelReadQuery.buildObject(abstractRecord);
            }
        } else {
            object = this.getQuery().buildObject(abstractRecord);
        }
        return object;
    }

    protected Object retrieveNextObject() throws DatabaseException {
        AbstractRecord abstractRecord;
        Object object;
        do {
            if (this.isClosed()) {
                return null;
            }
            abstractRecord = this.getAccessor().cursorRetrieveNextRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (abstractRecord != null) continue;
            if (!(this instanceof ScrollableCursor)) {
                this.close();
            }
            return null;
        } while ((object = this.buildAndRegisterObject(abstractRecord)) == InvalidObject.instance);
        return object;
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        AbstractRecord abstractRecord;
        Object object;
        do {
            if (this.isClosed()) {
                return null;
            }
            abstractRecord = this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (abstractRecord != null) continue;
            if (!(this instanceof ScrollableCursor)) {
                this.close();
            }
            return null;
        } while ((object = this.buildAndRegisterObject(abstractRecord)) == InvalidObject.instance);
        return object;
    }

    protected void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setInitiallyConformingIndex(Map map) {
        this.initiallyConformingIndex = map;
    }

    public void setObjectCollection(Vector vector) {
        this.objectCollection = vector;
    }

    public void setPolicy(CursorPolicy cursorPolicy) {
        this.policy = cursorPolicy;
    }

    protected void setPosition(int n) {
        this.position = n;
    }

    protected void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void setSelectionCriteriaClone(Expression expression) {
        this.selectionCriteriaClone = expression;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    protected void setExecutionSession(AbstractSession abstractSession) {
        this.executionSession = abstractSession;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setTranslationRow(AbstractRecord abstractRecord) {
        this.translationRow = abstractRecord;
    }

    public int size() throws DatabaseException {
        if (this.size == -1) {
            this.size = this.getCursorSize();
            if (this.getInitiallyConformingIndex() != null) {
                this.size += this.getInitiallyConformingIndex().size();
            }
        }
        return this.size;
    }
}

