/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.JPQLCall;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseQuery
implements Cloneable,
Serializable {
    protected String name;
    protected Vector arguments;
    protected List<DatabaseField> argumentFields;
    protected Vector argumentValues;
    protected Vector argumentTypes;
    protected Vector argumentTypeNames;
    protected transient ClassDescriptor descriptor;
    protected DatabaseQueryMechanism queryMechanism;
    protected QueryRedirector redirector;
    protected boolean doNotRedirect = false;
    protected boolean shouldMaintainCache = true;
    protected Hashtable properties;
    protected transient AbstractSession session;
    protected transient AbstractSession executionSession;
    protected transient Accessor accessor;
    protected AbstractRecord translationRow;
    protected boolean isUserDefined = false;
    protected int cascadePolicy = 1;
    protected String sessionName;
    protected boolean isPrepared = false;
    protected boolean shouldCloneCall = false;
    protected boolean shouldPrepare = true;
    protected Boolean shouldBindAllParameters = null;
    protected Boolean shouldCacheStatement = null;
    protected boolean shouldUseWrapperPolicy = true;
    protected DatabaseMapping sourceMapping;
    protected int queryTimeout = -1;
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    public static final int CascadeDependentParts = 4;
    public static final int CascadeAggregateDelete = 5;
    public static final int CascadeByMapping = 6;
    protected String hintString;
    protected Boolean flushOnExecute;
    protected boolean isExecutionClone = false;
    protected Boolean isCustomQueryUsed;
    protected boolean isNativeConnectionRequired;

    public void addArgument(String string) {
        this.addArgument(string, Object.class);
    }

    public void addArgument(String string, Class clazz) {
        this.getArguments().add(string);
        this.getArgumentTypes().add(clazz);
        this.getArgumentTypeNames().add(clazz.getName());
    }

    public void addArgument(String string, String string2) {
        this.getArguments().add(string);
        this.getArgumentTypes().add(Helper.getObjectClass(ConversionManager.loadClass(string2)));
        this.getArgumentTypeNames().add(string2);
    }

    public void addArgumentByTypeName(String string, String string2) {
        this.getArguments().addElement(string);
        this.getArgumentTypeNames().addElement(string2);
    }

    public void addArgumentValue(Object object) {
        this.getArgumentValues().addElement(object);
    }

    public void addArgumentValues(List list) {
        this.getArgumentValues().addAll(list);
    }

    public void addCall(Call call) {
        this.setQueryMechanism(call.buildQueryMechanism(this, this.getQueryMechanism()));
        this.setIsPrepared(false);
    }

    public void addStatement(SQLStatement sQLStatement) {
        if (!this.hasQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        } else if (!this.getQueryMechanism().isStatementQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        }
        ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatements().addElement(sQLStatement);
        this.setIsPrepared(false);
    }

    public void bindAllParameters() {
        this.setShouldBindAllParameters(true);
    }

    protected void buildSelectionCriteria(AbstractSession abstractSession) {
        this.getQueryMechanism().buildSelectionCriteria(abstractSession);
    }

    public void cacheStatement() {
        this.setShouldCacheStatement(true);
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadeByMapping() {
        this.setCascadePolicy(6);
    }

    public void cascadeOnlyDependentParts() {
        this.setCascadePolicy(4);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void checkDescriptor(AbstractSession abstractSession) throws QueryException {
    }

    public Object checkEarlyReturn(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        return null;
    }

    public void checkPrepare(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkPrepare(abstractSession, abstractRecord, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPrepare(AbstractSession abstractSession, AbstractRecord abstractRecord, boolean bl) {
        if (!this.isPrepared()) {
            abstractSession.startOperationProfile("query prepare", this, Integer.MAX_VALUE);
            if (!bl && this.shouldPrepare() && this.checkForCustomQuery(abstractSession, abstractRecord) != null) {
                abstractSession.endOperationProfile("query prepare", this, Integer.MAX_VALUE);
                return;
            }
            DatabaseQuery databaseQuery = this;
            synchronized (databaseQuery) {
                if (!this.isPrepared()) {
                    if ((this.isReadQuery() || this.isDataModifyQuery()) && this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism && (abstractRecord == null || abstractRecord.isEmpty())) {
                        if (this.isReadObjectQuery() || this.isUserDefined()) {
                            ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                        }
                    } else if (this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism) {
                        ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                    }
                    this.setSession(abstractSession);
                    this.prepare();
                    this.setSession(null);
                    this.setIsPrepared(true);
                }
            }
            abstractSession.endOperationProfile("query prepare", this, Integer.MAX_VALUE);
        }
    }

    public Object clone() {
        try {
            DatabaseQuery databaseQuery = (DatabaseQuery)super.clone();
            databaseQuery.sourceMapping = this.sourceMapping;
            if (databaseQuery.properties != null) {
                if (databaseQuery.properties.isEmpty()) {
                    databaseQuery.setProperties(null);
                } else {
                    databaseQuery.setProperties((Hashtable)this.getProperties().clone());
                }
            }
            if (this.hasQueryMechanism()) {
                databaseQuery.setQueryMechanism(this.getQueryMechanism().clone(databaseQuery));
            }
            databaseQuery.setIsPrepared(this.isPrepared());
            return databaseQuery;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery databaseQuery, AbstractSession abstractSession) {
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public void dontBindAllParameters() {
        this.setShouldBindAllParameters(false);
    }

    public void dontCacheStatement() {
        this.setShouldCacheStatement(false);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public void dontMaintainCache() {
        this.setShouldMaintainCache(false);
    }

    public abstract Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException;

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        return this.execute(unitOfWorkImpl, abstractRecord);
    }

    public Object execute(AbstractSession abstractSession, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        Object object;
        Object object2;
        DatabaseQuery databaseQuery = this;
        QueryRedirector queryRedirector = this.getRedirector();
        if (queryRedirector != null) {
            return this.redirectQuery(queryRedirector, databaseQuery, abstractSession, abstractRecord);
        }
        if (databaseQuery.isCustomSelectionQuery() && databaseQuery.shouldPrepare()) {
            databaseQuery.checkPrepare(abstractSession, abstractRecord);
        }
        if ((object2 = databaseQuery.checkEarlyReturn(abstractSession, abstractRecord)) == InvalidObject.instance) {
            return null;
        }
        if (object2 != null) {
            return object2;
        }
        boolean bl = false;
        if (!this.isPrepared() && this.shouldPrepare() && (object = this.checkForCustomQuery(abstractSession, abstractRecord)) != null) {
            bl = true;
            databaseQuery = object;
        }
        if ((databaseQuery = abstractSession.prepareDatabaseQuery(databaseQuery)).shouldPrepare()) {
            databaseQuery.checkPrepare(abstractSession, abstractRecord);
        }
        if (!databaseQuery.isExecutionClone()) {
            databaseQuery = (DatabaseQuery)databaseQuery.clone();
        }
        databaseQuery.setTranslationRow(abstractRecord);
        if (!databaseQuery.shouldPrepare()) {
            databaseQuery.checkPrepare(abstractSession, abstractRecord);
        }
        databaseQuery.setSession(abstractSession);
        if (bl) {
            this.prepareCustomQuery(databaseQuery);
            queryRedirector = databaseQuery.getRedirector();
            if (queryRedirector != null) {
                return this.redirectQuery(queryRedirector, databaseQuery, abstractSession, databaseQuery.getTranslationRow());
            }
        }
        databaseQuery.prepareForExecution();
        object = databaseQuery.executeDatabaseQuery();
        this.clonedQueryExecutionComplete(databaseQuery, abstractSession);
        return object;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = NonSynchronizedVector.newInstance();
        }
        return this.arguments;
    }

    public Vector getArgumentTypes() {
        if (this.argumentTypes == null || this.argumentTypes.isEmpty()) {
            this.argumentTypes = new Vector();
            if (this.argumentTypeNames != null) {
                for (String string : this.argumentTypeNames) {
                    this.argumentTypes.addElement(Helper.getObjectClass(ConversionManager.loadClass(string)));
                }
            }
        }
        return this.argumentTypes;
    }

    public Vector getArgumentTypeNames() {
        if (this.argumentTypeNames == null) {
            this.argumentTypeNames = NonSynchronizedVector.newInstance();
        }
        return this.argumentTypeNames;
    }

    public void setArgumentTypes(Vector vector) {
        this.argumentTypes = vector;
        this.getArgumentTypeNames().clear();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.argumentTypeNames.addElement(((Class)iterator.next()).getName());
        }
    }

    public void setArgumentTypeNames(Vector vector) {
        this.argumentTypeNames = vector;
    }

    public void setArguments(Vector vector) {
        Vector<Class<Object>> vector2 = new Vector<Class<Object>>(vector.size());
        Vector<String> vector3 = new Vector<String>(vector.size());
        Vector<DatabaseField> vector4 = new Vector<DatabaseField>(vector.size());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector2.add(Object.class);
            vector3.add("java.lang.Object");
            DatabaseField databaseField = new DatabaseField((String)vector.get(i));
            vector4.add(databaseField);
        }
        this.arguments = vector;
        this.argumentTypes = vector2;
        this.argumentTypeNames = vector3;
        this.argumentFields = vector4;
    }

    public Vector getArgumentValues() {
        if (this.argumentValues == null) {
            this.argumentValues = NonSynchronizedVector.newInstance();
        }
        return this.argumentValues;
    }

    public void setArgumentValues(Vector vector) {
        this.argumentValues = vector;
    }

    public DatabaseCall getCall() {
        Call call = this.getDatasourceCall();
        if (call instanceof DatabaseCall) {
            return (DatabaseCall)call;
        }
        return null;
    }

    public Call getDatasourceCall() {
        Call call = null;
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism datasourceCallQueryMechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            call = datasourceCallQueryMechanism.getCall();
            if (datasourceCallQueryMechanism.hasMultipleCalls()) {
                call = (Call)datasourceCallQueryMechanism.getCalls().get(0);
            }
        }
        if (call == null && this.getQueryMechanism().isJPQLCallQueryMechanism()) {
            call = ((JPQLCallQueryMechanism)this.getQueryMechanism()).getJPQLCall();
        }
        return call;
    }

    public List getDatasourceCalls() {
        Vector vector = new Vector();
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism datasourceCallQueryMechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            if (datasourceCallQueryMechanism.hasMultipleCalls()) {
                vector = datasourceCallQueryMechanism.getCalls();
            } else {
                vector.add(datasourceCallQueryMechanism.getCall());
            }
        }
        if (vector.isEmpty() && this.getQueryMechanism().isJPQLCallQueryMechanism()) {
            vector.add(((JPQLCallQueryMechanism)this.getQueryMechanism()).getJPQLCall());
        }
        return vector;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(5);
        }
        return this.properties;
    }

    public synchronized Object getProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(object);
    }

    public DatabaseQueryMechanism getQueryMechanism() {
        if (this.queryMechanism == null) {
            this.queryMechanism = new ExpressionQueryMechanism(this);
        }
        return this.queryMechanism;
    }

    public boolean hasQueryMechanism() {
        return this.queryMechanism != null;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultQueryRedirector();
    }

    public QueryRedirector getRedirector() {
        if (this.doNotRedirect) {
            return null;
        }
        if (this.redirector != null) {
            return this.redirector;
        }
        if (this.descriptor != null) {
            this.redirector = this.getDefaultRedirector();
            if (this.redirector == null) {
                this.doNotRedirect = true;
            }
            return this.redirector;
        }
        return null;
    }

    public Class getReferenceClass() {
        return null;
    }

    public String getReferenceClassName() {
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.getQueryMechanism().getSelectionCriteria();
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public AbstractSession getExecutionSession() {
        if (this.executionSession == null && this.getSession() != null) {
            this.executionSession = this.getSession().getExecutionSession(this);
        }
        return this.executionSession;
    }

    protected void setExecutionSession(AbstractSession abstractSession) {
        this.executionSession = abstractSession;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SQLStatement getSQLStatement() {
        return ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatement();
    }

    public String getJPQLString() {
        return this.getEJBQLString();
    }

    public String getEJBQLString() {
        if (!this.getQueryMechanism().isJPQLCallQueryMechanism()) {
            return null;
        }
        JPQLCall jPQLCall = ((JPQLCallQueryMechanism)this.getQueryMechanism()).getJPQLCall();
        return jPQLCall.getEjbqlString();
    }

    public String getHintString() {
        return this.hintString;
    }

    public String getSQLString() {
        Call call = this.getDatasourceCall();
        if (call == null) {
            return null;
        }
        if (!(call instanceof SQLCall)) {
            return null;
        }
        return ((SQLCall)call).getSQLString();
    }

    public List getSQLStrings() {
        List list = this.getDatasourceCalls();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Vector<String> vector = new Vector<String>(list.size());
        for (Call call : list) {
            if (!(call instanceof SQLCall)) {
                return null;
            }
            vector.addElement(((SQLCall)call).getSQLString());
        }
        return vector;
    }

    public Boolean getShouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public DatabaseMapping getSourceMapping() {
        return this.sourceMapping;
    }

    public String getTranslatedSQLString(Session session, Record record) {
        this.prepareCall(session, record);
        CallQueryMechanism callQueryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (callQueryMechanism.getCall() == null) {
            return null;
        }
        SQLCall sQLCall = (SQLCall)callQueryMechanism.getCall().clone();
        sQLCall.setUsesBinding(false);
        sQLCall.translate((AbstractRecord)record, callQueryMechanism.getModifyRow(), (AbstractSession)session);
        return sQLCall.getSQLString();
    }

    public List getTranslatedSQLStrings(Session session, Record record) {
        this.prepareCall(session, record);
        CallQueryMechanism callQueryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (callQueryMechanism.getCalls() == null || callQueryMechanism.getCalls().isEmpty()) {
            return null;
        }
        Vector<String> vector = new Vector<String>(callQueryMechanism.getCalls().size());
        for (SQLCall sQLCall : callQueryMechanism.getCalls()) {
            sQLCall = (SQLCall)sQLCall.clone();
            sQLCall.setUsesBinding(false);
            sQLCall.translate((AbstractRecord)record, callQueryMechanism.getModifyRow(), (AbstractSession)session);
            vector.add(sQLCall.getSQLString());
        }
        return vector;
    }

    public AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public boolean hasAccessor() {
        return this.accessor != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public boolean hasSessionName() {
        return this.sessionName != null;
    }

    public void ignoreBindAllParameters() {
        this.shouldBindAllParameters = null;
    }

    public void ignoreCacheStatement() {
        this.shouldCacheStatement = null;
    }

    public boolean isCallQuery() {
        return this.getQueryMechanism().isCallQueryMechanism();
    }

    public boolean isCascadeOfAggregateDelete() {
        return this.getCascadePolicy() == 5;
    }

    public boolean isDataModifyQuery() {
        return false;
    }

    public boolean isDataReadQuery() {
        return false;
    }

    public boolean isValueReadQuery() {
        return false;
    }

    public boolean isDirectReadQuery() {
        return false;
    }

    public boolean isDeleteAllQuery() {
        return false;
    }

    public boolean isDeleteObjectQuery() {
        return false;
    }

    public boolean isExpressionQuery() {
        return this.getQueryMechanism().isExpressionQueryMechanism();
    }

    public boolean isModifyAllQuery() {
        return false;
    }

    public boolean isModifyQuery() {
        return false;
    }

    public boolean isUpdateAllQuery() {
        return false;
    }

    public boolean isUpdateObjectQuery() {
        return false;
    }

    public Boolean getFlushOnExecute() {
        return this.flushOnExecute;
    }

    public boolean isInsertObjectQuery() {
        return false;
    }

    public boolean isObjectLevelModifyQuery() {
        return false;
    }

    public boolean isObjectLevelReadQuery() {
        return false;
    }

    public boolean isObjectBuildingQuery() {
        return false;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public boolean isReadAllQuery() {
        return false;
    }

    public boolean isReadObjectQuery() {
        return false;
    }

    public boolean isReadQuery() {
        return false;
    }

    public boolean isReportQuery() {
        return false;
    }

    public boolean isSQLCallQuery() {
        Call call = this.getDatasourceCall();
        return call != null && call instanceof SQLCall;
    }

    public boolean isJPQLCallQuery() {
        Call call = this.getDatasourceCall();
        return call != null && call instanceof JPQLCall;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public boolean isDefaultPropertiesQuery() {
        return !this.isUserDefined() && this.shouldPrepare() && this.getQueryTimeout() == -1 && this.getHintString() == null && this.shouldIgnoreBindAllParameters() && this.shouldIgnoreCacheStatement() && this.shouldUseWrapperPolicy();
    }

    public boolean isWriteObjectQuery() {
        return false;
    }

    public void maintainCache() {
        this.setShouldMaintainCache(true);
    }

    protected void prepare() throws QueryException {
        if (this.getQueryTimeout() == -1) {
            if (this.getDescriptor() == null) {
                this.setQueryTimeout(0);
            } else {
                this.setQueryTimeout(this.getDescriptor().getQueryManager().getQueryTimeout());
            }
        }
        if (this.getQueryTimeout() == -1 || this.getQueryTimeout() == 0) {
            this.setQueryTimeout(this.session.getQueryTimeoutDefault());
        }
        this.argumentFields = this.buildArgumentFields();
        this.getQueryMechanism().prepare();
    }

    public void copyFromQuery(DatabaseQuery databaseQuery) {
        this.prepareFromQuery(databaseQuery);
        this.cascadePolicy = databaseQuery.cascadePolicy;
        this.flushOnExecute = databaseQuery.flushOnExecute;
        this.arguments = databaseQuery.arguments;
        this.argumentTypes = databaseQuery.argumentTypes;
        this.argumentTypeNames = databaseQuery.argumentTypeNames;
        this.argumentValues = databaseQuery.argumentValues;
        this.queryTimeout = databaseQuery.queryTimeout;
        this.redirector = databaseQuery.redirector;
        this.sessionName = databaseQuery.sessionName;
        this.shouldBindAllParameters = databaseQuery.shouldBindAllParameters;
        this.shouldCacheStatement = databaseQuery.shouldCacheStatement;
        this.shouldMaintainCache = databaseQuery.shouldMaintainCache;
        this.shouldPrepare = databaseQuery.shouldPrepare;
        this.shouldUseWrapperPolicy = databaseQuery.shouldUseWrapperPolicy;
        this.properties = databaseQuery.properties;
    }

    public void prepareFromQuery(DatabaseQuery databaseQuery) {
        this.setQueryMechanism((DatabaseQueryMechanism)databaseQuery.getQueryMechanism().clone());
        this.getQueryMechanism().setQuery(this);
        this.descriptor = databaseQuery.descriptor;
        this.hintString = databaseQuery.hintString;
        this.isCustomQueryUsed = databaseQuery.isCustomQueryUsed;
        this.argumentFields = databaseQuery.argumentFields;
    }

    public void prepareCall(Session session, Record record) throws QueryException {
        this.checkPrepare((AbstractSession)session, (AbstractRecord)record, true);
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
    }

    public void prepareForExecution() throws QueryException {
    }

    protected void prepareForRemoteExecution() {
    }

    public Object redirectQuery(QueryRedirector queryRedirector, DatabaseQuery databaseQuery, AbstractSession abstractSession, AbstractRecord abstractRecord) {
        if (queryRedirector == null) {
            return null;
        }
        DatabaseQuery databaseQuery2 = (DatabaseQuery)databaseQuery.clone();
        databaseQuery2.setRedirector(null);
        Object object = queryRedirector.invokeQuery(databaseQuery2, abstractRecord, abstractSession);
        this.setDescriptor(databaseQuery2.getDescriptor());
        return object;
    }

    protected Object remoteExecute() {
        Transporter transporter = ((RemoteSession)this.getSession()).getRemoteConnection().remoteExecute((DatabaseQuery)this.clone());
        return this.extractRemoteResult(transporter);
    }

    public Object remoteExecute(AbstractSession abstractSession) {
        this.setSession(abstractSession);
        this.prepareForRemoteExecution();
        return this.remoteExecute();
    }

    public void removeProperty(Object object) {
        this.getProperties().remove(object);
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    public List<DatabaseField> buildArgumentFields() {
        Vector vector = this.getArguments();
        Vector vector2 = this.getArgumentTypes();
        ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>(vector.size());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = new DatabaseField((String)vector.get(i));
            databaseField.setType((Class)vector2.get(i));
            arrayList.add(databaseField);
        }
        return arrayList;
    }

    public AbstractRecord rowFromArguments(List list) throws QueryException {
        List<DatabaseField> list2 = this.argumentFields;
        if (!this.isPrepared() || list2 == null) {
            list2 = this.buildArgumentFields();
        }
        if (list2.size() != list.size()) {
            throw QueryException.argumentSizeMismatchInQueryAndQueryDefinition(this);
        }
        int n = list2.size();
        DatabaseRecord databaseRecord = new DatabaseRecord(n);
        for (int i = 0; i < n; ++i) {
            databaseRecord.put(list2.get(i), list.get(i));
        }
        return databaseRecord;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setDatasourceCall(Call call) {
        if (call == null) {
            return;
        }
        this.setQueryMechanism(call.buildNewQueryMechanism(this));
    }

    public void setCall(Call call) {
        this.setDatasourceCall(call);
    }

    public void setCascadePolicy(int n) {
        this.cascadePolicy = n;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        if (this.descriptor != classDescriptor) {
            this.setIsPrepared(false);
        }
        this.descriptor = classDescriptor;
    }

    public void setJPQLString(String string) {
        this.setEJBQLString(string);
    }

    public void setEJBQLString(String string) {
        if (string != null && !string.equals("")) {
            JPQLCallQueryMechanism jPQLCallQueryMechanism = new JPQLCallQueryMechanism(this, new JPQLCall(string));
            this.setQueryMechanism(jPQLCallQueryMechanism);
        }
    }

    public void setFlushOnExecute(Boolean bl) {
        this.flushOnExecute = bl;
    }

    public void setHintString(String string) {
        this.hintString = string;
        this.setIsPrepared(false);
    }

    public void setIsPrepared(boolean bl) {
        this.isPrepared = bl;
        this.isCustomQueryUsed = null;
    }

    public boolean isExecutionClone() {
        return this.isExecutionClone;
    }

    public void setIsExecutionClone(boolean bl) {
        this.isExecutionClone = bl;
    }

    public Boolean isCustomQueryUsed() {
        return this.isCustomQueryUsed;
    }

    protected boolean isCustomSelectionQuery() {
        return this.getQueryMechanism().isCallQueryMechanism() && this.getArguments().isEmpty();
    }

    protected void setIsCustomQueryUsed(boolean bl) {
        this.isCustomQueryUsed = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setIsUserDefined(boolean bl) {
        this.isUserDefined = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public synchronized void setProperty(Object object, Object object2) {
        this.getProperties().put(object, object2);
    }

    protected void setQueryMechanism(DatabaseQueryMechanism databaseQueryMechanism) {
        this.queryMechanism = databaseQueryMechanism;
        this.setIsPrepared(false);
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
        this.shouldCloneCall = true;
    }

    public void setRedirector(QueryRedirector queryRedirector) {
        this.redirector = queryRedirector;
        this.doNotRedirect = false;
    }

    public void setSelectionCriteria(Expression expression) {
        if (expression == null && !this.getQueryMechanism().isExpressionQueryMechanism()) {
            return;
        }
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            this.setQueryMechanism(new ExpressionQueryMechanism(this, expression));
        } else {
            ((ExpressionQueryMechanism)this.getQueryMechanism()).setSelectionCriteria(expression);
        }
        this.setIsPrepared(false);
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.executionSession = null;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setShouldBindAllParameters(boolean bl) {
        this.shouldBindAllParameters = bl;
        this.setIsPrepared(false);
    }

    public void setShouldBindAllParameters(Boolean bl) {
        this.shouldBindAllParameters = bl;
    }

    public void setShouldCacheStatement(boolean bl) {
        this.shouldCacheStatement = bl;
        this.setIsPrepared(false);
    }

    public void setShouldMaintainCache(boolean bl) {
        this.shouldMaintainCache = bl;
    }

    public void setShouldPrepare(boolean bl) {
        this.shouldPrepare = bl;
        this.setIsPrepared(false);
    }

    public void setShouldUseWrapperPolicy(boolean bl) {
        this.shouldUseWrapperPolicy = bl;
    }

    public void setSourceMapping(DatabaseMapping databaseMapping) {
        this.sourceMapping = databaseMapping;
    }

    public void setSQLStatement(SQLStatement sQLStatement) {
        this.setQueryMechanism(new StatementQueryMechanism(this, sQLStatement));
    }

    public void setSQLString(String string) {
        if (string != null && !string.equals("")) {
            this.setCall(new SQLCall(string));
        }
    }

    public void setTranslationRow(AbstractRecord abstractRecord) {
        this.translationRow = abstractRecord;
    }

    public boolean shouldBindAllParameters() {
        return Boolean.TRUE.equals(this.shouldBindAllParameters);
    }

    public boolean shouldCacheStatement() {
        return Boolean.TRUE.equals(this.shouldCacheStatement);
    }

    public boolean shouldCascadeAllParts() {
        return this.cascadePolicy == 3;
    }

    public boolean shouldCascadeByMapping() {
        return this.cascadePolicy == 6;
    }

    public boolean shouldCascadeOnlyDependentParts() {
        return this.cascadePolicy == 4;
    }

    public boolean shouldCascadeParts() {
        return this.cascadePolicy != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.cascadePolicy == 2 || this.cascadePolicy == 3;
    }

    public boolean shouldCloneCall() {
        return this.shouldCloneCall;
    }

    public boolean shouldIgnoreBindAllParameters() {
        return this.shouldBindAllParameters == null;
    }

    public boolean shouldIgnoreCacheStatement() {
        return this.shouldCacheStatement == null;
    }

    public boolean shouldMaintainCache() {
        return this.shouldMaintainCache;
    }

    public boolean shouldPrepare() {
        return this.shouldPrepare;
    }

    public boolean shouldUseWrapperPolicy() {
        return this.shouldUseWrapperPolicy;
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this.getReferenceClass() != null) {
            string = "referenceClass=" + this.getReferenceClass().getSimpleName() + " ";
        }
        if (this.getName() != null && !this.getName().equals("")) {
            string2 = "name=\"" + this.getName() + "\" ";
        }
        if (this.isSQLCallQuery()) {
            string3 = "sql=\"" + this.getSQLString() + "\"";
        } else if (this.isJPQLCallQuery()) {
            string3 = "jpql=\"" + this.getJPQLString() + "\"";
        }
        return this.getClass().getSimpleName() + "(" + string2 + string + string3 + ")";
    }

    public String getDomainClassNounName(String string) {
        if (this.getProperty("DMSDomainClassNounName") == null) {
            StringBuffer stringBuffer = new StringBuffer("EclipseLink");
            if (string != null) {
                stringBuffer.append(string);
            }
            if (this.getReferenceClassName() != null) {
                stringBuffer.append("_");
                stringBuffer.append(this.getReferenceClassName());
            }
            this.setProperty("DMSDomainClassNounName", stringBuffer.toString());
        }
        return (String)this.getProperty("DMSDomainClassNounName");
    }

    public String getQueryNounName(String string) {
        if (this.getProperty("DMSQueryNounName") == null) {
            StringBuffer stringBuffer = new StringBuffer(this.getDomainClassNounName(string));
            stringBuffer.append("_");
            stringBuffer.append(this.getClass().getSimpleName());
            if (this.getName() != null) {
                stringBuffer.append("_");
                stringBuffer.append(this.getName());
            }
            this.setProperty("DMSQueryNounName", stringBuffer.toString());
        }
        return (String)this.getProperty("DMSQueryNounName");
    }

    public String getSensorName(String string, String string2) {
        Object object;
        if (string == null) {
            return this.getQueryNounName(string2);
        }
        Hashtable hashtable = (Hashtable)this.getProperty("DMSSensorNames");
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.setProperty("DMSSensorNames", hashtable);
        }
        if ((object = hashtable.get(string)) == null) {
            StringBuffer stringBuffer = new StringBuffer(this.getQueryNounName(string2));
            stringBuffer.append("_");
            stringBuffer.append(string);
            object = stringBuffer.toString();
            hashtable.put(string, object);
        }
        return (String)object;
    }

    public void setIsNativeConnectionRequired(boolean bl) {
        this.isNativeConnectionRequired = bl;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    public boolean getDoNotRedirect() {
        return this.doNotRedirect;
    }

    public void setDoNotRedirect(boolean bl) {
        this.doNotRedirect = bl;
    }
}

