/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.LockModeType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQueryResult;

public class ReportQuery
extends ReadAllQuery {
    public static final int ShouldReturnReportResult = 0;
    public static final int ShouldReturnSingleResult = 1;
    public static final int ShouldReturnSingleValue = 2;
    public static final int ShouldReturnSingleAttribute = 3;
    public static final int ShouldReturnWithoutReportQueryResult = 4;
    public static final int ShouldReturnArray = 5;
    public static final int FULL_PRIMARY_KEY = 2;
    public static final int FIRST_PRIMARY_KEY = 1;
    public static final int NO_PRIMARY_KEY = 0;
    protected static final Boolean RESULT_IGNORED = true;
    protected int shouldRetrievePrimaryKeys;
    protected Vector names;
    protected Vector items;
    protected Vector groupByExpressions;
    protected Expression havingExpression;
    protected int returnChoice;
    protected boolean addToConstructorItem;
    protected Class resultConstructorClass;
    protected Class[] constructorArgTypes;
    protected List constructorMappings;
    protected HashSet returnedKeys;

    public ReportQuery() {
        this.queryMechanism = new ExpressionQueryMechanism(this);
        this.items = NonSynchronizedVector.newInstance();
        this.shouldRetrievePrimaryKeys = 0;
        this.groupByExpressions = NonSynchronizedVector.newInstance(3);
        this.havingExpression = null;
        this.addToConstructorItem = false;
        this.setLockMode((short)0);
    }

    public ReportQuery(Class clazz, Expression expression) {
        this();
        this.defaultBuilder = expression.getBuilder();
        this.setReferenceClass(clazz);
        this.setSelectionCriteria(expression);
    }

    public ReportQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
        this.setReferenceClass(clazz);
    }

    public ReportQuery(ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
    }

    public void addAttribute(String string) {
        this.addItem(string, this.getExpressionBuilder().get(string));
    }

    public void addAttribute(String string, Expression expression) {
        this.addItem(string, expression);
    }

    public void addAttribute(String string, Expression expression, Class clazz) {
        this.addItem(string, expression, clazz);
    }

    public void addAverage(String string) {
        this.addAverage(string, this.getExpressionBuilder().get(string));
    }

    public void addAverage(String string, Class clazz) {
        this.addAverage(string, this.getExpressionBuilder().get(string), clazz);
    }

    public void addAverage(String string, Expression expression) {
        this.addItem(string, expression.average());
    }

    public void addAverage(String string, Expression expression, Class clazz) {
        this.addItem(string, expression.average(), clazz);
    }

    public void addConstructorReportItem(ConstructorReportItem constructorReportItem) {
        this.addItem(constructorReportItem);
    }

    public void addCount() {
        this.addCount("COUNT", this.getExpressionBuilder());
    }

    public void addCount(String string) {
        this.addCount(string, this.getExpressionBuilder().get(string));
    }

    public void addCount(String string, Class clazz) {
        this.addCount(string, this.getExpressionBuilder().get(string), clazz);
    }

    public void addCount(String string, Expression expression) {
        this.addItem(string, expression.count());
    }

    public void addCount(String string, Expression expression, Class clazz) {
        this.addItem(string, expression.count(), clazz);
    }

    public void addFunctionItem(String string, Expression expression, String string2) {
        Expression expression2 = expression;
        expression2 = expression.getFunction(string2);
        ReportItem reportItem = new ReportItem(string, expression2);
        this.addItem(reportItem);
        this.setIsPrepared(false);
    }

    public void addGrouping(String string) {
        this.addGrouping(this.getExpressionBuilder().get(string));
    }

    public void addGrouping(Expression expression) {
        this.getGroupByExpressions().addElement(expression);
        this.setIsPrepared(false);
    }

    public void setHavingExpression(Expression expression) {
        this.havingExpression = expression;
        this.setIsPrepared(false);
    }

    private void addItem(ReportItem reportItem) {
        if (this.addToConstructorItem && this.getItems().size() > 0 && ((ReportItem)this.getItems().lastElement()).isConstructorItem()) {
            ((ConstructorReportItem)this.getItems().lastElement()).addItem(reportItem);
        } else {
            this.getItems().addElement(reportItem);
        }
        this.setIsPrepared(false);
    }

    public void addItem(String string, Expression expression) {
        ReportItem reportItem = new ReportItem(string, expression);
        this.addItem(reportItem);
        this.setIsPrepared(false);
    }

    public void addItem(String string, Expression expression, List list) {
        ReportItem reportItem = new ReportItem(string, expression);
        reportItem.getJoinedAttributeManager().setJoinedAttributeExpressions_(list);
        this.addItem(reportItem);
    }

    protected void addItem(String string, Expression expression, Class clazz) {
        ReportItem reportItem = new ReportItem(string, expression);
        reportItem.setResultType(clazz);
        this.addItem(reportItem);
    }

    public void addMaximum(String string) {
        this.addMaximum(string, this.getExpressionBuilder().get(string));
    }

    public void addMaximum(String string, Expression expression) {
        this.addItem(string, expression.maximum());
    }

    public void addMinimum(String string) {
        this.addMinimum(string, this.getExpressionBuilder().get(string));
    }

    public void addMinimum(String string, Expression expression) {
        this.addItem(string, expression.minimum());
    }

    public void addStandardDeviation(String string) {
        this.addStandardDeviation(string, this.getExpressionBuilder().get(string));
    }

    public void addStandardDeviation(String string, Expression expression) {
        this.addItem(string, expression.standardDeviation());
    }

    public void addSum(String string) {
        this.addSum(string, this.getExpressionBuilder().get(string));
    }

    public void addSum(String string, Class clazz) {
        this.addSum(string, this.getExpressionBuilder().get(string), clazz);
    }

    public void addSum(String string, Expression expression) {
        this.addItem(string, expression.sum());
    }

    public void addSum(String string, Expression expression, Class clazz) {
        this.addItem(string, expression.sum(), clazz);
    }

    public void addVariance(String string) {
        this.addVariance(string, this.getExpressionBuilder().get(string));
    }

    public void addVariance(String string, Expression expression) {
        this.addItem(string, expression.variance());
    }

    public ConstructorReportItem beginAddingConstructorArguments(Class clazz) {
        ConstructorReportItem constructorReportItem = new ConstructorReportItem(clazz.getName());
        constructorReportItem.setResultType(clazz);
        this.getItems().add(constructorReportItem);
        this.setIsPrepared(false);
        this.addToConstructorItem = true;
        return constructorReportItem;
    }

    public ConstructorReportItem beginAddingConstructorArguments(Class clazz, Class[] classArray) {
        ConstructorReportItem constructorReportItem = this.beginAddingConstructorArguments(clazz);
        constructorReportItem.setConstructorArgTypes(classArray);
        return constructorReportItem;
    }

    public Object buildObject(AbstractRecord abstractRecord) {
        return this.buildObject(abstractRecord, null);
    }

    public Object buildObject(AbstractRecord abstractRecord, Vector vector) {
        ReportQueryResult reportQueryResult = new ReportQueryResult(this, abstractRecord, vector);
        if (this.returnedKeys != null) {
            if (this.returnedKeys.contains(reportQueryResult.getResultKey())) {
                return RESULT_IGNORED;
            }
            this.returnedKeys.add(reportQueryResult.getResultKey());
        }
        if (this.shouldReturnSingleAttribute()) {
            return reportQueryResult.getResults().get(0);
        }
        if (this.shouldReturnArray()) {
            return reportQueryResult.toArray();
        }
        if (this.shouldReturnWithoutReportQueryResult()) {
            if (reportQueryResult.size() == 1) {
                return reportQueryResult.getResults().get(0);
            }
            return reportQueryResult.toArray();
        }
        if (this.shouldReturnSingleValue()) {
            return reportQueryResult.getResults().get(0);
        }
        return reportQueryResult;
    }

    public Object buildObjects(Vector vector) {
        if (this.shouldReturnSingleResult() || this.shouldReturnSingleValue()) {
            if (vector.isEmpty()) {
                return null;
            }
            return this.buildObject((AbstractRecord)vector.get(0), vector);
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        int n = vector.size();
        Object object = containerPolicy.containerInstance(n);
        if (this.shouldDistinctBeUsed()) {
            this.returnedKeys = new HashSet(n);
        }
        for (int i = 0; i < n; ++i) {
            Object object2 = this.buildObject((AbstractRecord)vector.get(i), vector);
            if (object2 == RESULT_IGNORED) continue;
            containerPolicy.addInto(object2, object, this.session);
        }
        if (this.shouldCacheQueryResults()) {
            this.setTemporaryCachedQueryResults(object);
        }
        return object;
    }

    protected Object checkEarlyReturnImpl(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        if (this.shouldCheckCacheOnly()) {
            throw QueryException.cannotSetShouldCheckCacheOnlyOnReportQuery();
        }
        return null;
    }

    public Object clone() {
        ReportQuery reportQuery = (ReportQuery)super.clone();
        reportQuery.setItems(new Vector(this.getItems().size()));
        for (ReportItem reportItem : this.getItems()) {
            ReportItem reportItem2 = (ReportItem)reportItem.clone();
            if (reportItem.getJoinedAttributeManagerInternal() != null) {
                JoinedAttributeManager joinedAttributeManager = (JoinedAttributeManager)reportItem.getJoinedAttributeManager().clone();
                joinedAttributeManager.setBaseQuery(reportQuery);
                reportItem2.setJoinedAttributeManager(joinedAttributeManager);
            }
            reportQuery.addItem(reportItem2);
        }
        return reportQuery;
    }

    public void copyReportItems(Map map) {
        Cloneable cloneable;
        int n;
        this.items = (Vector)this.items.clone();
        for (n = this.items.size() - 1; n >= 0; --n) {
            cloneable = (ReportItem)this.items.elementAt(n);
            Expression expression = ((ReportItem)cloneable).getAttributeExpression();
            if (expression != null && map.get(expression.getBuilder()) != null) {
                expression = expression.copiedVersionFrom(map);
            }
            this.items.set(n, new ReportItem(((ReportItem)cloneable).getName(), expression));
        }
        if (this.groupByExpressions != null) {
            this.groupByExpressions = (Vector)this.groupByExpressions.clone();
            for (n = this.groupByExpressions.size() - 1; n >= 0; --n) {
                cloneable = (Expression)this.groupByExpressions.elementAt(n);
                if (map.get(((Expression)cloneable).getBuilder()) == null) continue;
                this.groupByExpressions.set(n, ((Expression)cloneable).copiedVersionFrom(map));
            }
        }
        if (this.orderByExpressions != null) {
            for (n = this.orderByExpressions.size() - 1; n >= 0; --n) {
                cloneable = (Expression)this.orderByExpressions.elementAt(n);
                if (map.get(((Expression)cloneable).getBuilder()) == null) continue;
                this.orderByExpressions.set(n, ((Expression)cloneable).copiedVersionFrom(map));
            }
        }
    }

    public void dontRetrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(false);
        this.setIsPrepared(false);
    }

    public void dontReturnSingleAttribute() {
        if (this.shouldReturnSingleAttribute()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleResult() {
        if (this.shouldReturnSingleResult()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleValue() {
        if (this.shouldReturnSingleValue()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnWithoutReportQueryResult() {
        if (this.shouldReturnWithoutReportQueryResult()) {
            this.returnChoice = 0;
        }
    }

    public void endAddingToConstructorItem() {
        this.addToConstructorItem = false;
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.isLockQuery() && this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWorkImpl.getCommitManager().isActive() && !unitOfWorkImpl.wasTransactionBegunPrematurely()) {
                unitOfWorkImpl.beginTransaction();
                unitOfWorkImpl.setWasTransactionBegunPrematurely(true);
            }
        }
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        this.setExecutionTime(System.currentTimeMillis());
        if (this.getDescriptor().isDescriptorForInterface()) {
            return this.getDescriptor().getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
        }
        return this.buildObjects(this.getQueryMechanism().selectAllReportQueryRows());
    }

    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public Vector getGroupByExpressions() {
        return this.groupByExpressions;
    }

    protected void setGroupByExpressions(Vector vector) {
        this.groupByExpressions = vector;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public Vector getQueryExpressions() {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getItems().size());
        if (this.shouldRetrieveFirstPrimaryKey() && !this.getDescriptor().getPrimaryKeyFields().isEmpty()) {
            ((Vector)nonSynchronizedVector).addElement(this.getDescriptor().getPrimaryKeyFields().get(0));
        }
        if (this.shouldRetrievePrimaryKeys()) {
            ((Vector)nonSynchronizedVector).addAll(this.getDescriptor().getPrimaryKeyFields());
        }
        return nonSynchronizedVector;
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReportQueryRedirector();
    }

    public Vector getItemExpressions() {
        Vector<Cloneable> vector = new Vector<Cloneable>(this.getItems().size());
        if (this.shouldRetrieveFirstPrimaryKey() && !this.getDescriptor().getPrimaryKeyFields().isEmpty()) {
            vector.addElement(this.getDescriptor().getPrimaryKeyFields().get(0));
        }
        if (this.shouldRetrievePrimaryKeys()) {
            vector.addAll(this.getDescriptor().getPrimaryKeyFields());
        }
        Enumeration enumeration = this.getItems().elements();
        while (enumeration.hasMoreElements()) {
            ReportItem reportItem = (ReportItem)enumeration.nextElement();
            Expression expression = reportItem.getAttributeExpression();
            if (expression == null) continue;
            vector.addElement(expression);
        }
        return vector;
    }

    public Vector getItems() {
        return this.items;
    }

    protected void setItems(Vector vector) {
        this.items = vector;
    }

    public boolean setLockModeType(LockModeType lockModeType, AbstractSession abstractSession) {
        if (lockModeType != null) {
            if (super.setLockModeType(lockModeType, abstractSession)) {
                return true;
            }
            if (!lockModeType.equals((Object)"PESSIMISTIC") && !lockModeType.equals((Object)"NONE")) {
                for (ReportItem reportItem : this.getItems()) {
                    OptimisticLockingPolicy optimisticLockingPolicy;
                    if (reportItem.getAttributeExpression() == null || !reportItem.getAttributeExpression().isExpressionBuilder() || (optimisticLockingPolicy = reportItem.getDescriptor().getOptimisticLockingPolicy()) != null && optimisticLockingPolicy instanceof VersionLockingPolicy) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearItems() {
        this.items = new Vector();
        this.setIsPrepared(false);
    }

    public Vector getNames() {
        if (this.names == null) {
            this.names = NonSynchronizedVector.newInstance();
            Enumeration enumeration = this.getItems().elements();
            while (enumeration.hasMoreElements()) {
                this.names.addElement(((ReportItem)enumeration.nextElement()).getName());
            }
        }
        return this.names;
    }

    protected void setNames(Vector vector) {
        this.names = vector;
    }

    public boolean isReportQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        if (this.prepareFromCachedQuery()) {
            return;
        }
        if (this.getItems().size() > 0) {
            try {
                Enumeration enumeration = this.getItems().elements();
                while (enumeration.hasMoreElements()) {
                    ((ReportItem)enumeration.nextElement()).initialize(this);
                }
            }
            catch (QueryException queryException) {
                queryException.setQuery(this);
                throw queryException;
            }
        } else if (!this.shouldRetrievePrimaryKeys() && !this.shouldRetrieveFirstPrimaryKey()) {
            throw QueryException.noAttributesForReportQuery(this);
        }
        super.prepare();
    }

    public void prepareFromQuery(DatabaseQuery databaseQuery) {
        super.prepareFromQuery(databaseQuery);
        if (databaseQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)databaseQuery;
            this.names = reportQuery.names;
            this.items = reportQuery.items;
            this.groupByExpressions = reportQuery.groupByExpressions;
            this.constructorArgTypes = reportQuery.constructorArgTypes;
            this.constructorMappings = reportQuery.constructorMappings;
            this.havingExpression = reportQuery.havingExpression;
            this.resultConstructorClass = reportQuery.resultConstructorClass;
            this.returnChoice = reportQuery.returnChoice;
            this.returnedKeys = reportQuery.returnedKeys;
            this.shouldRetrievePrimaryKeys = reportQuery.shouldRetrievePrimaryKeys;
        }
    }

    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && !this.hasBatchReadAttributes() && !this.hasHierarchicalExpressions() && !this.getContainerPolicy().isCursorPolicy();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReportQuery reportQuery = (ReportQuery)object;
        Vector vector = this.getItems();
        Vector vector2 = reportQuery.getItems();
        int n = vector.size();
        if (n != vector2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (vector.get(i).equals(vector2.get(i))) continue;
            return false;
        }
        Vector vector3 = this.getGroupByExpressions();
        Vector vector4 = reportQuery.getGroupByExpressions();
        n = vector3.size();
        if (n != vector4.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (vector3.get(i).equals(vector4.get(i))) continue;
            return false;
        }
        if (this.getHavingExpression() != reportQuery.getHavingExpression() && this.getHavingExpression() != null && !this.getHavingExpression().equals(reportQuery.getHavingExpression())) {
            return false;
        }
        if (this.resultConstructorClass != reportQuery.resultConstructorClass) {
            return false;
        }
        if (this.returnChoice != reportQuery.returnChoice) {
            return false;
        }
        return this.shouldRetrievePrimaryKeys == reportQuery.shouldRetrievePrimaryKeys;
    }

    protected void prepareObjectAttributeCount(Map map) {
        this.prepareObjectAttributeCount(this.getItems(), map);
    }

    private void prepareObjectAttributeCount(List list, Map map) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Expression expression;
            Cloneable cloneable;
            FunctionExpression functionExpression;
            ReportItem reportItem = (ReportItem)list.get(i);
            if (reportItem == null) continue;
            if (reportItem instanceof ConstructorReportItem) {
                this.prepareObjectAttributeCount(((ConstructorReportItem)reportItem).getReportItems(), map);
                continue;
            }
            if (!(reportItem.getAttributeExpression() instanceof FunctionExpression) || (functionExpression = (FunctionExpression)reportItem.getAttributeExpression()).getOperator().getSelector() != 19) continue;
            Expression expression2 = functionExpression.getBaseExpression();
            boolean bl = false;
            if (expression2.isFunctionExpression() && ((FunctionExpression)expression2).getOperator().getSelector() == 87) {
                bl = true;
                expression2 = ((FunctionExpression)expression2).getBaseExpression();
            }
            boolean bl2 = false;
            ClassDescriptor classDescriptor = null;
            if (expression2.isQueryKeyExpression()) {
                cloneable = this.getLeafMappingFor(expression2, this.getDescriptor());
                if (cloneable != null && !((DatabaseMapping)cloneable).isDirectToFieldMapping()) {
                    classDescriptor = ((DatabaseMapping)cloneable).getReferenceDescriptor();
                    bl2 = ((QueryKeyExpression)expression2).shouldUseOuterJoin();
                }
            } else if (expression2.isExpressionBuilder()) {
                classDescriptor = this.getSession().getDescriptor(((ExpressionBuilder)expression2).getQueryClass());
            }
            if (classDescriptor == null) continue;
            if (classDescriptor.hasSimplePrimaryKey() && classDescriptor.getPrimaryKeyFields().size() == 1) {
                cloneable = this.getMappingOfFirstPrimaryKey(classDescriptor);
                expression = expression2.get(((DatabaseMapping)cloneable).getAttributeName());
                if (bl) {
                    expression = expression.distinct();
                }
                functionExpression.setBaseExpression(expression);
                functionExpression.getChildren().setElementAt(expression, 0);
                continue;
            }
            if (!bl) {
                cloneable = this.getMappingOfFirstPrimaryKey(classDescriptor);
                expression = expression2.get(((DatabaseMapping)cloneable).getAttributeName());
                while (((DatabaseMapping)cloneable).isAggregateObjectMapping()) {
                    classDescriptor = ((AggregateObjectMapping)cloneable).getReferenceDescriptor();
                    cloneable = this.getMappingOfFirstPrimaryKey(classDescriptor);
                    expression = expression.get(((DatabaseMapping)cloneable).getAttributeName());
                }
                functionExpression.setBaseExpression(expression);
                functionExpression.getChildren().setElementAt(expression, 0);
                continue;
            }
            if (!bl2) {
                if (map != null) {
                    expression2 = map.get(expression2.getBuilder()) != null ? expression2.copiedVersionFrom(map) : expression2.rebuildOn(this.getExpressionBuilder());
                }
                cloneable = expression2.getBuilder();
                expression = new ExpressionBuilder();
                ReportQuery reportQuery = new ReportQuery(this.getReferenceClass(), (ExpressionBuilder)cloneable);
                reportQuery.setShouldRetrieveFirstPrimaryKey(true);
                if (this.getSelectionCriteria() != null) {
                    ((ExpressionBuilder)expression).setQueryClass(classDescriptor.getJavaClass());
                    reportQuery.setSelectionCriteria(expression2.equal(expression).and(this.getSelectionCriteria()));
                } else {
                    reportQuery.setSelectionCriteria(expression2.equal(expression));
                }
                this.setSelectionCriteria(expression.exists(reportQuery));
                functionExpression.setBaseExpression(expression);
                functionExpression.getChildren().setElementAt(expression, 0);
                this.setReferenceClass(classDescriptor.getJavaClass());
                this.changeDescriptor(this.getSession());
                continue;
            }
            throw QueryException.distinctCountOnOuterJoinedCompositePK(classDescriptor, this);
        }
    }

    private DatabaseMapping getMappingOfFirstPrimaryKey(ClassDescriptor classDescriptor) {
        if (classDescriptor != null) {
            for (DatabaseMapping databaseMapping : classDescriptor.getMappings()) {
                if (!databaseMapping.isPrimaryKeyMapping()) continue;
                return databaseMapping;
            }
        }
        return null;
    }

    protected void prepareSelectAllRows() {
        this.prepareObjectAttributeCount(null);
        this.getQueryMechanism().prepareReportQuerySelectAllRows();
    }

    public synchronized void prepareSubSelect(AbstractSession abstractSession, AbstractRecord abstractRecord, Map map) throws QueryException {
        if (this.isPrepared()) {
            return;
        }
        this.setIsPrepared(true);
        this.setSession(abstractSession);
        this.setTranslationRow(abstractRecord);
        this.checkDescriptor(this.getSession());
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        try {
            Enumeration enumeration = this.getItems().elements();
            while (enumeration.hasMoreElements()) {
                ((ReportItem)enumeration.nextElement()).initialize(this);
            }
        }
        catch (QueryException queryException) {
            queryException.setQuery(this);
            throw queryException;
        }
        this.prepareObjectAttributeCount(map);
        this.getQueryMechanism().prepareReportQuerySubSelect();
        this.setSession(null);
        this.setTranslationRow(null);
    }

    public void initializeFetchGroup() {
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    public void retrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(true);
        this.setIsPrepared(false);
    }

    public int getReturnType() {
        return this.returnChoice;
    }

    public void setReturnType(int n) {
        this.returnChoice = n;
    }

    public void returnSingleAttribute() {
        this.returnChoice = 3;
    }

    public void returnSingleResult() {
        this.returnChoice = 1;
    }

    public void returnSingleValue() {
        this.returnChoice = 2;
    }

    public void returnWithoutReportQueryResult() {
        this.returnChoice = 4;
    }

    public void setShouldRetrievePrimaryKeys(boolean bl) {
        this.shouldRetrievePrimaryKeys = bl ? 2 : 0;
    }

    public void setShouldRetrieveFirstPrimaryKey(boolean bl) {
        this.shouldRetrievePrimaryKeys = bl ? 1 : 0;
    }

    public void setShouldReturnSingleAttribute(boolean bl) {
        if (bl) {
            this.returnSingleAttribute();
        } else {
            this.dontReturnSingleAttribute();
        }
    }

    public void setShouldReturnSingleResult(boolean bl) {
        if (bl) {
            this.returnSingleResult();
        } else {
            this.dontReturnSingleResult();
        }
    }

    public void setShouldReturnSingleValue(boolean bl) {
        if (bl) {
            this.returnSingleValue();
        } else {
            this.dontReturnSingleValue();
        }
    }

    public void setShouldReturnWithoutReportQueryResult(boolean bl) {
        if (bl) {
            this.returnWithoutReportQueryResult();
        } else {
            this.dontReturnWithoutReportQueryResult();
        }
    }

    public boolean shouldRetrievePrimaryKeys() {
        return this.shouldRetrievePrimaryKeys == 2;
    }

    public boolean shouldRetrieveFirstPrimaryKey() {
        return this.shouldRetrievePrimaryKeys == 1;
    }

    public boolean shouldReturnSingleAttribute() {
        return this.returnChoice == 3;
    }

    public boolean shouldReturnSingleResult() {
        return this.returnChoice == 1;
    }

    public boolean shouldReturnSingleValue() {
        return this.returnChoice == 2;
    }

    public boolean shouldReturnWithoutReportQueryResult() {
        return this.returnChoice == 4;
    }

    public boolean shouldReturnArray() {
        return this.returnChoice == 5;
    }
}

