/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.io.StringWriter;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;

public class TableSequence
extends QuerySequence {
    public static final String defaultTableName = "SEQUENCE";
    protected DatabaseTable table;
    protected String counterFieldName = "SEQ_COUNT";
    protected String nameFieldName = "SEQ_NAME";
    protected String qualifier = "";

    public TableSequence() {
        super(false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String string) {
        super(string, false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String string, int n) {
        super(string, n, false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String string, int n, int n2) {
        super(string, n, n2, false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String string, String string2) {
        this(string);
        this.setTableName(string2);
    }

    public TableSequence(String string, String string2, String string3, String string4) {
        this(string);
        this.setTableName(string2);
        this.setNameFieldName(string3);
        this.setCounterFieldName(string4);
    }

    public TableSequence(String string, int n, String string2) {
        this(string, n);
        this.setTableName(string2);
    }

    public TableSequence(String string, int n, String string2, String string3, String string4) {
        this(string, n);
        this.setTableName(string2);
        this.setNameFieldName(string3);
        this.setCounterFieldName(string4);
    }

    public boolean isTable() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof TableSequence) {
            TableSequence tableSequence = (TableSequence)object;
            if (TableSequence.equalNameAndSize(this, tableSequence)) {
                return this.getTableName().equals(tableSequence.getTableName()) && this.getCounterFieldName().equals(tableSequence.getCounterFieldName()) && this.getNameFieldName().equals(tableSequence.getNameFieldName());
            }
            return false;
        }
        return false;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    public void setCounterFieldName(String string) {
        this.counterFieldName = string;
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String string) {
        this.nameFieldName = string;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.getTable().getQualifiedName();
    }

    public String getQualifiedTableName() {
        if (this.qualifier.equals("")) {
            return this.getTableName();
        }
        return this.qualifier + "." + this.getTableName();
    }

    public void setTable(DatabaseTable databaseTable) {
        this.table = databaseTable;
    }

    public void setTableName(String string) {
        this.table = new DatabaseTable(string);
    }

    protected ValueReadQuery buildSelectQuery() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.addArgument(this.getNameFieldName());
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT " + this.getCounterFieldName());
        stringWriter.write(" FROM " + this.getQualifiedTableName());
        stringWriter.write(" WHERE " + this.getNameFieldName());
        stringWriter.write(" = #" + this.getNameFieldName());
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    protected DataModifyQuery buildUpdateQuery() {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.addArgument(this.getNameFieldName());
        dataModifyQuery.addArgument("PREALLOC_SIZE");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("UPDATE " + this.getQualifiedTableName());
        stringWriter.write(" SET " + this.getCounterFieldName());
        stringWriter.write(" = " + this.getCounterFieldName());
        stringWriter.write(" + #PREALLOC_SIZE");
        stringWriter.write(" WHERE " + this.getNameFieldName() + " = #" + this.getNameFieldName());
        dataModifyQuery.setSQLString(stringWriter.toString());
        return dataModifyQuery;
    }

    public void onConnect() {
        this.qualifier = this.getDatasourcePlatform().getTableQualifier();
        super.onConnect();
    }

    public void onDisconnect() {
        super.onDisconnect();
        this.qualifier = "";
    }
}

