/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;

public class DevelopmentServices {
    protected Session session;

    public DevelopmentServices() {
    }

    public DevelopmentServices(Session session) {
        this.session = session;
    }

    public void initializeIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMap(clazz);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMaps();
    }

    public void setIdentityMapForClass(String string, String string2, int n) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        Class clazz2 = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                clazz2 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(string2));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getCause();
            }
        } else {
            clazz2 = PrivilegedAccessHelper.getClassForName(string2);
        }
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        classDescriptor.setIdentityMapClass(clazz2);
        classDescriptor.setIdentityMapSize(n);
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMap(clazz);
    }

    public void refreshProject(String string) {
        ((DatabaseSessionImpl)this.getSession()).logout();
        this.getSession().setProject(XMLProjectReader.read(string));
        ((DatabaseSessionImpl)this.getSession()).login();
    }

    public void updateCacheSize(String string, int n) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz).updateMaxSize(n);
    }

    public void setShouldBindAllParameters(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldBindAllParameters(bl);
    }

    public boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public void setStringBindingSize(int n) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStringBindingSize(n);
    }

    public int getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize();
    }

    public void setUsesBatchWriting(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesBatchWriting(bl);
    }

    public boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public void setUsesJDBCBatchWriting(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesJDBCBatchWriting(bl);
    }

    public boolean getUsesJDBCBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public void setUsesByteArrayBinding(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesByteArrayBinding(bl);
    }

    public boolean getUsesByteArrayBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public void setUsesNativeSQL(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesNativeSQL(bl);
    }

    public boolean getUsesNativeSQL() {
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public void setUsesStreamsForBinding(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesStreamsForBinding(bl);
    }

    public boolean getUsesStreamsForBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public void setUsesStringBinding(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesStringBinding(bl);
    }

    public boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding();
    }

    protected AbstractSession getSession() {
        return (AbstractSession)this.session;
    }
}

