/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi.actions;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.spi.exceptions.ClientExecuteException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;

public class ClientConfigurationImpl
implements ClientConfiguration {
    TargetModuleIDImpl targetModuleID;
    String originalArchivePath;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientConfigurationImpl.class);

    public ClientConfigurationImpl(TargetModuleIDImpl targetModuleID) {
        this.targetModuleID = targetModuleID;
    }

    public void execute() throws ClientExecuteException {
        if (this.targetModuleID == null) {
            throw new ClientExecuteException(localStrings.getLocalString("enterprise.deployapi.actions.clientconfigurationimpl.nomoduleid", "No moduleID for deployed application found"));
        }
        TargetImpl target = (TargetImpl)this.targetModuleID.getTarget();
        String moduleID = this.targetModuleID.getParentTargetModuleID() != null ? this.targetModuleID.getParentTargetModuleID().getModuleID() : this.targetModuleID.getModuleID();
        try {
            String location = target.exportClientStubs(moduleID, System.getProperty("java.io.tmpdir"));
            String id = this.targetModuleID.getModuleID();
            if (id.indexOf(35) != -1) {
                id = id.substring(id.indexOf(35) + 1);
            }
            String j2eeHome = System.getProperty("com.sun.aas.installRoot");
            String appClientBinary = j2eeHome + File.separatorChar + "bin" + File.separatorChar + "appclient";
            String command = appClientBinary + " -client " + location;
            Process p = Runtime.getRuntime().exec(command);
            InputStream is = p.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClientExecuteException(localStrings.getLocalString("enterprise.deployapi.actions.clientconfigurationimpl.exception", "Exception while invoking application client : \n {0}", new Object[]{e.getMessage()}));
        }
    }
}

