/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.util.ArrayList;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AMXStartupServiceNewMBean;
import org.glassfish.admin.mbeanserver.BooterNewMBean;
import org.glassfish.admin.mbeanserver.Util;
import org.jvnet.hk2.component.Habitat;

final class BooterNew
implements BooterNewMBean {
    private final MBeanServer mMBeanServer;
    private final ObjectName mObjectName;
    private final Habitat mHabitat;
    private ObjectName mDomainRootObjectName;

    private static void debug(String s) {
        System.out.println(s);
    }

    private BooterNew(Habitat habitat, MBeanServer mbeanServer) {
        this.mHabitat = habitat;
        this.mMBeanServer = mbeanServer;
        this.mObjectName = BooterNewMBean.OBJECT_NAME;
        this.mDomainRootObjectName = null;
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException();
        }
    }

    public static synchronized BooterNew create(Habitat habitat, MBeanServer server) {
        BooterNew booter = new BooterNew(habitat, server);
        ObjectName objectName = OBJECT_NAME;
        try {
            if (!server.registerMBean(booter, objectName).getObjectName().equals(objectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
        return booter;
    }

    public synchronized ObjectName bootAMX() {
        if (this.mDomainRootObjectName == null) {
            AMXStartupServiceNewMBean loader = null;
            try {
                loader = (AMXStartupServiceNewMBean)this.mHabitat.getByContract(AMXStartupServiceNewMBean.class);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException(t);
            }
            BooterNew.debug("Got loader for AMXStartupServiceNewMBean: " + loader);
            ObjectName startupON = AMXStartupServiceNewMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                BooterNew.debug("BooterNew.bootAMX(): AMX MBean not yet available: " + startupON);
                throw new IllegalStateException("AMX MBean not yet available: " + startupON);
            }
            try {
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "loadAMXMBeans", null, null);
            }
            catch (JMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        ObjectName queryPattern = Util.newObjectName("jmxremote:type=jmx-connector,*");
        Set<ObjectName> objectNames = this.mMBeanServer.queryNames(queryPattern, null);
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        for (ObjectName objectName : objectNames) {
            try {
                urls.add((JMXServiceURL)this.mMBeanServer.getAttribute(objectName, "Address"));
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new JMXServiceURL[urls.size()]);
    }
}

