/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import org.glassfish.api.container.CompositeSniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.persistence.jpa.JPASniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jpaCompositeSniffer")
@Scoped(value=Singleton.class)
public class JPACompositeSniffer
extends JPASniffer
implements CompositeSniffer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handles(DeploymentContext context) {
        List<File> listofJars = this.getListOfJars(context);
        for (File jar : listofJars) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jar);
                if (jarFile.getEntry("META-INF/persistence.xml") == null) continue;
                boolean bl = true;
                return bl;
            }
            catch (IOException ioe) {}
            continue;
            finally {
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private List<File> getListOfJars(DeploymentContext context) {
        ArrayList<File> topLevelJars = new ArrayList<File>();
        ReadableArchive source = context.getSource();
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder != null && holder.app != null) {
            File file = new File(source.getURI());
            for (File f : file.listFiles()) {
                if (f.isDirectory() || !f.getName().endsWith(".jar") || JPACompositeSniffer.isComponentJar(f, holder.app.getModules())) continue;
                topLevelJars.add(f);
            }
        }
        return topLevelJars;
    }

    private static boolean isComponentJar(File jar, Set<ModuleDescriptor<BundleDescriptor>> moduleDescriptors) {
        boolean isComponentJar = false;
        for (ModuleDescriptor<BundleDescriptor> md : moduleDescriptors) {
            String archiveUri = md.getArchiveUri();
            if (!jar.getName().equals(archiveUri)) continue;
            isComponentJar = true;
            break;
        }
        return isComponentJar;
    }
}

