/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jpaSniffer")
@Scoped(value=Singleton.class)
public class JPASniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] containers = new String[]{"org.glassfish.persistence.jpa.JPAContainer"};
    private static char SEPERATOR_CHAR = (char)47;
    private static final String WEB_INF = "WEB-INF";
    private static final String LIB = "lib";
    private static final String WEB_INF_LIb = "WEB-INF" + SEPERATOR_CHAR + "lib";
    private static final String WEB_INF_CLASSSES = "WEB-INF" + SEPERATOR_CHAR + "classes";
    private static final String META_INF_PERSISTENCE_XML = "META-INF" + SEPERATOR_CHAR + "persistence.xml";
    private static final String WEB_INF_CLASSSES_META_INF_PERSISTENCE_XML = WEB_INF_CLASSSES + SEPERATOR_CHAR + META_INF_PERSISTENCE_XML;
    private static final String JAR_SUFFIX = ".jar";

    public JPASniffer() {
        super("jpa", null, null);
    }

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        boolean isJPAArchive = false;
        if (this.isEntryPresent(location, WEB_INF)) {
            isJPAArchive = this.isEntryPresent(location, WEB_INF_CLASSSES_META_INF_PERSISTENCE_XML);
            if (!isJPAArchive && this.isEntryPresent(location, WEB_INF_LIb)) {
                Enumeration entries = location.entries(WEB_INF_LIb);
                isJPAArchive = this.scanForPURootsInLibDir(location, entries);
            }
        } else {
            isJPAArchive = this.isEntryPresent(location, META_INF_PERSISTENCE_XML);
            if (this.isEntryPresent(location, LIB)) {
                Enumeration entries = location.entries(LIB);
                isJPAArchive = this.scanForPURootsInLibDir(location, entries);
            }
        }
        return isJPAArchive;
    }

    private boolean scanForPURootsInLibDir(ReadableArchive parentArchive, Enumeration<String> entries) {
        boolean puRootPresent = false;
        while (entries.hasMoreElements() && !puRootPresent) {
            String entryName = entries.nextElement();
            if (!entryName.endsWith(JAR_SUFFIX) || entryName.indexOf(SEPERATOR_CHAR, WEB_INF_LIb.length() + 1) != -1) continue;
            try {
                ReadableArchive jarInLib = parentArchive.getSubArchive(entryName);
                puRootPresent = this.isEntryPresent(jarInLib, META_INF_PERSISTENCE_XML);
                jarInLib.close();
            }
            catch (IOException e) {}
        }
        return puRootPresent;
    }

    private boolean isEntryPresent(ReadableArchive location, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = location.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    public String[] getContainersNames() {
        return containers;
    }
}

