/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.tcp.PendingIOhandler;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorHandlerRunner
implements Runnable {
    private final SelectorHandler selectorHandler;
    private final Controller controller;

    public SelectorHandlerRunner(Controller controller, SelectorHandler selectorHandler) {
        this.controller = controller;
        this.selectorHandler = selectorHandler;
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ((WorkerThreadImpl)Thread.currentThread()).setPendingIOhandler((PendingIOhandler)this.selectorHandler);
        NIOContext serverCtx = this.controller.pollContext(null, null);
        serverCtx.setSelectorHandler(this.selectorHandler);
        StateHolder<State> controllerStateHolder = this.controller.getStateHolder();
        StateHolder selectorHandlerStateHolder = this.selectorHandler.getStateHolder();
        try {
            State selectorHandlerState;
            State controllerState;
            this.selectorHandler.getStateHolder().setState((Object)State.STARTED);
            while ((controllerState = (State)controllerStateHolder.getState(false)) != State.STOPPED && (selectorHandlerState = (State)selectorHandlerStateHolder.getState(false)) != State.STOPPED) {
                if (controllerState != State.PAUSED && selectorHandlerState != State.PAUSED) {
                    this.controller.doSelect(this.selectorHandler, serverCtx);
                    continue;
                }
                this.doSelectorPaused(controllerState, selectorHandlerState);
            }
            Object var7_6 = null;
            this.selectorHandler.shutdown();
            this.controller.notifyStopped();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.selectorHandler.shutdown();
            this.controller.notifyStopped();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSelectorPaused(State controllerState, State selectorHandlerState) {
        CountDownLatch latch = new CountDownLatch(1);
        StateHolder.ConditionListener<State> controllerConditionListener = this.registerForNotification(controllerState, this.controller.getStateHolder(), latch);
        StateHolder.ConditionListener<State> selectorHandlerConditionListener = this.registerForNotification(selectorHandlerState, (StateHolder<State>)this.selectorHandler.getStateHolder(), latch);
        try {
            try {
                latch.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Object var8_7 = null;
                this.controller.getStateHolder().removeConditionListener(controllerConditionListener);
                this.selectorHandler.getStateHolder().removeConditionListener(selectorHandlerConditionListener);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.controller.getStateHolder().removeConditionListener(controllerConditionListener);
            this.selectorHandler.getStateHolder().removeConditionListener(selectorHandlerConditionListener);
            throw throwable;
        }
        this.controller.getStateHolder().removeConditionListener(controllerConditionListener);
        this.selectorHandler.getStateHolder().removeConditionListener(selectorHandlerConditionListener);
    }

    private StateHolder.ConditionListener<State> registerForNotification(State currentState, StateHolder<State> stateHolder, CountDownLatch latch) {
        if (currentState == State.PAUSED) {
            return stateHolder.notifyWhenStateIsNotEqual((Object)State.PAUSED, (Object)latch);
        }
        return stateHolder.notifyWhenStateIsEqual((Object)State.STOPPED, (Object)latch);
    }
}

