/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.glassfish.web.loader.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainerInitializerUtil {
    private static Logger log = LogDomains.getLogger(ServletContainerInitializerUtil.class, (String)"javax.enterprise.system.container.web");
    private static final StringManager sm = StringManager.getManager(ServletContainerInitializerUtil.class.getPackage().getName());

    public static Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> getInterestList(ClassLoader cl) {
        ServiceLoader<ServletContainerInitializer> frameworks = ServiceLoader.load(ServletContainerInitializer.class, cl);
        HashMap interestList = null;
        for (ServletContainerInitializer sc : frameworks) {
            HandlesTypes ann;
            if (interestList == null) {
                interestList = new HashMap();
            }
            if ((ann = sc.getClass().getAnnotation(HandlesTypes.class)) == null) {
                ArrayList currentInitializerList = (ArrayList)interestList.get(ServletContainerInitializerUtil.class);
                if (currentInitializerList == null) {
                    ArrayList arr = new ArrayList();
                    arr.add(sc.getClass());
                    interestList.put(ServletContainerInitializerUtil.class, arr);
                    continue;
                }
                currentInitializerList.add(sc.getClass());
                continue;
            }
            Class[] interestedClasses = ann.value();
            if (interestedClasses == null || interestedClasses.length == 0) continue;
            for (Class c : interestedClasses) {
                ArrayList currentInitializerList = (ArrayList)interestList.get(c);
                if (currentInitializerList == null) {
                    ArrayList arr = new ArrayList();
                    arr.add(sc.getClass());
                    interestList.put(c, arr);
                    continue;
                }
                currentInitializerList.add(sc.getClass());
            }
        }
        return interestList;
    }

    public static Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> getInitializerList(Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList, ClassLoader cl) {
        if (interestList == null) {
            return null;
        }
        Map<Class<ServletContainerInitializer>, HashSet<Class<?>>> initializerList = null;
        if (interestList.containsKey(ServletContainerInitializerUtil.class)) {
            initializerList = new HashMap();
            ArrayList<Class<? extends ServletContainerInitializer>> initializersWithoutHandleTypes = interestList.get(ServletContainerInitializerUtil.class);
            for (Class<? extends ServletContainerInitializer> c : initializersWithoutHandleTypes) {
                initializerList.put(c, null);
            }
        }
        if (interestList.keySet().size() > 1 || interestList.keySet().size() == 1 && !interestList.containsKey(ServletContainerInitializerUtil.class)) {
            for (URL u : ((URLClassLoader)cl).getURLs()) {
                String path = u.getPath();
                try {
                    if (path.endsWith(".jar")) {
                        JarFile jf = new JarFile(path);
                        Enumeration<JarEntry> entries = jf.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry anEntry = entries.nextElement();
                            if (anEntry.isDirectory() || !anEntry.getName().endsWith(".class")) continue;
                            try {
                                String className = anEntry.getName().replace('/', '.');
                                className = className.substring(0, className.length() - 6);
                                Class<?> aClass = cl.loadClass(className);
                                initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(aClass, interestList, initializerList);
                            }
                            catch (ClassNotFoundException e) {
                                log.warning(sm.getString("ServletContainerInitializerUtil.CNFWarning", anEntry.getName()));
                            }
                        }
                        continue;
                    }
                    File file = new File(path);
                    if (file.isDirectory()) {
                        initializerList = ServletContainerInitializerUtil.scanDirectory(file, path, cl, interestList, initializerList);
                        continue;
                    }
                    log.warning(sm.getString("ServletContainerInitializerUtil.UnkownFileWarning", path));
                }
                catch (IOException ioex) {
                    log.severe(sm.getString("ServletContainerInitializerUtil.IOerror", ioex.getLocalizedMessage()));
                    return null;
                }
            }
        }
        return initializerList;
    }

    private static String getClassNameFromPath(String fullPath, String path) {
        String className = fullPath.substring(path.length());
        className = className.replace(File.separatorChar, '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private static Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> scanDirectory(File dir, String path, ClassLoader cl, Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> initializerList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                try {
                    Class<?> aClass = cl.loadClass(ServletContainerInitializerUtil.getClassNameFromPath(fileName, path));
                    initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(aClass, interestList, initializerList);
                }
                catch (ClassNotFoundException e) {
                    log.warning(sm.getString("ServletContainerInitializerUtil.CNFWarning", fileName));
                }
                continue;
            }
            initializerList = ServletContainerInitializerUtil.scanDirectory(file, path, cl, interestList, initializerList);
        }
        return initializerList;
    }

    private static Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> checkAgainstInterestList(Class aClass, Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> initializerList) {
        for (Class<?> c : interestList.keySet()) {
            if (aClass.getAnnotation(c) == null && !c.isAssignableFrom(aClass)) continue;
            if (initializerList == null) {
                initializerList = new HashMap();
            }
            ArrayList<Class<? extends ServletContainerInitializer>> containerInitializers = interestList.get(c);
            for (Class<? extends ServletContainerInitializer> initializer : containerInitializers) {
                HashSet<Class<Object>> classSet = initializerList.get(initializer);
                if (classSet == null) {
                    classSet = new HashSet();
                }
                classSet.add(aClass);
                initializerList.put(initializer, classSet);
            }
        }
        return initializerList;
    }
}

