/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.ReuseFactory;

public class CompilerContextImpl
extends ContextImpl
implements CompilerContext {
    private final Parser parser;
    private final LanguageConnectionContext lcc;
    private final LanguageConnectionFactory lcf;
    private TypeCompilerFactory typeCompilerFactory;
    private Dependent currentDependent;
    private DependencyManager dm;
    private boolean firstOnStack;
    private boolean inUse;
    private int reliability = 1024;
    private int nextColumnNumber = 1;
    private int nextTableNumber;
    private int nextSubqueryNumber;
    private int nextResultSetNumber;
    private int scanIsolationLevel;
    private int nextEquivalenceClass = -1;
    private long nextClassName;
    private Vector savedObjects;
    private String classPrefix;
    private SchemaDescriptor compilationSchema;
    private ProviderList currentAPL;
    private boolean returnParameterFlag;
    private Vector storeCostControllers = new Vector();
    private Vector storeCostConglomIds = new Vector();
    private SortCostController sortCostController;
    private Vector parameterList;
    private DataTypeDescriptor[] parameterDescriptors;
    private Object cursorInfo;
    private SQLWarning warnings;
    private Stack privTypeStack = new Stack();
    private int currPrivType = -1;
    private HashMap requiredColumnPrivileges;
    private HashMap requiredTablePrivileges;
    private HashMap requiredSchemaPrivileges;
    private HashMap requiredRoutinePrivileges;
    private HashMap requiredRolePrivileges;

    public void cleanupOnError(Throwable throwable) throws StandardException {
        this.setInUse(false);
        this.resetContext();
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            int n = standardException.getSeverity();
            if (n < 50000) {
                if (this.currentDependent != null) {
                    this.currentDependent.makeInvalid(0, this.lcc);
                }
                this.closeStoreCostControllers();
                this.closeSortCostControllers();
            }
            if (n >= 40000) {
                this.popMe();
            }
        }
    }

    public void resetContext() {
        this.nextColumnNumber = 1;
        this.nextTableNumber = 0;
        this.nextSubqueryNumber = 0;
        this.resetNextResultSetNumber();
        this.nextEquivalenceClass = -1;
        this.compilationSchema = null;
        this.parameterList = null;
        this.parameterDescriptors = null;
        this.scanIsolationLevel = 0;
        this.warnings = null;
        this.savedObjects = null;
        this.reliability = 1024;
        this.returnParameterFlag = false;
        this.initRequiredPriv();
    }

    public Parser getParser() {
        return this.parser;
    }

    public NodeFactory getNodeFactory() {
        return this.lcf.getNodeFactory();
    }

    public int getNextColumnNumber() {
        return this.nextColumnNumber++;
    }

    public int getNextTableNumber() {
        return this.nextTableNumber++;
    }

    public int getNumTables() {
        return this.nextTableNumber;
    }

    public int getNextSubqueryNumber() {
        return this.nextSubqueryNumber++;
    }

    public int getNumSubquerys() {
        return this.nextSubqueryNumber;
    }

    public int getNextResultSetNumber() {
        return this.nextResultSetNumber++;
    }

    public void resetNextResultSetNumber() {
        this.nextResultSetNumber = 0;
    }

    public int getNumResultSets() {
        return this.nextResultSetNumber;
    }

    public String getUniqueClassName() {
        return this.classPrefix.concat(Long.toHexString(this.nextClassName++));
    }

    public int getNextEquivalenceClass() {
        return ++this.nextEquivalenceClass;
    }

    public ClassFactory getClassFactory() {
        return this.lcf.getClassFactory();
    }

    public JavaFactory getJavaFactory() {
        return this.lcf.getJavaFactory();
    }

    public void setCurrentDependent(Dependent dependent) {
        this.currentDependent = dependent;
    }

    public ProviderList getCurrentAuxiliaryProviderList() {
        return this.currentAPL;
    }

    public void setCurrentAuxiliaryProviderList(ProviderList providerList) {
        this.currentAPL = providerList;
    }

    public void createDependency(Provider provider) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(this.currentDependent, provider, this.getContextManager());
        this.addProviderToAuxiliaryList(provider);
    }

    public void createDependency(Dependent dependent, Provider provider) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(dependent, provider, this.getContextManager());
        this.addProviderToAuxiliaryList(provider);
    }

    private void addProviderToAuxiliaryList(Provider provider) {
        if (this.currentAPL != null) {
            this.currentAPL.addProvider(provider);
        }
    }

    public int addSavedObject(Object object) {
        if (this.savedObjects == null) {
            this.savedObjects = new Vector();
        }
        this.savedObjects.addElement(object);
        return this.savedObjects.size() - 1;
    }

    public Object[] getSavedObjects() {
        if (this.savedObjects == null) {
            return null;
        }
        Object[] objectArray = new Object[this.savedObjects.size()];
        this.savedObjects.copyInto(objectArray);
        this.savedObjects = null;
        return objectArray;
    }

    public void setSavedObjects(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.addSavedObject(objectArray[i]);
        }
    }

    public void setCursorInfo(Object object) {
        this.cursorInfo = object;
    }

    public Object getCursorInfo() {
        return this.cursorInfo;
    }

    public void firstOnStack() {
        this.firstOnStack = true;
    }

    public boolean isFirstOnStack() {
        return this.firstOnStack;
    }

    public void setInUse(boolean bl) {
        this.inUse = bl;
        if (!bl) {
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public void setReliability(int n) {
        this.reliability = n;
    }

    public int getReliability() {
        return this.reliability;
    }

    public StoreCostController getStoreCostController(long l) throws StandardException {
        for (int i = 0; i < this.storeCostConglomIds.size(); ++i) {
            Long l2 = (Long)this.storeCostConglomIds.elementAt(i);
            if (l2 != l) continue;
            return (StoreCostController)this.storeCostControllers.elementAt(i);
        }
        StoreCostController storeCostController = this.lcc.getTransactionCompile().openStoreCost(l);
        this.storeCostControllers.insertElementAt(storeCostController, this.storeCostControllers.size());
        this.storeCostConglomIds.insertElementAt(new Long(l), this.storeCostConglomIds.size());
        return storeCostController;
    }

    private void closeStoreCostControllers() {
        for (int i = 0; i < this.storeCostControllers.size(); ++i) {
            StoreCostController storeCostController = (StoreCostController)this.storeCostControllers.elementAt(i);
            try {
                storeCostController.close();
                continue;
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.storeCostControllers.removeAllElements();
        this.storeCostConglomIds.removeAllElements();
    }

    public SortCostController getSortCostController() throws StandardException {
        if (this.sortCostController == null) {
            this.sortCostController = this.lcc.getTransactionCompile().openSortCostController(null);
        }
        return this.sortCostController;
    }

    private void closeSortCostControllers() {
        if (this.sortCostController != null) {
            this.sortCostController.close();
            this.sortCostController = null;
        }
    }

    public SchemaDescriptor getCompilationSchema() {
        return this.compilationSchema;
    }

    public SchemaDescriptor setCompilationSchema(SchemaDescriptor schemaDescriptor) {
        SchemaDescriptor schemaDescriptor2 = this.compilationSchema;
        this.compilationSchema = schemaDescriptor;
        return schemaDescriptor2;
    }

    public void setParameterList(Vector vector) {
        int n;
        this.parameterList = vector;
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            this.parameterDescriptors = new DataTypeDescriptor[n];
        }
    }

    public Vector getParameterList() {
        return this.parameterList;
    }

    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    public boolean getReturnParameterFlag() {
        return this.returnParameterFlag;
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.parameterDescriptors;
    }

    public void setScanIsolationLevel(int n) {
        this.scanIsolationLevel = n;
    }

    public int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.typeCompilerFactory;
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public CompilerContextImpl(ContextManager contextManager, LanguageConnectionContext languageConnectionContext, TypeCompilerFactory typeCompilerFactory) {
        super(contextManager, "CompilerContext");
        this.lcc = languageConnectionContext;
        this.lcf = languageConnectionContext.getLanguageConnectionFactory();
        this.parser = this.lcf.newParser(this);
        this.typeCompilerFactory = typeCompilerFactory;
        this.classPrefix = "ac" + this.lcf.getUUIDFactory().createUUID().toString().replace('-', 'x');
        this.initRequiredPriv();
    }

    private void initRequiredPriv() {
        this.currPrivType = -1;
        this.privTypeStack.clear();
        this.requiredColumnPrivileges = null;
        this.requiredTablePrivileges = null;
        this.requiredSchemaPrivileges = null;
        this.requiredRoutinePrivileges = null;
        this.requiredRolePrivileges = null;
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        if (languageConnectionContext.usesSqlAuthorization()) {
            this.requiredColumnPrivileges = new HashMap();
            this.requiredTablePrivileges = new HashMap();
            this.requiredSchemaPrivileges = new HashMap();
            this.requiredRoutinePrivileges = new HashMap();
            this.requiredRolePrivileges = new HashMap();
        }
    }

    public void pushCurrentPrivType(int n) {
        this.privTypeStack.push(ReuseFactory.getInteger(this.currPrivType));
        this.currPrivType = n;
    }

    public void popCurrentPrivType() {
        this.currPrivType = (Integer)this.privTypeStack.pop();
    }

    public void addRequiredColumnPriv(ColumnDescriptor columnDescriptor) {
        if (this.requiredColumnPrivileges == null || this.currPrivType == -1 || this.currPrivType == 4 || this.currPrivType == 3 || this.currPrivType == 5 || this.currPrivType == 6 || columnDescriptor == null) {
            return;
        }
        TableDescriptor tableDescriptor = columnDescriptor.getTableDescriptor();
        if (tableDescriptor == null) {
            return;
        }
        UUID uUID = tableDescriptor.getUUID();
        StatementTablePermission statementTablePermission = new StatementTablePermission(uUID, this.currPrivType);
        StatementColumnPermission statementColumnPermission = (StatementColumnPermission)this.requiredColumnPrivileges.get(statementTablePermission);
        if (statementColumnPermission == null) {
            statementColumnPermission = new StatementColumnPermission(uUID, this.currPrivType, new FormatableBitSet(tableDescriptor.getNumberOfColumns()));
            this.requiredColumnPrivileges.put(statementTablePermission, statementColumnPermission);
        }
        statementColumnPermission.getColumns().set(columnDescriptor.getPosition() - 1);
    }

    public void addRequiredTablePriv(TableDescriptor tableDescriptor) {
        if (this.requiredTablePrivileges == null || tableDescriptor == null) {
            return;
        }
        StatementTablePermission statementTablePermission = new StatementTablePermission(tableDescriptor.getUUID(), this.currPrivType);
        this.requiredTablePrivileges.put(statementTablePermission, statementTablePermission);
    }

    public void addRequiredRoutinePriv(AliasDescriptor aliasDescriptor) {
        if (this.requiredRoutinePrivileges == null || aliasDescriptor == null) {
            return;
        }
        if (aliasDescriptor.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30")) {
            return;
        }
        if (this.requiredRoutinePrivileges.get(aliasDescriptor.getUUID()) == null) {
            this.requiredRoutinePrivileges.put(aliasDescriptor.getUUID(), ReuseFactory.getInteger(1));
        }
    }

    public void addRequiredSchemaPriv(String string, String string2, int n) {
        if (this.requiredSchemaPrivileges == null || string == null) {
            return;
        }
        StatementSchemaPermission statementSchemaPermission = new StatementSchemaPermission(string, string2, n);
        this.requiredSchemaPrivileges.put(statementSchemaPermission, statementSchemaPermission);
    }

    public void addRequiredRolePriv(String string, int n) {
        if (this.requiredRolePrivileges == null) {
            return;
        }
        StatementRolePermission statementRolePermission = new StatementRolePermission(string, n);
        this.requiredRolePrivileges.put(statementRolePermission, statementRolePermission);
    }

    public List getRequiredPermissionsList() {
        Iterator<Object> iterator;
        int n = 0;
        if (this.requiredRoutinePrivileges != null) {
            n += this.requiredRoutinePrivileges.size();
        }
        if (this.requiredTablePrivileges != null) {
            n += this.requiredTablePrivileges.size();
        }
        if (this.requiredSchemaPrivileges != null) {
            n += this.requiredSchemaPrivileges.size();
        }
        if (this.requiredColumnPrivileges != null) {
            n += this.requiredColumnPrivileges.size();
        }
        if (this.requiredRolePrivileges != null) {
            n += this.requiredRolePrivileges.size();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        if (this.requiredRoutinePrivileges != null) {
            iterator = this.requiredRoutinePrivileges.keySet().iterator();
            while (iterator.hasNext()) {
                UUID uUID = (UUID)iterator.next();
                arrayList.add(new StatementRoutinePermission(uUID));
            }
        }
        if (this.requiredTablePrivileges != null) {
            iterator = this.requiredTablePrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (this.requiredSchemaPrivileges != null) {
            iterator = this.requiredSchemaPrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (this.requiredColumnPrivileges != null) {
            iterator = this.requiredColumnPrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (this.requiredRolePrivileges != null) {
            iterator = this.requiredRolePrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }
}

