/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http.listener")
public class DeleteHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHttpListener.class);
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Param(name="secure", optional=true)
    String secure;
    @Inject
    HttpService httpService;
    @Inject
    NetworkConfig networkConfig;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.exists()) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.notexists", "{0} doesn't exist", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            NetworkListener ls = this.networkConfig.getNetworkListener(this.listenerId);
            VirtualServer vs = this.httpService.getVirtualServerByName(ls.findProtocol().getHttp().getDefaultVirtualServer());
            ConfigSupport.apply((SingleConfigCode)new Config(), (ConfigBeanProxy)this.networkConfig.getNetworkListeners());
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer avs) throws PropertyVetoException {
                    String lss = avs.getNetworkListeners();
                    if (lss != null && lss.contains(DeleteHttpListener.this.listenerId)) {
                        Pattern p = Pattern.compile(",");
                        String[] names = p.split(lss);
                        ArrayList<String> nl = new ArrayList<String>();
                        for (String name : names) {
                            if (DeleteHttpListener.this.listenerId.equals(name)) continue;
                            nl.add(name);
                        }
                        lss = ((Object)nl).toString();
                        lss = lss.substring(1, lss.length() - 1);
                        avs.setNetworkListeners(lss);
                    }
                    return avs;
                }
            }, (ConfigBeanProxy)vs);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.fail", "failed", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean exists() {
        return this.networkConfig.getNetworkListener(this.listenerId) != null;
    }

    private void cleanUp(NetworkListener listener) throws TransactionFailure {
        final Protocol protocol = listener.findProtocol();
        boolean found = false;
        for (NetworkListener candidate : ((NetworkListeners)listener.getParent(NetworkListeners.class)).getNetworkListener()) {
            found |= !listener.getName().equals(candidate.getName()) && candidate.getProtocol().equals(protocol.getName());
        }
        if (!found) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws PropertyVetoException, TransactionFailure {
                    ArrayList list = new ArrayList(param.getProtocol());
                    for (Protocol old : list) {
                        if (!protocol.getName().equals(old.getName())) continue;
                        list.remove(old);
                        break;
                    }
                    param.getProtocol().clear();
                    param.getProtocol().addAll(list);
                    return null;
                }
            }, (ConfigBeanProxy)protocol.getParent(Protocols.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Config
    implements SingleConfigCode<NetworkListeners> {
        private Config() {
        }

        public Object run(NetworkListeners param) throws PropertyVetoException, TransactionFailure {
            List list = param.getNetworkListener();
            for (NetworkListener listener : list) {
                if (!listener.getName().equals(DeleteHttpListener.this.listenerId)) continue;
                list.remove(listener);
                DeleteHttpListener.this.cleanUp(listener);
                break;
            }
            return list;
        }
    }
}

