/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStatsTelemetry {
    private String moduleName;
    private String vsName;
    private TreeNode sessionNode = null;
    private Logger logger;
    private Collection<ProbeClientMethodHandle> handles;
    private boolean webMonitoringEnabled;
    private boolean isEnabled = true;
    private Counter activeSessionsCurrent = CounterFactory.createCount((long[])new long[0]);
    private Counter activeSessionsHigh = CounterFactory.createCount((long[])new long[0]);
    private Counter sessionsTotal = CounterFactory.createCount((long[])new long[0]);
    private Counter expiredSessionsTotal = CounterFactory.createCount((long[])new long[0]);
    private Counter rejectedSessionsTotal = CounterFactory.createCount((long[])new long[0]);
    private Counter persistedSessionsTotal = CounterFactory.createCount((long[])new long[0]);
    private Counter passivatedSessionsTotal = CounterFactory.createCount((long[])new long[0]);
    private Counter activatedSessionsTotal = CounterFactory.createCount((long[])new long[0]);

    public SessionStatsTelemetry(TreeNode parent, String moduleName, String vsName, boolean webMonitoringEnabled, Logger logger) {
        this.sessionNode = parent;
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
        this.webMonitoringEnabled = webMonitoringEnabled;
        this.activeSessionsCurrent.setName("activesessionscurrent-count");
        parent.addChild((TreeNode)this.activeSessionsCurrent);
        this.sessionsTotal.setName("sessionstotal-count");
        parent.addChild((TreeNode)this.sessionsTotal);
        this.activeSessionsHigh.setName("activesessionshigh-count");
        parent.addChild((TreeNode)this.activeSessionsHigh);
        this.rejectedSessionsTotal.setName("rejectedsessionstotal-count");
        parent.addChild((TreeNode)this.rejectedSessionsTotal);
        this.expiredSessionsTotal.setName("expiredsessionstotal-count");
        parent.addChild((TreeNode)this.expiredSessionsTotal);
        this.persistedSessionsTotal.setName("persistedsessionstotal-count");
        parent.addChild((TreeNode)this.persistedSessionsTotal);
        this.passivatedSessionsTotal.setName("passivatedsessionstotal-count");
        parent.addChild((TreeNode)this.passivatedSessionsTotal);
        this.activatedSessionsTotal.setName("activatedsessionstotal-count");
        parent.addChild((TreeNode)this.activatedSessionsTotal);
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            for (ProbeClientMethodHandle handle : this.handles) {
                if (flag) {
                    handle.enable();
                    continue;
                }
                handle.disable();
            }
            this.sessionNode.setEnabled(flag);
            if (this.isEnabled) {
                this.resetStats();
            }
            this.isEnabled = flag;
        }
    }

    @ProbeListener(value="web:session::sessionCreatedEvent")
    public void sessionCreatedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionCreatedEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.incrementActiveSessionsCurrent();
    }

    @ProbeListener(value="web:session::sessionDestroyedEvent")
    public void sessionDestroyedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionDestroyedEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
    }

    @ProbeListener(value="web:session::sessionRejectedEvent")
    public void sessionRejectedEvent(@ProbeParam(value="maxThresholdSize") int maxSessions, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionRejectedEvent received - max sessions = " + maxSessions + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.sessionsTotal.increment();
        this.rejectedSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionExpiredEvent")
    public void sessionExpiredEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionExpiredEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.expiredSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionPersistedStartEvent")
    public void sessionPersistedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPersistedStartEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="web:session::sessionPersistedEndEvent")
    public void sessionPersistedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPersistedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.persistedSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionActivatedStartEvent")
    public void sessionActivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionActivatedStartEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="web:session::sessionActivatedEndEvent")
    public void sessionActivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionActivatedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.incrementActiveSessionsCurrent();
        this.activatedSessionsTotal.increment();
    }

    @ProbeListener(value="web:session::sessionPassivatedStartEvent")
    public void sessionPassivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPassivatedStartEvent  received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="web:session::sessionPassivatedEndEvent")
    public void sessionPassivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPassivatedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.passivatedSessionsTotal.increment();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private void incrementActiveSessionsCurrent() {
        this.activeSessionsCurrent.increment();
        if (this.activeSessionsCurrent.getCount() > this.activeSessionsHigh.getCount()) {
            this.activeSessionsHigh.setCount(this.activeSessionsCurrent.getCount());
        }
        this.sessionsTotal.increment();
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.activeSessionsCurrent.setReset(true);
        this.activeSessionsHigh.setReset(true);
        this.sessionsTotal.setReset(true);
        this.expiredSessionsTotal.setReset(true);
        this.rejectedSessionsTotal.setReset(true);
        this.persistedSessionsTotal.setReset(true);
        this.passivatedSessionsTotal.setReset(true);
        this.activatedSessionsTotal.setReset(true);
    }
}

