/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class AMXBooter {
    public static final ObjectName AMX_BOOTER_OBJECT_NAME = JMXUtil.newObjectName("amx-support:name=booter");
    public static final String BOOT_AMX_OPERATION_NAME = "bootAMX";

    private AMXBooter() {
    }

    public static ObjectName bootAMX(MBeanServerConnection conn) {
        ObjectName domainRootObjectName = AMXBooter.findDomainRoot(conn);
        if (domainRootObjectName == null) {
            try {
                domainRootObjectName = (ObjectName)conn.invoke(AMX_BOOTER_OBJECT_NAME, BOOT_AMX_OPERATION_NAME, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return domainRootObjectName;
    }

    public static ObjectName findDomainRoot(MBeanServerConnection conn) {
        ObjectName objectName = null;
        ObjectName pattern = JMXUtil.newObjectName("amx:j2eeType=X-DomainRoot,*");
        try {
            Set<ObjectName> objectNames = JMXUtil.queryNames(conn, pattern, null);
            if (objectNames.size() > 1) {
                throw new IllegalStateException("Found more than one DomainRoot using " + pattern);
            }
            if (objectNames.size() == 1) {
                objectName = GSetUtil.getSingleton(objectNames);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }
}

