/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.FacesComponent;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.model.ManagedBean;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final String FACES_CONFIG_XML = "META-INF/faces-config.xml";
    private static final Set<String> FACES_ANNOTATIONS;
    private static final Set<Class<? extends Annotation>> FACES_ANNOTATION_TYPE;
    private ServletContext sc;
    private ClassFile classFileScanner;

    public AnnotationScanner(ServletContext sc) {
        this.sc = sc;
        this.classFileScanner = new ClassFile();
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses() {
        HashSet<String> classList = new HashSet<String>();
        this.processWebInfClasses(this.sc, classList);
        this.processWebInfLib(this.sc, classList);
        Map<Class<Annotation>, Set<Class<?>>> annotatedClasses = null;
        if (classList.size() > 0) {
            annotatedClasses = new HashMap(6, 1.0f);
            for (String className : classList) {
                try {
                    Annotation[] annotations;
                    Class clazz = Util.loadClass(className, this);
                    for (Annotation annotation : annotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annoType = annotation.annotationType();
                        if (!FACES_ANNOTATION_TYPE.contains(annoType)) continue;
                        Set<Class<?>> classes = annotatedClasses.get(annoType);
                        if (classes == null) {
                            classes = new HashSet();
                            annotatedClasses.put(annoType, classes);
                        }
                        classes.add(clazz);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}", className);
                }
            }
        }
        return annotatedClasses != null ? annotatedClasses : Collections.emptyMap();
    }

    private static boolean isAnnotation(String value) {
        return FACES_ANNOTATIONS.contains(value);
    }

    private void processWebInfLib(ServletContext sc, Set<String> classList) {
        Set entries = sc.getResourcePaths(WEB_INF_LIB);
        List<JarFile> jars = this.getJars(sc, entries);
        if (jars != null) {
            for (JarFile jar : jars) {
                this.processJarEntries(jar, classList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarEntries(JarFile jarFile, Set<String> classList) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Scanning JAR {0} for annotations...", jarFile.getName());
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = entry.getName()).startsWith("/META-INF") || !name.endsWith(".class")) continue;
            ReadableByteChannel channel = null;
            try {
                channel = Channels.newChannel(jarFile.getInputStream(entry));
                if (!this.classFileScanner.containsAnnotation(channel, entry.getSize())) continue;
                String cname = this.convertToClassName(name);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[JAR] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unexpected exception scanning JAR {0} for annotations", jarFile.getName());
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                if (channel == null) continue;
                try {
                    channel.close();
                }
                catch (IOException ignored) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, ignored.toString(), ignored);
                }
            }
        }
    }

    private List<JarFile> getJars(ServletContext sc, Set<String> entries) {
        ArrayList<JarFile> jars = null;
        if (entries != null && !entries.isEmpty()) {
            for (String entry : entries) {
                if (!entry.endsWith(".jar")) continue;
                try {
                    URL url = sc.getResource(entry);
                    StringBuilder sb = new StringBuilder(32);
                    sb.append("jar:").append(url.toString()).append("!/");
                    url = new URL(sb.toString());
                    JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                    if (jarFile.getJarEntry(FACES_CONFIG_XML) == null) continue;
                    if (jars == null) {
                        jars = new ArrayList<JarFile>();
                    }
                    jars.add(jarFile);
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
        return jars;
    }

    private void processWebInfClasses(ServletContext sc, Set<String> classList) {
        this.processWebInfClasses(sc, WEB_INF_CLASSES, classList);
    }

    private void processWebInfClasses(ServletContext sc, String path, Set<String> classList) {
        Set paths = sc.getResourcePaths(path);
        this.processWebInfClasses(sc, paths, classList);
    }

    private void processWebInfClasses(ServletContext sc, Set<String> paths, Set<String> classList) {
        if (paths != null && !paths.isEmpty()) {
            for (String pathElement : paths) {
                if (pathElement.endsWith("/")) {
                    this.processWebInfClasses(sc, pathElement, classList);
                    continue;
                }
                if (!pathElement.endsWith(".class") || !this.containsAnnotation(sc, pathElement)) continue;
                String cname = this.convertToClassName(WEB_INF_CLASSES, pathElement);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[WEB-INF/classes] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAnnotation(ServletContext sc, String pathElement) {
        Channel channel = null;
        try {
            URL url = sc.getResource(pathElement);
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            channel = Channels.newChannel(url.openStream());
            boolean bl = this.classFileScanner.containsAnnotation((ReadableByteChannel)channel, conn.getContentLength());
            return bl;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        finally {
            block19: {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException ignored) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.log(Level.FINE, ignored.toString(), ignored);
                    }
                }
            }
        }
        return false;
    }

    private String convertToClassName(String pathEntry) {
        return this.convertToClassName(null, pathEntry);
    }

    private String convertToClassName(String prefix, String pathEntry) {
        String className = pathEntry;
        if (prefix != null) {
            className = className.substring(prefix.length());
        }
        className = className.substring(0, className.length() - 6);
        return className.replace('/', '.');
    }

    static {
        HashSet annotations = new HashSet(6, 1.0f);
        Collections.addAll(annotations, "Ljavax/faces/component/FacesComponent;", "Ljavax/faces/convert/FacesConverter;", "Ljavax/faces/validator/FacesValidator;", "Ljavax/faces/render/FacesRenderer;", "Ljavax/faces/model/ManagedBean;", "Ljavax/faces/event/NamedEvent;");
        FACES_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        HashSet annotationInstances = new HashSet(6, 1.0f);
        Collections.addAll(annotationInstances, FacesComponent.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, ManagedBean.class, NamedEvent.class);
        FACES_ANNOTATION_TYPE = Collections.unmodifiableSet(annotationInstances);
    }

    private static final class ClassFile {
        private static final int magic = -889275714;
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_PRIVATE = 2;
        public static final int ACC_PROTECTED = 4;
        public static final int ACC_STATIC = 8;
        public static final int ACC_FINAL = 16;
        public static final int ACC_SYNCHRONIZED = 32;
        public static final int ACC_THREADSAFE = 64;
        public static final int ACC_TRANSIENT = 128;
        public static final int ACC_NATIVE = 256;
        public static final int ACC_INTERFACE = 512;
        public static final int ACC_ABSTRACT = 1024;
        public short majorVersion;
        public short minorVersion;
        public ConstantPoolInfo[] constantPool;
        public short accessFlags;
        public ConstantPoolInfo thisClass;
        public ConstantPoolInfo superClass;
        public ConstantPoolInfo[] interfaces;
        ByteBuffer header;
        ConstantPoolInfo constantPoolInfo = new ConstantPoolInfo();

        public ClassFile() {
            this.header = ByteBuffer.allocate(12000);
        }

        public void setConstantPoolInfo(ConstantPoolInfo poolInfo) {
            this.constantPoolInfo = poolInfo;
        }

        public boolean containsAnnotation(ReadableByteChannel in, long size) throws IOException {
            this.header.clear();
            if (size != -1L && size > (long)this.header.capacity()) {
                this.header = ByteBuffer.allocate((int)size);
            }
            long read = in.read(this.header);
            if (size != -1L && read != size) {
                return false;
            }
            this.header.rewind();
            if (this.header.getInt() != -889275714) {
                return false;
            }
            this.majorVersion = this.header.getShort();
            this.minorVersion = this.header.getShort();
            short constantPoolSize = this.header.getShort();
            return this.constantPoolInfo.containsAnnotation(constantPoolSize, this.header);
        }
    }

    private static class ConstantPoolInfo {
        private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
        public static final byte CLASS = 7;
        public static final int FIELDREF = 9;
        public static final int METHODREF = 10;
        public static final int STRING = 8;
        public static final int INTEGER = 3;
        public static final int FLOAT = 4;
        public static final int LONG = 5;
        public static final int DOUBLE = 6;
        public static final int INTERFACEMETHODREF = 11;
        public static final int NAMEANDTYPE = 12;
        public static final int ASCIZ = 1;
        public static final int UNICODE = 2;
        byte[] bytes = new byte[Short.MAX_VALUE];

        public boolean containsAnnotation(int constantPoolSize, ByteBuffer buffer) throws IOException {
            block7: for (int i = 1; i < constantPoolSize; ++i) {
                byte type = buffer.get();
                switch (type) {
                    case 1: 
                    case 2: {
                        String stringValue;
                        short length = buffer.getShort();
                        if (length < 0 || length > Short.MAX_VALUE) {
                            return true;
                        }
                        buffer.get(this.bytes, 0, length);
                        if (this.bytes[0] != 76 || this.bytes[1] != 106 || this.bytes[2] != 97 || !AnnotationScanner.isAnnotation(stringValue = type == 1 ? new String(this.bytes, 0, (int)length, "US-ASCII") : new String(this.bytes, 0, (int)length))) continue block7;
                        return true;
                    }
                    case 7: 
                    case 8: {
                        buffer.getShort();
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: {
                        buffer.position(buffer.position() + 4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        buffer.position(buffer.position() + 8);
                        ++i;
                        continue block7;
                    }
                    case 12: {
                        buffer.getShort();
                        buffer.getShort();
                        continue block7;
                    }
                    default: {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue block7;
                        LOGGER.log(Level.SEVERE, "Unknow type constant pool {0} at position {1}", new Object[]{type, i});
                    }
                }
            }
            return false;
        }
    }
}

