/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentOrderingWrapper {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static Comparator<DocumentOrderingWrapper> COMPARATOR = new DocumentOrderingComparator();
    private static final int MAX_SORT_PASSED = 1000;
    private static final String ORDERING = "ordering";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String NAME = "name";
    private static final String OTHERS = "others";
    private static final String OTHERS_KEY = DocumentOrderingWrapper.class.getName() + ".OTHERS_KEY";
    private static final int SWAP = -1;
    private static final int DO_NOT_SWAP = 0;
    private Document document;
    private String id;
    private String[] beforeIds;
    private String[] afterIds;

    public DocumentOrderingWrapper(Document document) {
        this.document = document;
        this.init();
    }

    public Document getDocument() {
        return this.document;
    }

    public String getDocumentId() {
        return this.id;
    }

    public String[] getBeforeIds() {
        return this.beforeIds;
    }

    public String[] getAfterIds() {
        return this.afterIds;
    }

    public boolean isBeforeOrdered() {
        return this.beforeIds.length != 0;
    }

    public boolean isAfterOrdered() {
        return this.afterIds.length != 0;
    }

    public boolean isOrdered() {
        return this.isBeforeOrdered() || this.isAfterOrdered();
    }

    public boolean isBefore(String id) {
        return DocumentOrderingWrapper.search(this.beforeIds, id);
    }

    public boolean isAfter(String id) {
        return DocumentOrderingWrapper.search(this.afterIds, id);
    }

    public boolean isAfterOthers() {
        return DocumentOrderingWrapper.search(this.afterIds, OTHERS_KEY);
    }

    public boolean isBeforeOthers() {
        return DocumentOrderingWrapper.search(this.beforeIds, OTHERS_KEY);
    }

    public String toString() {
        return "Document{id='" + this.id + '\'' + ", beforeIds=" + (this.beforeIds == null ? null : Arrays.asList(this.beforeIds)) + ", afterIds=" + (this.afterIds == null ? null : Arrays.asList(this.afterIds)) + '}';
    }

    public static void sort(DocumentOrderingWrapper[] documents) {
        Timer t = Timer.getInstance();
        if (t != null) {
            t.startTiming();
        }
        try {
            DocumentOrderingWrapper.enhanceOrderingData(documents);
        }
        catch (CircularDependencyException re) {
            String msg = "Circular dependencies detected!\nDocument Info\n==================\n";
            for (DocumentOrderingWrapper w : documents) {
                msg = msg + "  " + w.toString() + '\n';
            }
            throw new ConfigurationException(msg);
        }
        boolean doMore = true;
        int numberOfPasses = 0;
        while (doMore) {
            if (++numberOfPasses == 1000) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    String msg = "Exceeded maximum number of attempts to sort the application's faces-config documents.\nDocument Info\n==================";
                    for (DocumentOrderingWrapper w : documents) {
                        msg = msg + "  " + w.toString() + '\n';
                    }
                    LOGGER.severe(msg);
                }
                throw new ConfigurationException("Exceeded maximum number of attempts to sort the faces-config documents.");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Starting sort pass number {0}...", numberOfPasses);
            }
            doMore = false;
            for (int i = 0; i < documents.length - 1; ++i) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Comparing {0}, {1}", new Object[]{documents[i].id, documents[i + 1].id});
                }
                if (COMPARATOR.compare(documents[i], documents[i + 1]) == 0) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Swapping {0} with {1}", new Object[]{documents[i].id, documents[i + 1].id});
                }
                DocumentOrderingWrapper temp = documents[i];
                documents[i] = documents[i + 1];
                documents[i + 1] = temp;
                doMore = true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Comparing {0}, {1}", new Object[]{documents[0].id, documents[documents.length - 1].id});
            }
            if (COMPARATOR.compare(documents[0], documents[documents.length - 1]) == 0) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Swapping {0} with {1}", new Object[]{documents[0].id, documents[documents.length - 1].id});
            }
            DocumentOrderingWrapper temp = documents[0];
            documents[0] = documents[documents.length - 1];
            documents[documents.length - 1] = temp;
            doMore = true;
        }
        if (t != null) {
            t.stopTiming();
            t.logResult("\"faces-config\" document sorting complete in " + numberOfPasses + '.');
        }
    }

    private static void enhanceOrderingData(DocumentOrderingWrapper[] wrappers) throws CircularDependencyException {
        for (int i = 0; i < wrappers.length; ++i) {
            Object[] temp;
            DocumentOrderingWrapper other;
            int ii;
            DocumentOrderingWrapper w = wrappers[i];
            for (String id : w.getBeforeIds()) {
                if (OTHERS_KEY.equals(id)) continue;
                for (ii = 0; ii < wrappers.length; ++ii) {
                    String[] otherBeforeIds;
                    other = wrappers[ii];
                    if (!id.equals(other.id)) continue;
                    Object[] afterIds = other.getAfterIds();
                    if (Arrays.binarySearch(afterIds, w.id) < 0) {
                        HashSet<Object> newAfterIds = new HashSet<Object>(afterIds.length + 1);
                        newAfterIds.addAll(Arrays.asList(afterIds));
                        newAfterIds.add(w.id);
                        other.afterIds = newAfterIds.toArray(new String[newAfterIds.size()]);
                        Arrays.sort(other.afterIds);
                    }
                    if ((otherBeforeIds = other.getBeforeIds()).length <= 0) continue;
                    String[] currentBeforeIds = w.getBeforeIds();
                    HashSet<String> newBeforeIds = new HashSet<String>();
                    newBeforeIds.addAll(Arrays.asList(currentBeforeIds));
                    for (String bid : otherBeforeIds) {
                        if (OTHERS_KEY.equals(bid)) continue;
                        newBeforeIds.add(bid);
                    }
                    temp = newBeforeIds.toArray(new String[newBeforeIds.size()]);
                    Arrays.sort(temp);
                    if (DocumentOrderingWrapper.search((String[])temp, w.id)) {
                        throw new CircularDependencyException();
                    }
                    w.beforeIds = temp;
                }
            }
            for (String id : w.getAfterIds()) {
                if (OTHERS_KEY.equals(id)) continue;
                for (ii = 0; ii < wrappers.length; ++ii) {
                    String[] otherAfterIds;
                    other = wrappers[ii];
                    if (!id.equals(other.id)) continue;
                    Object[] beforeIds = other.getBeforeIds();
                    if (Arrays.binarySearch(beforeIds, w.id) < 0) {
                        HashSet<Object> newBeforeIds = new HashSet<Object>(beforeIds.length + 1);
                        newBeforeIds.addAll(Arrays.asList(beforeIds));
                        newBeforeIds.add(w.id);
                        other.beforeIds = newBeforeIds.toArray(new String[newBeforeIds.size()]);
                        Arrays.sort(other.beforeIds);
                    }
                    if ((otherAfterIds = other.getAfterIds()).length <= 0) continue;
                    String[] currentAfterIds = w.getAfterIds();
                    HashSet<String> newAfterIds = new HashSet<String>();
                    newAfterIds.addAll(Arrays.asList(currentAfterIds));
                    for (String bid : otherAfterIds) {
                        if (OTHERS_KEY.equals(bid)) continue;
                        newAfterIds.add(bid);
                    }
                    temp = newAfterIds.toArray(new String[newAfterIds.size()]);
                    Arrays.sort(temp);
                    if (DocumentOrderingWrapper.search((String[])temp, w.id)) {
                        throw new CircularDependencyException();
                    }
                    w.afterIds = temp;
                }
            }
        }
    }

    private static boolean search(String[] ids, String id) {
        return Arrays.binarySearch(ids, id) >= 0;
    }

    private void init() {
        Element documentElement = this.document.getDocumentElement();
        String namespace = documentElement.getNamespaceURI();
        this.id = this.getDocumentName(documentElement);
        NodeList orderingElements = documentElement.getElementsByTagNameNS(namespace, ORDERING);
        Set<String> beforeIds = null;
        Set<String> afterIds = null;
        if (orderingElements.getLength() > 0) {
            int len = orderingElements.getLength();
            for (int i = 0; i < len; ++i) {
                Node orderingNode = orderingElements.item(i);
                NodeList children = orderingNode.getChildNodes();
                int jlen = children.getLength();
                for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (beforeIds == null) {
                        beforeIds = this.extractIds(n, BEFORE);
                    }
                    if (afterIds != null) continue;
                    afterIds = this.extractIds(n, AFTER);
                }
            }
        }
        this.beforeIds = beforeIds != null ? beforeIds.toArray(new String[beforeIds.size()]) : new String[]{};
        this.afterIds = afterIds != null ? afterIds.toArray(new String[afterIds.size()]) : new String[]{};
        Arrays.sort(this.beforeIds);
        Arrays.sort(this.afterIds);
        this.checkDuplicates(this.beforeIds, this.afterIds);
        this.checkDuplicates(this.afterIds, this.beforeIds);
    }

    private String getDocumentName(Element documentElement) {
        NodeList children = documentElement.getChildNodes();
        String documentName = "";
        if (children != null && children.getLength() > 0) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = children.item(i);
                if (!NAME.equals(n.getLocalName())) continue;
                documentName = this.getNodeText(n);
                break;
            }
        }
        return documentName;
    }

    private void checkDuplicates(String[] source, String[] searchTarget) {
        for (String id : source) {
            if (!DocumentOrderingWrapper.search(searchTarget, id)) continue;
            String msg = MessageFormat.format("Document {0} is specified to come before and after {1}.", this.document.getDocumentURI(), id);
            throw new ConfigurationException(msg);
        }
    }

    private Set<String> extractIds(Node n, String nodeName) {
        HashSet<String> idsList = null;
        if (nodeName.equals(n.getLocalName())) {
            idsList = new HashSet<String>();
            NodeList ids = n.getChildNodes();
            int klen = ids.getLength();
            for (int k = 0; k < klen; ++k) {
                String id;
                Node idNode = ids.item(k);
                if (NAME.equals(idNode.getLocalName()) && (id = this.getNodeText(idNode)) != null) {
                    idsList.add(id);
                }
                if (!OTHERS.equals(idNode.getLocalName()) || this.id == null) continue;
                idsList.add(OTHERS_KEY);
            }
        }
        return idsList;
    }

    private String getNodeText(Node node) {
        String res = null;
        if (node != null && (res = node.getTextContent()) != null) {
            res = res.trim();
        }
        return res != null && res.length() != 0 ? res : null;
    }

    private static final class CircularDependencyException
    extends Exception {
        public CircularDependencyException() {
        }

        public CircularDependencyException(String message) {
            super(message);
        }

        public CircularDependencyException(String message, Throwable cause) {
            super(message, cause);
        }

        public CircularDependencyException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DocumentOrderingComparator
    implements Comparator<DocumentOrderingWrapper> {
        private DocumentOrderingComparator() {
        }

        @Override
        public int compare(DocumentOrderingWrapper wrapper1, DocumentOrderingWrapper wrapper2) {
            String w1Id = wrapper1.id;
            String w2Id = wrapper2.id;
            boolean w1IsOrdered = wrapper1.isOrdered();
            boolean w2IsOrdered = wrapper2.isOrdered();
            if (w1IsOrdered && !w2IsOrdered && wrapper1.isAfterOrdered() && !wrapper1.isBeforeOthers()) {
                return -1;
            }
            boolean w2IsBeforeW1 = wrapper2.isBefore(w1Id);
            boolean w1IsAfterW2 = wrapper1.isAfter(w2Id);
            if (w2IsBeforeW1 || w1IsAfterW2) {
                return -1;
            }
            boolean w1IsAfterOthers = wrapper1.isAfterOthers();
            if (!(!w1IsAfterOthers || wrapper1.isBefore(w2Id) || wrapper1.isAfterOthers() && wrapper2.isAfterOthers())) {
                return -1;
            }
            boolean w2IsBeforeOthers = wrapper2.isBeforeOthers();
            if (!(!w2IsBeforeOthers || wrapper2.isAfter(w1Id) || wrapper1.isBeforeOthers() && wrapper2.isBeforeOthers())) {
                return -1;
            }
            return 0;
        }
    }
}

