/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.LoggerUtils;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorFactory {
    public static final int DEFAULT_MAX_SELECTORS = 20;
    public static long timeout = 5000L;
    private static int maxSelectors = 20;
    private static final Stack<Selector> selectors = new Stack();
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setMaxSelectors(int size) throws IOException {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            if (size > maxSelectors || !initialized) {
                if (!initialized) {
                    maxSelectors = 0;
                }
                SelectorFactory.grow(size);
            } else if (size < maxSelectors) {
                SelectorFactory.reduce(size);
            }
            maxSelectors = size;
            initialized = true;
        }
    }

    public static final int getMaxSelectors() {
        return maxSelectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector getSelector() {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            block14: {
                if (!initialized) {
                    try {
                        SelectorFactory.setMaxSelectors(maxSelectors);
                    }
                    catch (IOException e) {
                        Logger logger = LoggerUtils.getLogger();
                        if (!logger.isLoggable(Level.WARNING)) break block14;
                        logger.log(Level.WARNING, "SelectorFactory lazy initialization", e);
                    }
                }
            }
            Selector s = null;
            try {
                if (selectors.size() != 0) {
                    s = selectors.pop();
                }
            }
            catch (EmptyStackException ex) {
                // empty catch block
            }
            try {
                for (int attempts = 0; s == null && attempts < 2; ++attempts) {
                    selectors.wait(timeout);
                    try {
                        if (selectors.size() == 0) continue;
                        s = selectors.pop();
                        continue;
                    }
                    catch (EmptyStackException ex) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void returnSelector(Selector s) {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            selectors.push(s);
            if (selectors.size() == 1) {
                selectors.notify();
            }
        }
    }

    public static final void selectNowAndReturnSelector(Selector s) {
        try {
            s.selectNow();
            SelectorFactory.returnSelector(s);
        }
        catch (IOException e) {
            Logger logger = LoggerUtils.getLogger();
            logger.log(Level.WARNING, "Unexpected problem when releasing temporary Selector", e);
            try {
                s.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                SelectorFactory.reimburseSelector();
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Problematic Selector could not be reimbursed!", ee);
            }
        }
    }

    public static final void reimburseSelector() throws IOException {
        SelectorFactory.returnSelector(SelectorFactory.createSelector());
    }

    protected static Selector createSelector() throws IOException {
        return Selector.open();
    }

    private static void grow(int size) throws IOException {
        for (int i = 0; i < size - maxSelectors; ++i) {
            selectors.add(SelectorFactory.createSelector());
        }
    }

    private static void reduce(int size) {
        for (int i = 0; i < maxSelectors - size; ++i) {
            try {
                Selector selector = selectors.pop();
                selector.close();
                continue;
            }
            catch (IOException e) {
                Logger logger = LoggerUtils.getLogger();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "SelectorFactory.reduce", e);
            }
        }
    }
}

