/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.AdminObjectManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-admin-object")
@Scoped(value=PerLookup.class)
@I18n(value="create.admin.object")
public class CreateAdminObject
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateAdminObject.class);
    @Param(name="restype")
    String resType;
    @Param(name="raname")
    String raName;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        HashMap<String, Object> attrList = new HashMap<String, Object>();
        attrList.put("res-type", this.resType);
        attrList.put("enabled", this.enabled);
        attrList.put("jndi-name", this.jndiName);
        attrList.put("description", this.description);
        attrList.put("res-adapter", this.raName);
        try {
            AdminObjectManager adminObjMgr = new AdminObjectManager();
            rs = adminObjMgr.create(this.resources, attrList, this.properties, targetServer);
        }
        catch (Exception e) {
            String actual = e.getMessage();
            String def = "Admin object: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.admin.object.fail", def, new Object[]{this.jndiName, actual}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            } else {
                report.setMessage(localStrings.getLocalString("create.admin.object.fail", "Admin object {0} creation failed", new Object[]{this.jndiName, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

