/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Image;
import com.sun.pkg.util.PEMUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;

class AuthProxy
extends Proxy {
    String user = null;
    String password = null;

    AuthProxy(Proxy.Type type, SocketAddress sa) {
        super(type, sa);
    }

    AuthProxy(Proxy.Type type, SocketAddress sa, String username, String passwd) {
        super(type, sa);
        this.user = username;
        this.password = passwd;
        if (this.user != null) {
            Authenticator.setDefault(new MyAuthenticator());
        }
    }

    private static AuthProxy newProxy(URL proxyURL) {
        String pHost = proxyURL.getHost();
        int pPort = proxyURL.getPort();
        String userInfo = proxyURL.getUserInfo();
        String user = null;
        String password = null;
        if (userInfo != null && userInfo.length() != 0) {
            String[] tokens = userInfo.split(":", 2);
            user = tokens[0];
            password = tokens[1];
        }
        InetSocketAddress addr = new InetSocketAddress(pHost, pPort);
        return new AuthProxy(Proxy.Type.HTTP, addr, user, password);
    }

    public String toString() {
        String s = "";
        InetSocketAddress ia = (InetSocketAddress)this.address();
        switch (this.type()) {
            case DIRECT: {
                s = "Direct";
                break;
            }
            case HTTP: {
                s = "http://";
                break;
            }
            case SOCKS: {
                s = "socks:";
                break;
            }
            default: {
                s = "";
            }
        }
        if (this.user == null) {
            return s + ia.getHostName() + ":" + ia.getPort();
        }
        StringBuffer sb = new StringBuffer("");
        if (this.password != null) {
            for (int n = this.password.length(); n > 0; --n) {
                sb.append('*');
            }
        }
        return s + this.user + ":" + sb + "@" + ia.getHostName() + ":" + ia.getPort();
    }

    public static void main(String[] args) throws Exception {
        URL url;
        AuthProxy proxy = null;
        String pString = System.getenv("http_proxy");
        if (pString == null) {
            pString = System.getenv("HTTP_PROXY");
        }
        if (pString != null) {
            try {
                url = new URL(pString);
                proxy = AuthProxy.newProxy(url);
            }
            catch (Exception e) {
                System.out.println(e);
                System.exit(1);
            }
        }
        if (args.length == 0) {
            System.exit(0);
        }
        url = new URL(args[0]);
        URLConnection urlc = null;
        if (proxy == null) {
            urlc = url.openConnection();
        } else {
            System.out.println("Proxy: " + ((Proxy)proxy).toString());
            urlc = url.openConnection(proxy);
        }
        if (urlc instanceof HttpsURLConnection) {
            HttpsURLConnection sslurlc = (HttpsURLConnection)urlc;
            sslurlc.setSSLSocketFactory(PEMUtil.getSSLSocketFactory(new File("certificate.pem"), new File("key.pem")));
        }
        HttpURLConnection hurlc = (HttpURLConnection)urlc;
        hurlc.setRequestProperty("User-Agent", Image.userAgent);
        BufferedReader br = new BufferedReader(new InputStreamReader(hurlc.getInputStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
    }

    private class MyAuthenticator
    extends Authenticator {
        private MyAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                return null;
            }
            String protocol = this.getRequestingProtocol();
            if (!protocol.equalsIgnoreCase("http")) {
                return null;
            }
            if (AuthProxy.this.user == null) {
                return null;
            }
            return new PasswordAuthentication(AuthProxy.this.user, AuthProxy.this.password == null ? null : AuthProxy.this.password.toCharArray());
        }
    }
}

