/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.Log;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.FileFilter;
import java.net.Socket;
import java.util.Set;
import java.util.logging.Level;

public class StopDomainCommand
extends AbstractCommand {
    private File domainsDir;
    private File domainRootDir;
    private String domainName;
    private File domainXml;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.getDomainRootDir();
        this.getDomainXml();
        this.domainRootDir = SmartFile.sanitize((File)this.domainRootDir);
        Integer[] ports = null;
        try {
            MiniXmlParser parser = new MiniXmlParser(this.domainXml);
            Set portsSet = parser.getAdminPorts();
            ports = portsSet.toArray(new Integer[portsSet.size()]);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandValidationException(strings.get("StopDomain.parserError", new Object[]{ex}), ex);
        }
        int adminPort = ports[0];
        if (!this.isServerAlive(adminPort)) {
            throw new CommandException(strings.get("StopDomain.dasNotRunning"));
        }
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            this.invokeCommand(adminPort);
            this.waitForDeath(adminPort);
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        String domaindir;
        super.validateOptions();
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.firstElement();
        }
        if (StopDomainCommand.ok(domaindir = this.getOption("domaindir"))) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
            }
        }
        return true;
    }

    private void invokeCommand(int port) throws CommandException {
        CommandInvoker invoker = new CommandInvoker("stop-domain");
        invoker.put("port", "" + port);
        invoker.put("user", this.getOption("user"));
        invoker.put("passwordfile", this.getOption("passwordfile"));
        invoker.put("force", this.getOption("force"));
        invoker.invoke();
    }

    private void getDomainRootDir() throws CommandValidationException {
        if (this.domainsDir == null) {
            this.domainsDir = new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        this.domainRootDir = this.domainName != null ? new File(this.domainsDir, this.domainName) : this.getTheOneAndOnlyDomain(this.domainsDir);
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainDir", new Object[]{this.domainRootDir}));
        }
    }

    private void getDomainXml() throws CommandValidationException {
        this.domainXml = new File(this.domainRootDir, "config/domain.xml");
        if (!this.domainXml.canRead()) {
            throw new CommandValidationException(strings.get("StopDomain.noDomainXml", new Object[]{this.domainXml}));
        }
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("StopDomain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    private void waitForDeath(int adminPort) throws CommandException {
        long startWait = System.currentTimeMillis();
        System.err.print(strings.get("StopDomain.WaitDASDeath") + " ");
        boolean alive = true;
        while (!this.timedOut(startWait)) {
            if (!this.pingPort(adminPort)) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                System.err.print(".");
            }
            catch (InterruptedException ex) {}
        }
        System.err.println("");
        if (alive) {
            throw new CommandException(strings.get("StopDomain.DASNotDead", new Object[]{60L}));
        }
    }

    private boolean pingPort(int port) {
        try {
            String host = null;
            new Socket(host, port);
            return true;
        }
        catch (Exception ex) {
            Log.finer("pingPort got Exception: " + ex, new Object[0]);
            return false;
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean isServerAlive(int port) {
        CommandInvoker invoker = new CommandInvoker("version");
        invoker.put("port", "" + port);
        invoker.put("user", this.getOption("user"));
        invoker.put("passwordfile", this.getOption("passwordfile"));
        return CLIRemoteCommand.pingDASQuietly(invoker);
    }
}

